/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.layout.CellConstraints;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryField;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarEventEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.gui.GroupRenderer;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class CalendarEntryRelationPanel
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarEntryRelationPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarEntryRelationPanel.class);
    private long currentEntryId = 0L;
    private long currentGroupId = 0L;
    private JXTitledSeparator formTitle;
    private JLabel entryLabel;
    private CalendarEntryField entryField;
    private JPanel entryFieldPanel;
    private JComboBox<DbCalendarGroup> groupField;
    private JLabel notesLabel;
    private DefaultTextArea notesField;

    public CalendarEntryRelationPanel(boolean bl) {
        this.build(bl);
    }

    private void build(boolean bl) {
        this.entryLabel = new JLabel();
        this.entryField = new CalendarEntryField();
        this.entryFieldPanel = new JPanel(new BorderLayout());
        this.entryFieldPanel.add((Component)((Object)this.entryField), "Center");
        this.groupField = new JComboBox();
        this.groupField.setRenderer((ListCellRenderer<DbCalendarGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("select calendar") + " ]";
            }
        }));
        this.groupField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CalendarEntryRelationPanel.this.groupField.isEnabled()) {
                    return;
                }
                DbCalendarGroup dbCalendarGroup = (DbCalendarGroup)CalendarEntryRelationPanel.this.groupField.getSelectedItem();
                DbCalendarEntry dbCalendarEntry = CalendarEntryRelationPanel.this.entryField.getCalendarEntry();
                if (dbCalendarGroup == null) {
                    CalendarEntryRelationPanel.this.entryField.setCalendarEntry(null);
                    CalendarEntryRelationPanel.this.entryField.setCalendarGroupId(0L);
                    CalendarEntryRelationPanel.this.entryField.setEnabled(false);
                } else {
                    if (dbCalendarEntry != null && dbCalendarEntry.groupId != dbCalendarGroup.id) {
                        CalendarEntryRelationPanel.this.entryField.setCalendarEntry(null);
                    }
                    CalendarEntryRelationPanel.this.entryField.setCalendarGroupId(dbCalendarGroup.id);
                    CalendarEntryRelationPanel.this.entryField.setEnabled(true);
                }
            }
        });
        this.notesLabel = null;
        this.notesField = null;
        JScrollPane jScrollPane = null;
        if (bl) {
            this.notesLabel = new JLabel();
            this.notesField = new DefaultTextArea();
            jScrollPane = this.notesField.createScrollPane();
            jScrollPane.setPreferredSize(new Dimension(100, 100));
        }
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (Action[])new Action[]{new RelationSubmitAction(), new RelationCloseAction()});
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, pref, 3dlu, pref:grow", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.entryLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.groupField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.entryFieldPanel).xy(5, defaultFormBuilder.row());
        if (jScrollPane != null) {
            defaultFormBuilder.add((Component)this.notesLabel).xy(1, defaultFormBuilder.nextRow(), CellConstraints.DEFAULT, CellConstraints.TOP);
            defaultFormBuilder.addRaw((Component)jScrollPane).xyw(3, defaultFormBuilder.row(), 3);
        }
        this.updateLocalization();
    }

    protected abstract void close();

    private void doRelationClose() {
        this.unselectRelation();
        this.close();
    }

    private void doRelationSubmit() {
        String string;
        DbCalendarGroup dbCalendarGroup = (DbCalendarGroup)this.groupField.getSelectedItem();
        DbCalendarEntry dbCalendarEntry = this.entryField.getCalendarEntry();
        String string2 = string = this.notesField != null ? this.notesField.getText().trim() : null;
        if (dbCalendarGroup == null || dbCalendarEntry == null) {
            return;
        }
        if (this.submit(dbCalendarGroup, dbCalendarEntry, string)) {
            this.unselectRelation();
        }
    }

    public long getCurrentCalendarEntryId() {
        return this.currentEntryId;
    }

    public long getCurrentCalendarGroupId() {
        return this.currentGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Connection connection, DbCalendarHandler dbCalendarHandler) throws SQLException {
        DefaultComboBoxModel<DbCalendarGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbCalendarGroup>();
        defaultComboBoxModel.addElement(null);
        try {
            for (DbCalendarGroup dbCalendarGroup : dbCalendarHandler.getGroups(connection)) {
                defaultComboBoxModel.addElement(dbCalendarGroup);
            }
        }
        finally {
            this.setCalendarGroupsModel(defaultComboBoxModel);
        }
    }

    private void selectCurrentCalendarGroup() {
        this.groupField.setSelectedIndex(0);
        if (this.currentGroupId > 0L) {
            for (int i = 0; i < this.groupField.getItemCount(); ++i) {
                DbCalendarGroup dbCalendarGroup = this.groupField.getItemAt(i);
                if (dbCalendarGroup == null || dbCalendarGroup.id != this.currentGroupId) continue;
                this.groupField.setSelectedIndex(i);
                break;
            }
        }
    }

    public void selectEmptyRelation() {
        this.selectRelation(new DbCalendarEventEntry(), null);
    }

    public void selectRelation(CalendarEntry calendarEntry, String string) {
        if (calendarEntry == null) {
            this.setVisible(false);
            return;
        }
        if (!(calendarEntry instanceof DbCalendarEntry)) {
            this.setVisible(false);
            return;
        }
        DbCalendarEntry dbCalendarEntry = (DbCalendarEntry)calendarEntry;
        this.currentEntryId = dbCalendarEntry.id;
        this.currentGroupId = dbCalendarEntry.groupId;
        if (this.notesField != null) {
            this.notesField.setText(StringUtils.trimToEmpty((String)string));
            this.notesField.setCaretPosition(0);
        }
        this.groupField.setEnabled(false);
        this.groupField.setSelectedItem(null);
        this.entryField.setEnabled(false);
        if (this.currentGroupId < 1L) {
            this.groupField.setEnabled(true);
            this.entryField.setCalendarGroupId(0L);
            this.entryField.setCalendarEntry(null);
        } else {
            this.selectCurrentCalendarGroup();
            this.groupField.setEnabled(true);
            this.entryField.setCalendarGroupId(dbCalendarEntry.groupId);
            this.entryField.setCalendarEntry(dbCalendarEntry);
            this.entryField.setCaretPosition(0);
            this.entryField.setEnabled(true);
        }
        this.updateLocalization();
        this.setVisible(true);
    }

    public void setCalendarGroupsModel(ComboBoxModel<DbCalendarGroup> comboBoxModel) {
        this.groupField.setEnabled(false);
        this.groupField.setModel(comboBoxModel);
        this.groupField.setSelectedIndex(0);
        this.selectCurrentCalendarGroup();
        this.groupField.setEnabled(true);
    }

    public abstract boolean submit(DbCalendarGroup var1, DbCalendarEntry var2, String var3);

    public void unselectRelation() {
        this.selectRelation(null, null);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(this.currentEntryId > 0L ? StringUtils.capitalize((String)I18N.tr("edit assignment")) : StringUtils.capitalize((String)I18N.tr("add assignment")));
        this.entryLabel.setText(StringUtils.capitalize((String)I18N.tr("calendar entry")) + ":");
        if (this.notesLabel != null) {
            this.notesLabel.setText(StringUtils.capitalize((String)I18N.tr("notes")) + ":");
        }
    }

    private class RelationSubmitAction
    extends AbstractI18nAction {
        private RelationSubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarEntryRelationPanel.this.doRelationSubmit();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Submit assignment."));
        }
    }

    private class RelationCloseAction
    extends AbstractI18nAction {
        private RelationCloseAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarEntryRelationPanel.this.doRelationClose();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close assignment."));
        }
    }
}

