/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolFrame;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolProjectPlugin;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskContainer;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryViewPanel;
import com.openindex.openestate.tool.calendar.CalendarEntryViewTask;
import com.openindex.openestate.tool.calendar.CalendarFrameSidebarExtension;
import com.openindex.openestate.tool.calendar.CalendarPermission;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.CalendarSourceDialog;
import com.openindex.openestate.tool.calendar.CalendarSyncTask;
import com.openindex.openestate.tool.calendar.CalendarViewPanel;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.extensions.DbCalendarExtension;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbPluginHandler;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.db.DbUserHandler;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.utils.ProjectPermission;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class CalendarPlugin
extends ImmoToolProjectPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarPlugin.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarPlugin.class);
    public static final String ID = "OpenEstate-Tool-Calendar";
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/calendar/resources/";
    private static final String USER_WORKTIME_BEGIN = "worktime.begin";
    private static final String USER_WORKTIME_END = "worktime.end";
    private static final String USER_VIRTUAL_CALENDARS = "virtualCalendars";
    private static Calendar worktimeBegin = null;
    private static Calendar worktimeEnd = null;
    private static List<String> virtualCalendarIds = null;
    private static DbCalendarExtension dbCalendarExtension = null;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public static DbCalendarExtension getDbCalendarExtension() {
        return dbCalendarExtension;
    }

    public String getDescription() {
        return I18N.tr("Management of tasks & events based on the iCal specifications.");
    }

    public ImageIcon getIcon() {
        return new ImageIcon(CalendarPlugin.getResourceImage("vcalendar.png", 32));
    }

    public String getId() {
        return ID;
    }

    public static CalendarPlugin getInstance() {
        return (CalendarPlugin)ImmoToolEnvironment.getPlugin((String)ID);
    }

    public String getLicense() {
        return "Freeware";
    }

    public ProjectPermission[] getPermissions() {
        return CalendarPermission.values();
    }

    public String[] getRequiredProcedures() {
        return dbCalendarExtension != null ? dbCalendarExtension.getRequiredProcedures() : null;
    }

    public String[] getRequiredViews() {
        return dbCalendarExtension != null ? dbCalendarExtension.getRequiredViews() : null;
    }

    public static Icon getResourceIcon(String string, int n) {
        return ImmoToolUtils.getResourceIcon((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)CalendarPlugin.class.getClassLoader());
    }

    public static Image getResourceImage(String string, int n) {
        return ImmoToolUtils.getResourceImage((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)CalendarPlugin.class.getClassLoader());
    }

    public static URL getResourceImageURL(String string, int n) {
        return ImmoToolUtils.getResourceImageURL((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)CalendarPlugin.class.getClassLoader());
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("calendar"));
    }

    public String getUninstallQuery(String string) throws IOException {
        DbCalendarExtension dbCalendarExtension = CalendarPluginUtils.getDbCalendarExtension(string);
        if (dbCalendarExtension == null) {
            throw new IOException("Can't find a DbCalendarExtension for driver '" + string + "'!");
        }
        return dbCalendarExtension.getUninstallQuery();
    }

    public DbUpdateHandler getUpdateHandler(String string) {
        DbCalendarExtension dbCalendarExtension = CalendarPluginUtils.getDbCalendarExtension(string);
        if (dbCalendarExtension == null) {
            LOGGER.warn("Can't find a DbCalendarExtension for driver '" + string + "'!");
            return null;
        }
        return dbCalendarExtension.getUpdateHandler();
    }

    public static List<VirtualCalendarExtension> getVirtualCalendars() {
        ArrayList<VirtualCalendarExtension> arrayList = new ArrayList<VirtualCalendarExtension>();
        if (virtualCalendarIds == null) {
            arrayList.addAll(CalendarPluginUtils.getVirtualCalendarExtensions());
        } else {
            for (VirtualCalendarExtension virtualCalendarExtension : CalendarPluginUtils.getVirtualCalendarExtensions()) {
                if (!virtualCalendarIds.contains(virtualCalendarExtension.getId())) continue;
                arrayList.add(virtualCalendarExtension);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static Calendar getWorktimeBegin() {
        return worktimeBegin != null ? worktimeBegin : CalendarPluginUtils.parseTime(null, 0, 0);
    }

    public static Calendar getWorktimeEnd() {
        return worktimeEnd != null ? worktimeEnd : CalendarPluginUtils.parseTime(null, 23, 59);
    }

    public void install(Connection connection, DbExtension dbExtension, String string, boolean bl) throws SQLException, IOException {
        DbCalendarExtension dbCalendarExtension = CalendarPluginUtils.getDbCalendarExtension(string);
        if (dbCalendarExtension == null) {
            throw new SQLException("Can't find a DbCalendarExtension for driver '" + string + "'!");
        }
        dbCalendarExtension.install(connection);
        super.install(connection, dbExtension, string, bl);
        if (bl) {
            DbCalendarGroup dbCalendarGroup = new DbCalendarGroup();
            dbCalendarGroup.name = I18N.tr("private");
            dbCalendarGroup.type = DbCalendarGroup.Type.LOCAL;
            dbCalendarExtension.getCalendarHandler().saveGroup(connection, dbCalendarGroup);
            dbCalendarGroup = new DbCalendarGroup();
            dbCalendarGroup.name = I18N.tr("business");
            dbCalendarGroup.type = DbCalendarGroup.Type.LOCAL;
            dbCalendarExtension.getCalendarHandler().saveGroup(connection, dbCalendarGroup);
        }
    }

    public boolean isAllowed(ImmoToolProject immoToolProject) {
        return CalendarPlugin.isUserAllowedTo(CalendarPermission.USE_PLUGIN, immoToolProject);
    }

    public boolean isUsable(ImmoToolProject immoToolProject) {
        return super.isUsable(immoToolProject) && this.isAllowed(immoToolProject);
    }

    public static boolean isUserAllowedTo(CalendarPermission calendarPermission) {
        return CalendarPlugin.isUserAllowedTo(calendarPermission, ImmoToolProject.getAppInstance());
    }

    public static boolean isUserAllowedTo(CalendarPermission calendarPermission, ImmoToolProject immoToolProject) {
        if (immoToolProject == null) {
            return false;
        }
        DbUser dbUser = immoToolProject.getUser();
        return dbUser != null ? dbUser.isAllowedTo(ID, (ProjectPermission)calendarPermission) : false;
    }

    public static boolean isVirtualCalendarEnabled(VirtualCalendarExtension virtualCalendarExtension) {
        return virtualCalendarExtension != null && CalendarPlugin.isVirtualCalendarEnabled(virtualCalendarExtension.getId());
    }

    public static boolean isVirtualCalendarEnabled(String string) {
        return virtualCalendarIds == null || virtualCalendarIds.contains(string);
    }

    public static void loadSettings(ImmoToolProject immoToolProject) throws SQLException, IOException {
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            CalendarPlugin.loadSettings(immoToolProject, connection);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public static void loadSettings(ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
        DbUserHandler dbUserHandler = immoToolProject.getDbExtension().getUserHandler();
        DbUser dbUser = immoToolProject.getUser();
        dbUserHandler.loadUserSettings(connection, dbUser);
        worktimeBegin = CalendarPluginUtils.parseTime(dbUser.getSetting(ID, USER_WORKTIME_BEGIN), 0, 0);
        worktimeEnd = CalendarPluginUtils.parseTime(dbUser.getSetting(ID, USER_WORKTIME_END), 23, 59);
        String string = dbUser.getSetting(ID, USER_VIRTUAL_CALENDARS, null);
        if (string == null) {
            virtualCalendarIds = null;
        } else {
            virtualCalendarIds = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)string)) {
                virtualCalendarIds.addAll(Arrays.asList(StringUtils.split((String)string, (String)",")));
            }
        }
    }

    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        CalendarPlugin.getDbCalendarExtension().repair(connection, abstractDbDriver);
    }

    public static void saveSettings(ImmoToolProject immoToolProject) throws SQLException, IOException {
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            CalendarPlugin.saveSettings(connection, immoToolProject.getUser(), immoToolProject.getDbExtension());
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public static void saveSettings(Connection connection, DbUser dbUser, DbExtension dbExtension) throws SQLException, IOException {
        CalendarPlugin.saveSettings(connection, dbUser, dbExtension, dbCalendarExtension);
    }

    public static void saveSettings(Connection connection, DbUser dbUser, DbExtension dbExtension, DbCalendarExtension dbCalendarExtension) throws SQLException, IOException {
        DbUserHandler dbUserHandler = dbExtension.getUserHandler();
        DbPluginHandler dbPluginHandler = dbExtension.getPluginHandler();
        dbUserHandler.loadUserSettings(connection, dbUser);
        dbUser.putSetting(ID, USER_WORKTIME_BEGIN, CalendarPluginUtils.printTime(worktimeBegin));
        dbUser.putSetting(ID, USER_WORKTIME_END, CalendarPluginUtils.printTime(worktimeEnd));
        if (virtualCalendarIds != null) {
            dbUser.putSetting(ID, USER_VIRTUAL_CALENDARS, StringUtils.join(virtualCalendarIds, (String)","));
        } else {
            dbUser.removeSettings(ID, USER_VIRTUAL_CALENDARS);
        }
        dbUserHandler.saveUserProfile(connection, dbPluginHandler, dbUser);
    }

    public static void setDbCalendarExtension(DbCalendarExtension dbCalendarExtension) {
        CalendarPlugin.dbCalendarExtension = dbCalendarExtension;
    }

    public static void setVirtualCalendars(List<VirtualCalendarExtension> list) {
        virtualCalendarIds = new ArrayList<String>();
        for (VirtualCalendarExtension virtualCalendarExtension : list) {
            virtualCalendarIds.add(virtualCalendarExtension.getId());
        }
    }

    public static void setWorktimeBegin(Date date) {
        if (date == null) {
            CalendarPlugin.setWorktimeBegin((Calendar)null);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        CalendarPlugin.setWorktimeBegin(calendar);
    }

    public static void setWorktimeBegin(Calendar calendar) {
        worktimeBegin = calendar;
    }

    public static void setWorktimeEnd(Date date) {
        if (date == null) {
            CalendarPlugin.setWorktimeEnd((Calendar)null);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        CalendarPlugin.setWorktimeEnd(calendar);
    }

    public static void setWorktimeEnd(Calendar calendar) {
        worktimeEnd = calendar;
    }

    public static void unloadSettings() {
        worktimeBegin = null;
        worktimeEnd = null;
        virtualCalendarIds = null;
    }

    private static final class SyncTask
    extends ImmoToolTaskContainer {
        private int counter = 0;

        private SyncTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            this.counter = 0;
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                for (DbCalendarGroup dbCalendarGroup : dbCalendarExtension.getCalendarHandler().getGroups(connection)) {
                    if (!DbCalendarGroup.Type.FILE.equals((Object)dbCalendarGroup.type) && !DbCalendarGroup.Type.URL.equals((Object)dbCalendarGroup.type)) continue;
                    ++this.counter;
                    this.add(new CalendarSyncTask(immoToolProject.getDbDriver(), dbCalendarExtension.getCalendarHandler(), dbCalendarGroup));
                }
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            return this.counter > 0 ? super.doInBackground() : false;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't synchronise calendars!", (Throwable)throwable, (Window)this.getParentWindow());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (Boolean.TRUE.equals(bl) && this.counter > 0) {
                ImmoToolUtils.showMessageInfoDialog((String)I18N.trn("{0} calendar was synchronised.", "{0} calendars were synchronised.", (long)this.counter, (Object)this.counter), (Component)this.getParentWindow());
            } else {
                ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("No calendars were synchronised."), (Component)this.getParentWindow());
            }
        }
    }

    public static final class SyncAction
    extends AbstractI18nAction {
        public SyncAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_IMPORT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolTaskDialog.showDialog((ImmoToolTask)new SyncTask(), (Window)ImmoToolEnvironment.getFrame());
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("synchronisation")));
            this.setShortDescription(I18N.tr("Synchronise external calendars with the database."));
        }
    }

    public static final class SidebarSelectAction
    extends AbstractI18nAction {
        public SidebarSelectAction() {
            this.setSmallIcon(CalendarPlugin.getResourceIcon("vcalendar.png", 16));
            this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolFrame immoToolFrame = (ImmoToolFrame)ImmoToolApp.getInstance().getFrame();
            if (immoToolFrame != null) {
                immoToolFrame.selectSidebar(CalendarFrameSidebarExtension.class);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show calendar view")));
            this.setShortDescription(I18N.tr("Show calendar view in the sidebar."));
        }
    }

    private static final class SidebarRefreshTask
    extends ImmoToolTask<TreeModel, Void> {
        private final CalendarFrameSidebarExtension.Tree tree;

        public SidebarRefreshTask(CalendarFrameSidebarExtension.Tree tree) {
            this.tree = tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TreeModel doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                TreeModel treeModel = CalendarFrameSidebarExtension.createTreeModel(immoToolProject, connection, dbCalendarHandler);
                return treeModel;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't refresh sidebar!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(TreeModel treeModel) {
            super.succeeded((Object)treeModel);
            if (treeModel == null) {
                return;
            }
            this.tree.setModel(treeModel);
            this.tree.expandAll();
        }
    }

    public static final class SidebarRefreshAction
    extends AbstractI18nAction {
        public SidebarRefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarFrameSidebarExtension.Tree tree = CalendarFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                ImmoToolUtils.executeTask((ImmoToolTask)new SidebarRefreshTask(tree));
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Refresh calendar view in the sidebar."));
        }
    }

    public static final class EntryFormAction
    extends AbstractI18nAction {
        private final long entryId;
        private final long addCalendarId;
        private final Date addBegin;
        private final Date addEnd;
        private final DbCalendarEntry.Type addType;

        public EntryFormAction() {
            this(0L, 0L, null, null, null);
        }

        public EntryFormAction(DbCalendarEntry.Type type) {
            this(0L, 0L, null, null, type);
        }

        public EntryFormAction(long l, DbCalendarEntry.Type type) {
            this(0L, l, null, null, type);
        }

        public EntryFormAction(Date date, Date date2) {
            this(0L, 0L, date, date2, null);
        }

        public EntryFormAction(long l, Date date, Date date2) {
            this(0L, l, date, date2, null);
        }

        public EntryFormAction(Date date, Date date2, DbCalendarEntry.Type type) {
            this(0L, 0L, date, date2, type);
        }

        public EntryFormAction(long l, Date date, Date date2, DbCalendarEntry.Type type) {
            this(0L, l, date, date2, type);
        }

        public EntryFormAction(long l) {
            this(l, 0L, null, null, null);
        }

        private EntryFormAction(long l, long l2, Date date, Date date2, DbCalendarEntry.Type type) {
            this.entryId = l;
            this.addCalendarId = l2;
            this.addType = l < 1L ? type : null;
            this.addBegin = l < 1L ? date : null;
            Date date3 = this.addEnd = l < 1L ? date2 : null;
            if (l < 1L && DbCalendarEntry.Type.VEVENT.equals((Object)type)) {
                this.setSmallIcon(CalendarPlugin.getResourceIcon("event.png", 16));
                this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT));
            } else if (l < 1L && DbCalendarEntry.Type.VTODO.equals((Object)type)) {
                this.setSmallIcon(CalendarPlugin.getResourceIcon("todo.png", 16));
                this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT));
            } else if (l < 1L) {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
                this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.USE_PLUGIN));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            if (this.entryId < 1L) {
                CalendarEntryViewPanel calendarEntryViewPanel = CalendarEntryViewPanel.createTab(this.addType);
                calendarEntryViewPanel.setCalendarId(this.addCalendarId);
                if (this.addBegin != null && this.addEnd != null) {
                    calendarEntryViewPanel.setDateInterval(this.addBegin, this.addEnd);
                } else if (this.addBegin != null) {
                    calendarEntryViewPanel.setDate(this.addBegin);
                }
                ImmoToolAppUtils.showTab((AbstractMainTab)calendarEntryViewPanel);
                calendarEntryViewPanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            } else {
                ImmoToolUtils.executeTask((ImmoToolTask)new CalendarEntryViewTask(immoToolProject.getDbDriver(), this.entryId));
            }
        }

        protected final void updateLocalization() {
            if (this.entryId < 1L && DbCalendarEntry.Type.VEVENT.equals((Object)this.addType)) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add event")));
                this.setShortDescription(I18N.tr("Add a new event to the calendar."));
            } else if (this.entryId < 1L && DbCalendarEntry.Type.VTODO.equals((Object)this.addType)) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add task")));
                this.setShortDescription(I18N.tr("Add a new task to the calendar."));
            } else if (this.entryId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add entry")));
                this.setShortDescription(I18N.tr("Add a new entry to the calendar."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("view entry")));
                this.setShortDescription(I18N.tr("Show details about the calendar entry."));
            }
        }
    }

    private static final class CalendarViewTask
    extends ImmoToolTask<CalendarViewPanel, Void> {
        private final long calendarId;
        private final VirtualCalendarExtension virtualCalendar;
        private final boolean asNewTab;

        public CalendarViewTask(long l, VirtualCalendarExtension virtualCalendarExtension, boolean bl) {
            this.calendarId = l;
            this.virtualCalendar = virtualCalendarExtension;
            this.asNewTab = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CalendarViewPanel doInBackground() throws Exception {
            Object object;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
            DbCalendarGroup dbCalendarGroup = null;
            if (this.calendarId > 0L) {
                object = null;
                try {
                    object = immoToolProject.getDbConnection();
                    dbCalendarGroup = dbCalendarHandler.getGroup((Connection)object, this.calendarId);
                    if (dbCalendarGroup == null) {
                        throw new Exception("Can't find calendar #" + this.calendarId + "!");
                    }
                    object.close();
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)object);
                }
            }
            Object object2 = object = !this.asNewTab ? ImmoToolAppUtils.getMatchingTab(CalendarViewPanel.class) : null;
            if (object != null && CalendarViewPanel.class.isInstance(object)) {
                CalendarViewPanel calendarViewPanel = (CalendarViewPanel)((Object)object);
                Class clazz = calendarViewPanel.getCurrentVirtualCalendarClass();
                long l = calendarViewPanel.getCurrentCalendarId();
                boolean bl = false;
                if (this.virtualCalendar != null && !this.virtualCalendar.getClass().equals(clazz)) {
                    calendarViewPanel.setCalendar(this.virtualCalendar);
                    bl = true;
                } else if (this.calendarId > 0L && l != this.calendarId) {
                    calendarViewPanel.setCalendar(dbCalendarGroup);
                    bl = true;
                } else if (this.virtualCalendar == null && this.calendarId < 1L && (clazz != null || l > 0L)) {
                    calendarViewPanel.setCalendar((DbCalendarGroup)null);
                    bl = true;
                }
                ImmoToolAppUtils.selectTab((Component)((Object)calendarViewPanel));
                if (bl) {
                    calendarViewPanel.loadInBackground(immoToolProject.getDbDriver());
                }
                return null;
            }
            return this.virtualCalendar != null ? CalendarViewPanel.createTab(this.virtualCalendar) : CalendarViewPanel.createTab(dbCalendarGroup);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load calendar view!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(CalendarViewPanel calendarViewPanel) {
            super.succeeded((Object)calendarViewPanel);
            if (calendarViewPanel != null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)calendarViewPanel);
                calendarViewPanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            }
        }
    }

    public static final class CalendarViewAction
    extends AbstractI18nAction {
        private final long calendarId;
        private final VirtualCalendarExtension virtualCalendar;
        private final boolean asNewTab;

        public CalendarViewAction(long l) {
            this(l, null, true);
        }

        public CalendarViewAction(long l, boolean bl) {
            this(l, null, bl);
        }

        public CalendarViewAction(VirtualCalendarExtension virtualCalendarExtension) {
            this(0L, virtualCalendarExtension, true);
        }

        public CalendarViewAction(VirtualCalendarExtension virtualCalendarExtension, boolean bl) {
            this(0L, virtualCalendarExtension, bl);
        }

        private CalendarViewAction(long l, VirtualCalendarExtension virtualCalendarExtension, boolean bl) {
            this.calendarId = l;
            this.virtualCalendar = virtualCalendarExtension;
            this.asNewTab = bl;
            this.setSmallIcon(CalendarPlugin.getResourceIcon("vcalendar.png", 16));
            this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new CalendarViewTask(this.calendarId, this.virtualCalendar, this.asNewTab));
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show entries")));
            this.setShortDescription(I18N.tr("Show the calendar entries."));
        }
    }

    private static final class CalendarRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long calendarId;

        public CalendarRemoveTask(long l) {
            this.calendarId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbCalendarHandler.removeGroup(connection, this.calendarId);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't remove calendar!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            this.setMessage("Calendar #" + this.calendarId + " was removed.");
            CalendarFrameSidebarExtension.Tree tree = CalendarFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                tree.removeCalendar(this.calendarId);
            }
        }
    }

    public static final class CalendarRemoveAction
    extends AbstractI18nAction {
        private final long calendarId;

        public CalendarRemoveAction(long l) {
            this.calendarId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.GROUPS_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.calendarId < 1L) {
                return;
            }
            boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove calendar {0}?", (Object)("#" + this.calendarId)), (Component)ImmoToolEnvironment.getFrame());
            if (bl) {
                ImmoToolUtils.executeTask((ImmoToolTask)new CalendarRemoveTask(this.calendarId));
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove calendar")));
            this.setShortDescription(I18N.tr("Remove the selected calendar."));
        }
    }

    private static final class CalendarDialogTask
    extends ImmoToolTask<Boolean, Void> {
        private final long calendarId;
        private DbCalendarGroup group = null;

        public CalendarDialogTask(long l) {
            this.calendarId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            Connection connection;
            ImmoToolProject immoToolProject;
            block3: {
                Boolean bl;
                immoToolProject = ImmoToolProject.getAppInstance();
                connection = null;
                try {
                    this.group = CalendarSourceDialog.showDialog(this.calendarId, immoToolProject, (Window)ImmoToolEnvironment.getFrame());
                    if (this.group != null) break block3;
                    bl = false;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(connection);
                    throw throwable;
                }
                JdbcUtils.closeQuietly((Connection)connection);
                return bl;
            }
            connection = immoToolProject.getDbConnection();
            dbCalendarExtension.getCalendarHandler().saveGroup(connection, this.group);
            Boolean bl = true;
            JdbcUtils.closeQuietly((Connection)connection);
            return bl;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load form for calendar!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            CalendarFrameSidebarExtension.Tree tree = CalendarFrameSidebarExtension.getCurrentSidebarTree();
            if (this.group != null && tree != null) {
                tree.putCalendar(this.group);
            }
        }
    }

    public static final class CalendarDialogAction
    extends AbstractI18nAction {
        private final long calendarId;

        public CalendarDialogAction() {
            this(0L);
        }

        public CalendarDialogAction(long l) {
            this.calendarId = l;
            if (l < 1L) {
                this.setSmallIcon(CalendarPlugin.getResourceIcon("vcalendar.png", 16));
                this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.GROUPS_EDIT));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(CalendarPlugin.isUserAllowedTo(CalendarPermission.GROUPS_EDIT));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new CalendarDialogTask(this.calendarId));
        }

        protected final void updateLocalization() {
            if (this.calendarId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add calendar")));
                this.setShortDescription(I18N.tr("Add a new calendar."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("edit calendar")));
                this.setShortDescription(I18N.tr("Show details about the calendar."));
            }
        }
    }
}

