/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.db;

import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.CalendarEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarEventEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.CalendarTodoEntryPanel;
import com.openindex.openestate.tool.calendar.db.DbCalendarEventEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarTodoEntry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public abstract class DbCalendarEntry<ComponentType extends Component>
implements CalendarEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbCalendarEntry.class);
    private static final I18n I18N = I18nFactory.getI18n(DbCalendarEntry.class);
    public long id = 0L;
    public long groupId = 0L;
    public String uid = null;
    public String title = null;
    public Status status = null;
    public String notes = null;
    public String ical = null;
    public Date begin = null;
    public Date end = null;
    public Date createdAt = null;
    public Date modifiedAt = null;

    public static ObjectToStringConverter createObjectToStringConverter() {
        return new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object object) {
                if (object instanceof DbCalendarEntry) {
                    return ((DbCalendarEntry)object).print();
                }
                return "-";
            }

            public String[] getPossibleStringsForItem(Object object) {
                if (object instanceof DbCalendarEntry) {
                    DbCalendarEntry dbCalendarEntry = (DbCalendarEntry)object;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(this.getPreferredStringForItem(object));
                    if (dbCalendarEntry.title != null && !arrayList.contains(dbCalendarEntry.title)) {
                        arrayList.add(dbCalendarEntry.title);
                    }
                    return arrayList.toArray(new String[0]);
                }
                return super.getPossibleStringsForItem(object);
            }
        };
    }

    @Override
    public Date getBegin() {
        return this.begin != null ? new Date(this.begin.getTime()) : null;
    }

    @Override
    public abstract Color getColor();

    public abstract ComponentType getComponent();

    @Override
    public Date getEnd() {
        return this.end != null ? new Date(this.end.getTime()) : null;
    }

    public String getLocation() {
        Property property = this.getProperty("LOCATION");
        Location location = property instanceof Location ? (Location)property : null;
        return location != null ? StringUtils.trimToNull((String)location.getValue()) : null;
    }

    @Override
    public String getInfo() {
        return this.writeStatus();
    }

    public final PropertyList getProperties() {
        ComponentType ComponentType = this.getComponent();
        return ComponentType != null ? ComponentType.getProperties() : null;
    }

    public final Property getProperty(String string) {
        PropertyList propertyList = this.getProperties();
        return propertyList != null ? (Property)propertyList.getProperty(string) : null;
    }

    public abstract Color getStatusColor();

    public abstract Type getType();

    public abstract boolean hasBeginDate();

    public abstract boolean hasBeginTime();

    public abstract boolean hasEndDate();

    public abstract boolean hasEndTime();

    @Override
    public String getSubTitle() {
        DateFormat dateFormat = this.hasBeginTime() ? DateFormat.getDateTimeInstance(2, 3) : DateFormat.getDateInstance(2);
        return this.writeType() + " " + I18N.tr("at {0}", (Object)dateFormat.format(this.getBegin()));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public final boolean isVirtual() {
        return false;
    }

    public void prepareBeforeSave() {
        Uid uid = (Uid)this.getProperty("UID");
        if (uid == null) {
            uid = CalendarPluginUtils.generateUid();
            this.putProperty((Property)uid);
        }
        this.uid = uid.getValue();
        this.ical = this.getComponent() != null ? this.getComponent().toString() : null;
    }

    public String print() {
        String string = this.begin != null ? DateFormat.getDateInstance(3).format(this.begin) + " | " + this.title : this.title;
        return string != null ? string.trim() : "";
    }

    public final void putProperty(Property property) {
        Property property2 = null;
        try {
            property2 = this.getProperty(property.getName());
            if (property2 != null) {
                this.getProperties().remove(property2);
            }
            this.getProperties().add(property);
        }
        catch (Exception exception) {
            if (property2 != null) {
                this.removeProperty(property2.getName());
            }
            LOGGER.warn("could not put property: " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public final void removeProperty(String string) {
        Property property = this.getProperty(string);
        if (property != null) {
            this.getProperties().remove(property);
        }
    }

    public abstract void setBeginDate(Date var1);

    public abstract void setBeginTime(Date var1);

    public abstract void setComponent(Component var1);

    public abstract void setEmptyComponent();

    public abstract void setEndDate(Date var1);

    public abstract void setEndTime(Date var1);

    public void setLocation(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            this.removeProperty("LOCATION");
        } else {
            this.putProperty((Property)new Location(string.trim()));
        }
    }

    public void setNotes(String string) {
        this.notes = string != null ? string.trim() : null;
        Description description = (Description)this.getProperty("DESCRIPTION");
        if (description != null) {
            if (this.notes == null) {
                this.removeProperty("DESCRIPTION");
            } else {
                description.setValue(this.notes);
            }
        } else if (this.notes != null) {
            this.putProperty((Property)new Description(this.notes));
        }
    }

    public void setStatus(Status status) {
        this.status = status;
        if (this.status == null) {
            this.removeProperty("STATUS");
        } else {
            this.putProperty((Property)this.status);
        }
    }

    public void setSingleDay(Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
            this.removeProperty("DTEND");
            this.removeProperty("DURATION");
            return;
        }
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.setBeginDate(calendar.getTime());
        calendar.add(6, 1);
        calendar.add(14, -1);
        this.setEndTime(calendar.getTime());
    }

    public void setTitle(String string) {
        this.title = string != null ? string.trim() : null;
        Summary summary = (Summary)this.getProperty("SUMMARY");
        if (summary != null) {
            if (this.title == null) {
                this.removeProperty("SUMMARY");
            } else {
                summary.setValue(this.title);
            }
        } else if (this.title != null) {
            this.putProperty((Property)new Summary(this.title));
        }
    }

    public final void updateComponentFromIcal() throws IOException, ParserException {
        if (StringUtils.isBlank((CharSequence)this.ical)) {
            LOGGER.warn("Can't read ical for calendar entry #" + this.id + "!");
            this.setEmptyComponent();
            return;
        }
        Calendar calendar = CalendarPluginUtils.parseCalendarComponent(this.ical);
        Object object = calendar.getComponents().get(0);
        this.setComponent((Component)object);
    }

    public final void updateFieldsFromComponent() {
        Summary summary = (Summary)this.getProperty("SUMMARY");
        this.title = summary != null ? summary.getValue() : null;
        Description description = (Description)this.getProperty("DESCRIPTION");
        this.notes = description != null ? description.getValue() : null;
        Uid uid = (Uid)this.getProperty("UID");
        this.uid = uid != null ? uid.getValue() : null;
        this.status = (Status)this.getProperty("STATUS");
        this.updateIcalFieldFromComponent();
        this.begin = null;
        this.end = null;
        this.updateTimeFieldsFromComponent();
    }

    public final void updateIcalFieldFromComponent() {
        this.ical = this.getComponent() != null ? this.getComponent().toString() : null;
    }

    public abstract void updateTimeFieldsFromComponent();

    public static String writePriority(Priority priority) {
        if (Priority.UNDEFINED.equals((Object)priority)) {
            return I18N.tr("undefined");
        }
        if (Priority.LOW.equals((Object)priority)) {
            return I18N.tr("low priority");
        }
        if (Priority.MEDIUM.equals((Object)priority)) {
            return I18N.tr("medium priority");
        }
        if (Priority.HIGH.equals((Object)priority)) {
            return I18N.tr("high priority");
        }
        return null;
    }

    public String writeStatus() {
        if (Type.VEVENT.equals((Object)this.getType())) {
            return DbCalendarEntry.writeStatusForEvent(this.status);
        }
        if (Type.VTODO.equals((Object)this.getType())) {
            return DbCalendarEntry.writeStatusForTodo(this.status);
        }
        return null;
    }

    public static String writeStatus(Type type, Status status) {
        if (Type.VEVENT.equals((Object)type)) {
            return DbCalendarEntry.writeStatusForEvent(status);
        }
        if (Type.VTODO.equals((Object)type)) {
            return DbCalendarEntry.writeStatusForTodo(status);
        }
        return null;
    }

    public static String writeStatusForEvent(Status status) {
        if (Status.VEVENT_CANCELLED.equals((Object)status)) {
            return I18N.tr("cancelled");
        }
        if (Status.VEVENT_CONFIRMED.equals((Object)status)) {
            return I18N.tr("confirmed");
        }
        if (Status.VEVENT_TENTATIVE.equals((Object)status)) {
            return I18N.tr("tentative");
        }
        return null;
    }

    public static String writeStatusForJournal(Status status) {
        if (Status.VJOURNAL_CANCELLED.equals((Object)status)) {
            return I18N.tr("cancelled");
        }
        if (Status.VJOURNAL_DRAFT.equals((Object)status)) {
            return I18N.tr("draft");
        }
        if (Status.VJOURNAL_FINAL.equals((Object)status)) {
            return I18N.tr("final");
        }
        return null;
    }

    public static String writeStatusForTodo(Status status) {
        if (Status.VTODO_CANCELLED.equals((Object)status)) {
            return I18N.tr("cancelled");
        }
        if (Status.VTODO_COMPLETED.equals((Object)status)) {
            return I18N.tr("completed");
        }
        if (Status.VTODO_IN_PROCESS.equals((Object)status)) {
            return I18N.tr("in process");
        }
        if (Status.VTODO_NEEDS_ACTION.equals((Object)status)) {
            return I18N.tr("needs action");
        }
        return null;
    }

    public String writeType() {
        Type type = this.getType();
        return type != null ? this.getType().write() : null;
    }

    @Deprecated
    public static String writeType(Type type) {
        return type != null ? type.write() : null;
    }

    public static enum Type implements Translatable
    {
        VEVENT(I18n.marktr((String)"event")),
        VTODO(I18n.marktr((String)"task"));

        private final String i18nKey;

        private Type(String string2) {
            this.i18nKey = string2;
        }

        public DbCalendarEntry createEntry() {
            switch (this) {
                case VEVENT: {
                    return new DbCalendarEventEntry();
                }
                case VTODO: {
                    return new DbCalendarTodoEntry();
                }
            }
            return null;
        }

        public CalendarEntryPanel createEntryPanel(boolean bl) {
            switch (this) {
                case VEVENT: {
                    return new CalendarEventEntryPanel(bl);
                }
                case VTODO: {
                    return new CalendarTodoEntryPanel(bl);
                }
            }
            return null;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbCalendarEntry.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String translate() {
            return this.getTranslation();
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }
}

