-- -----------------------------------------------------
-- Calendar-Addon for OpenEstate-ImmoTool
-- schema for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------

CREATE SEQUENCE seq_immotool_calendar_groups
  AS BIGINT START WITH 1 INCREMENT BY 1 NO CYCLE;
CREATE SEQUENCE seq_immotool_calendar_entries
  AS BIGINT START WITH 1 INCREMENT BY 1 NO CYCLE;


-- -----------------------------------------------------
-- Table immotool_calendar_groups
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_calendar_groups (
  group_id BIGINT GENERATED BY DEFAULT AS SEQUENCE seq_immotool_calendar_groups NOT NULL,
  group_name VARCHAR(100) NOT NULL,
  group_notes LONGVARCHAR DEFAULT NULL NULL,
  group_url VARCHAR(255) DEFAULT NULL NULL,
  group_type VARCHAR(45) DEFAULT 'LOCAL' NOT NULL,
  group_auth_method VARCHAR(45) DEFAULT 'ANONYMOUS' NOT NULL,
  group_auth_user VARCHAR(100) DEFAULT NULL NULL,
  group_auth_pass VARCHAR(255) DEFAULT NULL NULL,
  access_owner_id BIGINT DEFAULT 1 NOT NULL,
  access_group_id BIGINT DEFAULT 1 NOT NULL,
  access_permissions INT DEFAULT 0 NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  modified_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  PRIMARY KEY (group_id) ,
  FOREIGN KEY (access_owner_id)
    REFERENCES immotool_users(user_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE SET DEFAULT,
  FOREIGN KEY (access_group_id)
    REFERENCES immotool_groups(group_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE SET DEFAULT
);

CREATE VIEW view_immotool_calendar_groups AS
  SELECT * FROM immotool_calendar_groups
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(access_permissions, 64) = 64)
    OR
    (BITAND(access_permissions, 8) = 8 AND access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(access_permissions, 1) = 1 AND access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );

GRANT SELECT
  ON view_immotool_calendar_groups
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Table immotool_calendar_entries
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_calendar_entries (
  entry_id BIGINT GENERATED BY DEFAULT AS SEQUENCE seq_immotool_calendar_entries NOT NULL,
  group_id BIGINT NOT NULL,
  entry_uid VARCHAR(255) NOT NULL,
  entry_type VARCHAR(45) NOT NULL,
  entry_status VARCHAR(45) DEFAULT NULL NULL,
  entry_title VARCHAR(255) NOT NULL,
  entry_begin TIMESTAMP WITH TIME ZONE NOT NULL,
  entry_end TIMESTAMP WITH TIME ZONE NOT NULL,
  entry_notes LONGVARCHAR DEFAULT NULL NULL,
  entry_ical LONGVARCHAR NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  modified_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  PRIMARY KEY (entry_id),
  UNIQUE (group_id, entry_uid),
  FOREIGN KEY (group_id)
    REFERENCES immotool_calendar_groups(group_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_calendar_entries AS
  SELECT * FROM immotool_calendar_entries
  WHERE group_id IN (SELECT group_id FROM view_immotool_calendar_groups);

GRANT SELECT
  ON view_immotool_calendar_entries
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Table immotool_calendar_entries_logs
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_calendar_entries_logs (
  log_id BIGINT NOT NULL,
  entry_id BIGINT NOT NULL,
  PRIMARY KEY (log_id, entry_id),
  FOREIGN KEY (log_id)
    REFERENCES immotool_logs(log_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (entry_id)
    REFERENCES immotool_calendar_entries(entry_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_calendar_entries_logs AS
  SELECT a.entry_id, b.* FROM immotool_calendar_entries_logs a
  INNER JOIN immotool_logs b ON ( a.log_id = b.log_id )
  WHERE a.entry_id IN (SELECT entry_id FROM view_immotool_calendar_entries)
  AND b.plugin_id IN (SELECT plugin_id FROM view_immotool_plugins WHERE plugin_name='OpenEstate-Tool-Calendar');

GRANT SELECT
  ON view_immotool_calendar_entries_logs
  TO "IMMOTOOL";
