/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.manual;

import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.extensions.FrameSidebarAdapter;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.manual.ManualPanel;
import com.openindex.openestate.tool.manual.ManualPlugin;
import com.openindex.openestate.tool.utils.SidebarTree;
import java.awt.Component;
import java.awt.Window;
import java.net.MalformedURLException;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.TOCView;
import javax.help.TreeItem;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.tree.DefaultXTreeCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ManualFrameSidebarExtension
extends FrameSidebarAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManualFrameSidebarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(ManualFrameSidebarExtension.class);
    private static AbstractButton currentSidebarButton = null;
    private static Tree currentSidebarTree = null;

    public JComponent createComponent() {
        Tree tree = new Tree();
        tree.installDefaultListeners(true, true);
        tree.setRootVisible(false);
        tree.setCellRenderer((javax.swing.tree.TreeCellRenderer)((Object)new TreeCellRenderer()));
        tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        return tree;
    }

    private TreeModel createTreeModel() {
        HelpSet helpSet = ManualPlugin.getHelpSet();
        TOCView tOCView = (TOCView)helpSet.getNavigatorView("TOC");
        DefaultMutableTreeNode defaultMutableTreeNode = tOCView.getDataAsTree();
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    private void doShow(Map.ID iD, boolean bl) throws InvalidHelpSetContextException, MalformedURLException {
        AbstractMainTab abstractMainTab;
        AbstractMainTab abstractMainTab2 = abstractMainTab = !bl ? ImmoToolAppUtils.getMatchingTab(ManualPanel.class) : null;
        if (abstractMainTab != null && ManualPanel.class.isInstance(abstractMainTab)) {
            ManualPanel manualPanel = (ManualPanel)abstractMainTab;
            if (iD == null && manualPanel.getCurrentID() != null || iD != null && !iD.equals((Object)manualPanel.getCurrentID())) {
                manualPanel.setCurrentId(iD);
            }
            ImmoToolAppUtils.selectTab((Component)((Object)manualPanel));
        } else {
            ManualPanel manualPanel = ManualPanel.createTab(iD);
            ImmoToolAppUtils.showTab((AbstractMainTab)manualPanel);
        }
    }

    public static AbstractButton getCurrentSidebarButton() {
        return currentSidebarButton;
    }

    public static Tree getCurrentSidebarTree() {
        return currentSidebarTree;
    }

    public Icon getIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"help.png", (int)32);
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("manual"));
    }

    public String getTooltipText() {
        return I18N.tr("Open the manual of this application.");
    }

    private static TreePath getTreePathForId(Map.ID iD, TreeModel treeModel) {
        if (iD == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getRoot();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            TreePath treePath = ManualFrameSidebarExtension.getTreePathForId(iD, treeModel, (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
            if (treePath == null) continue;
            return treePath;
        }
        return null;
    }

    private static TreePath getTreePathForId(Map.ID iD, TreeModel treeModel, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (iD == null) {
            return null;
        }
        TreeItem treeItem = (TreeItem)defaultMutableTreeNode.getUserObject();
        if (treeItem == null) {
            return null;
        }
        if (iD.equals((Object)treeItem.getID())) {
            return new TreePath(defaultMutableTreeNode.getPath());
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            TreePath treePath = ManualFrameSidebarExtension.getTreePathForId(iD, treeModel, (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
            if (treePath == null) continue;
            return treePath;
        }
        return null;
    }

    public boolean isSystem() {
        return true;
    }

    public void loadComponent(final JComponent jComponent) {
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<TreeModel, Void>(){

            protected TreeModel doInBackground() throws Exception {
                return ManualFrameSidebarExtension.this.createTreeModel();
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                LOGGER.error("Can't load sidebar component!");
                LOGGER.error("> " + throwable.getLocalizedMessage(), throwable);
            }

            protected void succeeded(TreeModel treeModel) {
                super.succeeded((Object)treeModel);
                ((Tree)((Object)jComponent)).setModel(treeModel);
                ((Tree)((Object)jComponent)).expandRow(0);
            }
        });
    }

    public void register(JComponent jComponent, AbstractButton abstractButton) {
        if (jComponent instanceof Tree) {
            ManualFrameSidebarExtension.setCurrentSidebar((Tree)((Object)jComponent), abstractButton);
        } else {
            LOGGER.warn("An invalid manual-tree was registered!");
            ManualFrameSidebarExtension.setCurrentSidebar(null, null);
        }
    }

    private static synchronized void setCurrentSidebar(Tree tree, AbstractButton abstractButton) {
        currentSidebarTree = tree;
        currentSidebarButton = abstractButton;
    }

    public void unregister() {
        ManualFrameSidebarExtension.setCurrentSidebar(null, null);
    }

    private static class TreeCellRenderer
    extends DefaultXTreeCellRenderer {
        private TreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof DefaultMutableTreeNode && (defaultMutableTreeNode = (DefaultMutableTreeNode)object).getUserObject() instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)defaultMutableTreeNode.getUserObject();
                jLabel.setText(treeItem.getName());
            }
            return jLabel;
        }
    }

    public class Tree
    extends SidebarTree {
        public void setSelectedID(Map.ID iD) {
            TreePath treePath = ManualFrameSidebarExtension.getTreePathForId(iD, this.getModel());
            if (treePath == null) {
                return;
            }
            this.setEnabled(false);
            this.setSelectionPath(treePath);
            this.setEnabled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void showNodeComponent(TreeNode treeNode, boolean bl) {
            try {
                TreeItem treeItem = (TreeItem)((DefaultMutableTreeNode)treeNode).getUserObject();
                ManualFrameSidebarExtension.this.doShow(treeItem.getID(), bl);
            }
            catch (Exception exception) {
                LOGGER.error("Can't show manual page!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't show manual page!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
            }
            finally {
                this.requestFocus();
            }
        }

        protected void showNodeMenu(TreeNode treeNode, int n, int n2) {
        }
    }
}

