/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.manual;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.manual.ManualPlugin;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.help.BadIDException;
import javax.help.DefaultHelpHistoryModel;
import javax.help.DefaultHelpModel;
import javax.help.HelpHistoryModel;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.help.TextHelpModel;
import javax.help.event.HelpHistoryModelEvent;
import javax.help.event.HelpHistoryModelListener;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class ManualPanel
extends AbstractMainTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManualPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ManualPanel.class);
    private Map.ID helpHomeId;
    private JHelpContentViewer helpViewer;
    private TextHelpModel helpModel;
    private HelpHistoryModel helpHistoryModel;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction nextPageAction;
    private AbstractI18nAction prevPageAction;

    private ManualPanel() {
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.prevPageAction = new ViewPreviousPageAction();
        this.nextPageAction = new ViewNextPageAction();
        this.closeAction = this.createDefaultCloseAction();
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.prevPageAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.nextPageAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildMainComponent() {
        HelpSet helpSet = ManualPlugin.getHelpSet();
        this.helpHomeId = helpSet.getHomeID();
        this.helpModel = new DefaultHelpModel(helpSet);
        this.helpHistoryModel = new DefaultHelpHistoryModel(null);
        this.helpHistoryModel.setHelpModel((HelpModel)this.helpModel);
        this.helpHistoryModel.addHelpHistoryModelListener(new HelpHistoryModelListener(){

            public void historyChanged(HelpHistoryModelEvent helpHistoryModelEvent) {
                if (!ManualPanel.this.helpViewer.isEnabled()) {
                    return;
                }
                ManualPanel.this.setButtonsEnabled(true);
            }
        });
        this.helpViewer = new JHelpContentViewer();
        this.helpViewer.setName("helpViewer");
        this.helpViewer.setModel(this.helpModel);
        this.helpViewer.addHelpModelListener(new HelpModelListener(){

            public void idChanged(HelpModelEvent helpModelEvent) {
                if (!ManualPanel.this.helpViewer.isEnabled() || helpModelEvent == null) {
                    return;
                }
                if (ManualPlugin.getCurrentId() != null && ManualPlugin.getCurrentId().equals((Object)helpModelEvent.getID())) {
                    return;
                }
                ManualPanel.this.setButtonsEnabled(true);
                ManualPlugin.setCurrentId(helpModelEvent.getID());
            }
        });
        return this.helpViewer;
    }

    public static ManualPanel createTab() throws InvalidHelpSetContextException {
        return ManualPanel.createTab((Map.ID)null);
    }

    public static ManualPanel createTab(Map.ID iD) throws InvalidHelpSetContextException {
        ManualPanel manualPanel = new ManualPanel();
        manualPanel.setCurrentId(iD);
        return manualPanel;
    }

    public static ManualPanel createTab(String string) throws InvalidHelpSetContextException {
        ManualPanel manualPanel = new ManualPanel();
        manualPanel.setCurrentId(string);
        return manualPanel;
    }

    public static ManualPanel createTab(URL uRL) throws InvalidHelpSetContextException {
        ManualPanel manualPanel = new ManualPanel();
        manualPanel.setCurrentUrl(uRL);
        return manualPanel;
    }

    public void doRefresh() {
    }

    private void doViewNextPage() {
        this.helpHistoryModel.goForward();
    }

    private void doViewPreviousPage() {
        this.helpHistoryModel.goBack();
    }

    public Map.ID getCurrentID() {
        return this.helpViewer != null ? this.helpViewer.getModel().getCurrentID() : null;
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"help.png", (int)32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("manual"));
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("manual"));
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.closeAction.setEnabled(bl);
        this.nextPageAction.setEnabled(bl && !this.helpHistoryModel.getForwardHistory().isEmpty());
        this.prevPageAction.setEnabled(bl && !this.helpHistoryModel.getBackwardHistory().isEmpty());
    }

    public void setCurrentId(Map.ID iD) throws InvalidHelpSetContextException {
        this.helpViewer.setCurrentID(iD != null ? iD : this.helpHomeId);
    }

    public void setCurrentId(String string) throws InvalidHelpSetContextException {
        try {
            if (string == null) {
                this.helpViewer.setCurrentID(this.helpHomeId);
            } else {
                this.helpViewer.setCurrentID(string);
            }
        }
        catch (BadIDException badIDException) {
            LOGGER.warn("Can't open helpset for id '" + badIDException.getID() + "'!");
            LOGGER.warn("> ", (Throwable)badIDException);
            this.helpViewer.setCurrentID(this.helpHomeId);
        }
    }

    public void setCurrentUrl(URL uRL) throws InvalidHelpSetContextException {
        if (uRL == null) {
            this.helpViewer.setCurrentID(this.helpHomeId);
        } else {
            this.helpViewer.setCurrentURL(uRL);
        }
    }

    private class ViewPreviousPageAction
    extends AbstractI18nAction {
        public ViewPreviousPageAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_left.png", (int)16));
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ManualPanel.this.doViewPreviousPage();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Show previous page in history."));
        }
    }

    private class ViewNextPageAction
    extends AbstractI18nAction {
        public ViewNextPageAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_right.png", (int)16));
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ManualPanel.this.doViewNextPage();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Show next page in history."));
        }
    }
}

