/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.manual;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolPlugin;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.manual.ExternalLinkContentViewerUI;
import com.openindex.openestate.tool.manual.ManualFrameSidebarExtension;
import java.awt.Image;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;
import javax.help.SwingHelpUtilities;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ManualPlugin
extends ImmoToolPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManualPlugin.class);
    private static final I18n I18N = I18nFactory.getI18n(ManualPlugin.class);
    public static final String ID = "OpenEstate-Tool-Manual";
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/manual/resources/";
    private static HelpSet helpSet;
    private static Map.ID currentId;

    public static HelpSet createHelpSet() throws HelpSetException {
        URL uRL = ManualPlugin.class.getResource("/com/openindex/openestate/tool/manual/resources/javahelp/jhelpset.hs");
        if (uRL == null) {
            throw new HelpSetException("Can't find helpset!");
        }
        HelpSet helpSet = new HelpSet(ManualPlugin.class.getClassLoader(), uRL);
        helpSet.setHomeID("book");
        return helpSet;
    }

    protected void doStart() throws Exception {
        SwingHelpUtilities.setContentViewerUI((String)ExternalLinkContentViewerUI.class.getName());
        helpSet = ManualPlugin.createHelpSet();
        currentId = helpSet.getHomeID();
    }

    protected void doStop() throws Exception {
        ManualPlugin.setHelpSet(null);
        ManualPlugin.setCurrentId(null);
    }

    public static Map.ID getCurrentId() {
        return currentId;
    }

    public String getDescription() {
        return I18N.tr("Integrates the users manual into the application.");
    }

    public static HelpSet getHelpSet() {
        return helpSet;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(ImmoToolEnvironment.getResourceImage((String)"help.png", (int)32));
    }

    public String getId() {
        return ID;
    }

    public static ManualPlugin getInstance() {
        return (ManualPlugin)ImmoToolEnvironment.getPlugin((String)ID);
    }

    public String getLicense() {
        return "Freeware";
    }

    public static Icon getResourceIcon(String string, int n) {
        return ImmoToolUtils.getResourceIcon((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)ManualPlugin.class.getClassLoader());
    }

    public static Image getResourceImage(String string, int n) {
        return ImmoToolUtils.getResourceImage((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)ManualPlugin.class.getClassLoader());
    }

    public static URL getResourceImageURL(String string, int n) {
        return ImmoToolUtils.getResourceImageURL((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)ManualPlugin.class.getClassLoader());
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("manual"));
    }

    public static synchronized void setCurrentId(Map.ID iD) {
        ManualFrameSidebarExtension.Tree tree;
        currentId = iD;
        if (iD != null && (tree = ManualFrameSidebarExtension.getCurrentSidebarTree()) != null) {
            tree.setSelectedID(iD);
        }
    }

    private static synchronized void setHelpSet(HelpSet helpSet) {
        ManualPlugin.helpSet = helpSet;
    }
}

