/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.manual;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.manual.ExternalLinkContentViewerUI;
import com.openindex.openestate.tool.manual.ManualPlugin;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.help.DefaultHelpModel;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.SwingHelpUtilities;
import javax.help.TextHelpModel;
import javax.help.event.HelpHistoryModelEvent;
import javax.help.event.HelpHistoryModelListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class OfflineManualDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfflineManualDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(OfflineManualDialog.class);
    private JHelp helpComponent;
    private GoHistoryBackAction goHistoryBackAction;
    private GoHistoryNextAction goHistoryNextAction;
    private GoToIndexAction goToIndexAction;

    private OfflineManualDialog(Frame frame) {
        super(frame, false);
        this.updateLocalization();
        this.setSize(new Dimension(700, 550));
        this.setLocationRelativeTo(frame);
    }

    private OfflineManualDialog(Dialog dialog) {
        super(dialog, false);
        this.updateLocalization();
        this.setSize(new Dimension(700, 550));
        this.setLocationRelativeTo(dialog);
    }

    protected void buildHeaderComponentBar(ButtonBarBuilder buttonBarBuilder) {
        this.goHistoryBackAction = new GoHistoryBackAction();
        this.goHistoryNextAction = new GoHistoryNextAction();
        this.goToIndexAction = new GoToIndexAction();
        super.buildHeaderComponentBar(buttonBarBuilder);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)this.goToIndexAction)));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)this.goHistoryBackAction)));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)((Object)this.goHistoryNextAction)));
    }

    protected JComponent buildMainComponent() {
        this.helpComponent = new JHelp();
        this.helpComponent.setOpaque(false);
        this.helpComponent.getHistoryModel().addHelpHistoryModelListener(new HelpHistoryModelListener(){

            public void historyChanged(HelpHistoryModelEvent helpHistoryModelEvent) {
                int n = OfflineManualDialog.this.helpComponent.getHistoryModel().getIndex();
                int n2 = OfflineManualDialog.this.helpComponent.getHistoryModel().getHistory().size();
                OfflineManualDialog.this.goHistoryBackAction.setEnabled(n > 0);
                OfflineManualDialog.this.goHistoryNextAction.setEnabled(n + 1 < n2);
            }
        });
        return this.helpComponent;
    }

    private void doGoHistoryBack() {
        this.helpComponent.getHistoryModel().goBack();
    }

    private void doGoHistoryNext() {
        this.helpComponent.getHistoryModel().goForward();
    }

    private void doGoToIndex() {
        this.helpComponent.setCurrentID("book");
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("manual"));
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"help.png", (int)32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("manual"));
    }

    private void load(HelpSet helpSet, String string) {
        this.helpComponent.setModel((TextHelpModel)new DefaultHelpModel(helpSet));
        this.helpComponent.setToolbarDisplayed(false);
        this.helpComponent.setCurrentID(string);
    }

    public static void main(String[] stringArray) {
        System.setProperty("file.encoding", "UTF-8");
        try {
            LOGGER.info("init help-system...");
            final HelpSet helpSet = ManualPlugin.createHelpSet();
            LOGGER.info("show help-dialog...");
            SwingHelpUtilities.setContentViewerUI((String)ExternalLinkContentViewerUI.class.getName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OfflineManualDialog offlineManualDialog = new OfflineManualDialog(new JFrame());
                    offlineManualDialog.setModal(true);
                    offlineManualDialog.load(helpSet, null);
                    offlineManualDialog.setDefaultCloseOperation(0);
                    offlineManualDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent windowEvent) {
                            System.exit(0);
                        }

                        @Override
                        public void windowClosing(WindowEvent windowEvent) {
                            System.exit(0);
                        }
                    });
                    offlineManualDialog.setVisible(true);
                    Runtime.getRuntime().exit(0);
                }
            });
        }
        catch (Exception exception) {
            LOGGER.error("Can't open manual dialog!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public static void showDialog(HelpSet helpSet, Window window) {
        OfflineManualDialog.showDialog(null, helpSet, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDialog(String string, HelpSet helpSet, Window window) {
        if (helpSet == null) {
            throw new IllegalArgumentException("No helpset was provided!");
        }
        OfflineManualDialog offlineManualDialog = null;
        try {
            offlineManualDialog = window instanceof Dialog ? new OfflineManualDialog((Dialog)window) : (window instanceof Frame ? new OfflineManualDialog((Frame)window) : new OfflineManualDialog((Frame)null));
            offlineManualDialog.load(helpSet, string);
            offlineManualDialog.setVisible(true);
        }
        catch (Throwable throwable) {
            ImmoToolUtils.disposeRecursively(offlineManualDialog);
            throw throwable;
        }
        ImmoToolUtils.disposeRecursively((Component)((Object)offlineManualDialog));
    }

    private class GoToIndexAction
    extends AbstractI18nAction {
        public GoToIndexAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"help.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OfflineManualDialog.this.doGoToIndex();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Show index page of the manual."));
        }
    }

    private class GoHistoryNextAction
    extends AbstractI18nAction {
        public GoHistoryNextAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_right.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OfflineManualDialog.this.doGoHistoryNext();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Show next page in history."));
        }
    }

    private class GoHistoryBackAction
    extends AbstractI18nAction {
        public GoHistoryBackAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"arrow_1_left.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OfflineManualDialog.this.doGoHistoryBack();
        }

        protected final void updateLocalization() {
            this.setShortDescription(I18N.tr("Show previous page in history."));
        }
    }
}

