/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolPermissionPanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.db.DbGroup;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultWebLinkField;
import com.openindex.openestate.tool.gui.FlowPanel;
import com.openindex.openestate.tool.news.NewsFeedDialogTab;
import com.openindex.openestate.tool.news.NewsPermission;
import com.openindex.openestate.tool.news.NewsPlugin;
import com.openindex.openestate.tool.news.db.DbNewsFeed;
import com.openindex.openestate.tool.news.db.DbNewsHandler;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class NewsFeedDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsFeedDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(NewsFeedDialog.class);
    private long currentFeedId = 0L;
    private boolean mayEditFeed = false;
    private boolean submitted = false;
    private JTabbedPane tabPanel;
    private FeedTab feedTab;
    private PermissionsTab permissionsTab;
    private SubmitAction submitAction;

    private NewsFeedDialog(Dialog dialog) {
        super(dialog, true);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    private NewsFeedDialog(Frame frame) {
        super(frame, true);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = new SubmitAction();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{this.submitAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{new CancelAction()});
    }

    protected JComponent buildMainComponent() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        this.tabPanel = new JTabbedPane();
        this.feedTab = (FeedTab)ImmoToolUtils.addTab((AbstractTab)new FeedTab(), (JTabbedPane)this.tabPanel);
        this.permissionsTab = null;
        if (immoToolProject != null && immoToolProject.isRemoteProject()) {
            this.permissionsTab = (PermissionsTab)ImmoToolUtils.addTab((AbstractTab)new PermissionsTab(), (JTabbedPane)this.tabPanel);
        }
        return this.tabPanel;
    }

    private void doSubmit() {
        boolean bl = false;
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            NewsFeedDialogTab newsFeedDialogTab;
            Component component = this.tabPanel.getComponentAt(i);
            if (!(component instanceof NewsFeedDialogTab) || (newsFeedDialogTab = (NewsFeedDialogTab)((Object)component)).hasValidInput()) continue;
            bl = true;
        }
        if (bl) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), (Component)((Object)this));
        } else {
            this.submitted = true;
            this.setVisible(false);
        }
    }

    protected String getDialogTitle() {
        if (this.currentFeedId > 0L) {
            return StringUtils.capitalize((String)I18N.tr("edit news feed"));
        }
        return StringUtils.capitalize((String)I18N.tr("add news feed"));
    }

    protected Icon getHeaderIcon() {
        return NewsPlugin.getResourceIcon("news.png", 32);
    }

    protected String getHeaderTitle() {
        if (this.currentFeedId > 0L) {
            return StringUtils.capitalize((String)I18N.tr("news feed")) + " #" + this.currentFeedId;
        }
        return StringUtils.capitalize((String)I18N.tr("add news feed"));
    }

    private void load(DbNewsFeed dbNewsFeed) {
        this.currentFeedId = dbNewsFeed != null ? dbNewsFeed.id : 0L;
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (!(component instanceof NewsFeedDialogTab)) continue;
            NewsFeedDialogTab newsFeedDialogTab = (NewsFeedDialogTab)((Object)component);
            this.tabPanel.setEnabledAt(i, false);
            try {
                newsFeedDialogTab.load(dbNewsFeed);
                this.tabPanel.setEnabledAt(i, true);
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Can't load group into tab '" + newsFeedDialogTab.getTabTitle() + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.updateLocalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPermissions(Connection connection, DbExtension dbExtension, DbNewsFeed dbNewsFeed, DbUser dbUser) throws SQLException {
        this.mayEditFeed = NewsPlugin.isUserAllowedTo(NewsPermission.FEEDS_EDIT);
        if (dbNewsFeed.permission != null) {
            this.mayEditFeed = this.mayEditFeed && dbNewsFeed.permission.canWrite(dbUser, dbNewsFeed.ownerUserId, dbNewsFeed.ownerGroupId);
        }
        try {
            if (this.permissionsTab != null) {
                this.permissionsTab.loadPermissions(connection, dbExtension, dbNewsFeed, dbUser);
            }
        }
        finally {
            this.submitAction.setEnabled(this.mayEditFeed);
        }
    }

    private void save(DbNewsFeed dbNewsFeed) {
        if (dbNewsFeed == null) {
            throw new IllegalArgumentException("No address group provided!");
        }
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (!(component instanceof NewsFeedDialogTab)) continue;
            NewsFeedDialogTab newsFeedDialogTab = (NewsFeedDialogTab)((Object)component);
            newsFeedDialogTab.save(dbNewsFeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbNewsFeed showDialog(ImmoToolProject immoToolProject, Window window) throws SQLException {
        DbNewsFeed dbNewsFeed;
        NewsFeedDialog newsFeedDialog;
        block7: {
            DbNewsFeed dbNewsFeed2;
            newsFeedDialog = null;
            try {
                newsFeedDialog = window instanceof Dialog ? new NewsFeedDialog((Dialog)window) : (window instanceof Frame ? new NewsFeedDialog((Frame)window) : new NewsFeedDialog((Frame)null));
                dbNewsFeed = new DbNewsFeed();
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    newsFeedDialog.load(dbNewsFeed);
                    newsFeedDialog.loadPermissions(connection, immoToolProject.getDbExtension(), dbNewsFeed, immoToolProject.getUser());
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                newsFeedDialog.setVisible(true);
                if (newsFeedDialog.submitted) break block7;
                dbNewsFeed2 = null;
            }
            catch (Throwable throwable) {
                ImmoToolUtils.disposeRecursively(newsFeedDialog);
                throw throwable;
            }
            ImmoToolUtils.disposeRecursively((Component)((Object)newsFeedDialog));
            return dbNewsFeed2;
        }
        newsFeedDialog.save(dbNewsFeed);
        DbNewsFeed dbNewsFeed3 = dbNewsFeed;
        ImmoToolUtils.disposeRecursively((Component)((Object)newsFeedDialog));
        return dbNewsFeed3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbNewsFeed showDialog(long l, ImmoToolProject immoToolProject, Window window) throws SQLException {
        DbNewsFeed dbNewsFeed;
        NewsFeedDialog newsFeedDialog;
        block9: {
            DbNewsFeed dbNewsFeed2;
            if (l < 1L) {
                throw new IllegalArgumentException("Invalid feed id provided!");
            }
            DbNewsHandler dbNewsHandler = NewsPlugin.getDbNewsExtension().getNewsHandler();
            newsFeedDialog = null;
            try {
                newsFeedDialog = window instanceof Dialog ? new NewsFeedDialog((Dialog)window) : (window instanceof Frame ? new NewsFeedDialog((Frame)window) : new NewsFeedDialog((Frame)null));
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    dbNewsFeed = dbNewsHandler.getFeed(connection, l);
                    if (dbNewsFeed == null) {
                        throw new SQLException("Can't find news feed #" + l + "!");
                    }
                    newsFeedDialog.load(dbNewsFeed);
                    newsFeedDialog.loadPermissions(connection, immoToolProject.getDbExtension(), dbNewsFeed, immoToolProject.getUser());
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                newsFeedDialog.setVisible(true);
                if (newsFeedDialog.submitted) break block9;
                dbNewsFeed2 = null;
            }
            catch (Throwable throwable) {
                ImmoToolUtils.disposeRecursively(newsFeedDialog);
                throw throwable;
            }
            ImmoToolUtils.disposeRecursively((Component)((Object)newsFeedDialog));
            return dbNewsFeed2;
        }
        newsFeedDialog.save(dbNewsFeed);
        DbNewsFeed dbNewsFeed3 = dbNewsFeed;
        ImmoToolUtils.disposeRecursively((Component)((Object)newsFeedDialog));
        return dbNewsFeed3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean showDialog(DbNewsFeed dbNewsFeed, ImmoToolProject immoToolProject, Window window) throws SQLException {
        NewsFeedDialog newsFeedDialog;
        block8: {
            boolean bl;
            if (dbNewsFeed == null) {
                throw new IllegalArgumentException("No news feed provided!");
            }
            newsFeedDialog = null;
            try {
                newsFeedDialog = window instanceof Dialog ? new NewsFeedDialog((Dialog)window) : (window instanceof Frame ? new NewsFeedDialog((Frame)window) : new NewsFeedDialog((Frame)null));
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    newsFeedDialog.load(dbNewsFeed);
                    newsFeedDialog.loadPermissions(connection, immoToolProject.getDbExtension(), dbNewsFeed, immoToolProject.getUser());
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                newsFeedDialog.setVisible(true);
                if (newsFeedDialog.submitted) break block8;
                bl = false;
            }
            catch (Throwable throwable) {
                ImmoToolUtils.disposeRecursively(newsFeedDialog);
                throw throwable;
            }
            ImmoToolUtils.disposeRecursively((Component)((Object)newsFeedDialog));
            return bl;
        }
        newsFeedDialog.save(dbNewsFeed);
        boolean bl = true;
        ImmoToolUtils.disposeRecursively((Component)((Object)newsFeedDialog));
        return bl;
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewsFeedDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Close this window and save modifications."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewsFeedDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window without saving modifications."));
        }
    }

    private static final class PermissionsTab
    extends NewsFeedDialogTab {
        private ImmoToolPermissionPanel form;

        private PermissionsTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.form = new ImmoToolPermissionPanel(true);
            this.form.setBorder((Border)Paddings.DIALOG);
            JScrollPane jScrollPane = new JScrollPane((Component)this.form);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
        }

        public String getTabTitle() {
            return this.form.getTitle();
        }

        @Override
        public void load(DbNewsFeed dbNewsFeed) {
        }

        public void loadPermissions(Connection connection, DbExtension dbExtension, DbNewsFeed dbNewsFeed, DbUser dbUser) throws SQLException {
            if (dbNewsFeed != null && dbNewsFeed.id > 0L) {
                this.form.setPermission(dbNewsFeed.ownerUserId, dbNewsFeed.ownerGroupId, dbNewsFeed.permission);
            } else {
                this.form.setPermission(dbUser.id, 0L, null);
            }
            this.form.load(connection, dbExtension.getUserHandler(), dbUser, dbExtension.getBaseGroupName());
        }

        @Override
        public void save(DbNewsFeed dbNewsFeed) {
            DbGroup dbGroup;
            dbNewsFeed.permission = this.form.getSelectedPermission();
            DbUser dbUser = this.form.getSelectedOwner();
            if (dbUser != null) {
                dbNewsFeed.ownerUserId = dbUser.id;
            }
            if ((dbGroup = this.form.getSelectedGroup()) != null) {
                dbNewsFeed.ownerGroupId = dbGroup.id;
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private static final class FeedTab
    extends NewsFeedDialogTab {
        private ValidationHandler validationHandler;
        private JXTitledSeparator generalTitle;
        private JXTitledSeparator authTitle;
        private JXTitledSeparator optionsTitle;
        private JLabel feedTitleLabel;
        private JTextField feedTitleField;
        private JLabel feedUrlLabel;
        private DefaultWebLinkField feedUrlField;
        private JCheckBox feedArchiveBox;
        private JCheckBox feedUpdateBox;
        private JCheckBox feedAuthBox;
        private JLabel feedAuthLoginLabel;
        private JTextField feedAuthLoginField;
        private JLabel feedAuthPasswordLabel;
        private JPasswordField feedAuthPasswordField;
        private JSpinner feedUpdateIntervalField;
        private JLabel feedUpdateIntervalLabel1;
        private JLabel feedUpdateIntervalLabel2;

        private FeedTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.generalTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.authTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.optionsTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.feedTitleLabel = new JLabel();
            this.feedTitleField = new JTextField();
            this.feedUrlLabel = new JLabel();
            this.feedUrlField = new DefaultWebLinkField(false);
            this.feedAuthBox = new JCheckBox();
            this.feedAuthBox.setSelected(false);
            this.feedAuthBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FeedTab.this.updateAuthFields();
                    FeedTab.this.validationHandler.init();
                }
            });
            this.feedAuthLoginLabel = new JLabel();
            this.feedAuthLoginField = new JTextField();
            this.feedAuthLoginField.setEnabled(false);
            this.feedAuthPasswordLabel = new JLabel();
            this.feedAuthPasswordField = new JPasswordField();
            this.feedAuthPasswordField.setEnabled(false);
            this.feedArchiveBox = new JCheckBox();
            this.feedUpdateBox = new JCheckBox();
            this.feedUpdateBox.setName("feedUpdateBox");
            this.feedUpdateBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FeedTab.this.updateAutoUpdateFields();
                    FeedTab.this.validationHandler.init();
                }
            });
            this.feedUpdateIntervalField = new JSpinner(new SpinnerNumberModel(10, 0, 999, 1));
            this.feedUpdateIntervalField.setName("feedUpdateIntervalField");
            this.feedUpdateIntervalField.setPreferredSize(new Dimension(60, this.feedUpdateIntervalField.getPreferredSize().height));
            this.feedUpdateIntervalLabel1 = new JLabel();
            this.feedUpdateIntervalLabel2 = new JLabel();
            JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
            jPanel.add(this.feedUpdateIntervalLabel1);
            jPanel.add(this.feedUpdateIntervalField);
            jPanel.add(this.feedUpdateIntervalLabel2);
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 13, 0, 0));
            this.validationHandler = ImmoToolUtils.createValidationHandler();
            this.validationHandler.putRule((JComponent)this.feedTitleField, ValidationHandler.NOT_BLANK);
            this.validationHandler.putRule((JComponent)this.feedAuthLoginField, ValidationHandler.NOT_BLANK);
            this.validationHandler.putRule((JComponent)this.feedUrlField, ValidationHandler.URL);
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, pref:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)this.generalTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.feedTitleLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.feedTitleField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.feedUrlLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.feedUrlField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.authTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.feedAuthLoginLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.feedAuthLoginField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.feedAuthPasswordLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.feedAuthPasswordField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)FlowPanel.create((JComponent[])new JComponent[]{this.feedAuthBox})).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.optionsTitle).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)FlowPanel.create((JComponent[])new JComponent[]{this.feedArchiveBox})).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)FlowPanel.create((JComponent[])new JComponent[]{this.feedUpdateBox})).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)jPanel).xy(3, defaultFormBuilder.nextRow());
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("news feed"));
        }

        @Override
        public boolean hasValidInput() {
            this.validationHandler.validate();
            boolean bl = this.validationHandler.isValid();
            try {
                this.feedUpdateIntervalField.commitEdit();
            }
            catch (ParseException parseException) {
                bl = false;
                LOGGER.warn("Invalid interval!");
                LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            }
            return bl;
        }

        @Override
        public void load(DbNewsFeed dbNewsFeed) {
            if (dbNewsFeed == null) {
                this.feedTitleField.setText("");
                this.feedUrlField.setUrl(null);
                this.feedAuthBox.setSelected(false);
                this.feedAuthLoginField.setText("");
                this.feedAuthPasswordField.setText("");
                this.feedArchiveBox.setSelected(false);
                this.feedUpdateBox.setSelected(false);
                this.feedUpdateIntervalField.setValue(10);
                this.validationHandler.init();
            } else {
                this.feedTitleField.setText(dbNewsFeed.name);
                this.feedUrlField.setUrl(dbNewsFeed.url);
                this.feedAuthBox.setSelected(dbNewsFeed.authMethod != null && !DbNewsFeed.AuthMethod.ANONYMOUS.equals((Object)dbNewsFeed.authMethod));
                this.feedAuthLoginField.setText(dbNewsFeed.authUser != null ? dbNewsFeed.authUser : "");
                this.feedAuthPasswordField.setText(dbNewsFeed.authPassword != null ? String.valueOf(dbNewsFeed.authPassword) : "");
                this.feedArchiveBox.setSelected(dbNewsFeed.isArchived);
                this.feedUpdateBox.setSelected(dbNewsFeed.isUpdateEnabled);
                this.feedUpdateIntervalField.setValue((int)(dbNewsFeed.updateInterval / 60000L));
                this.validationHandler.validate();
            }
            this.feedTitleField.setCaretPosition(0);
            this.feedUrlField.setCaretPosition(0);
            this.feedAuthLoginField.setCaretPosition(0);
            this.feedAuthPasswordField.setCaretPosition(0);
            this.updateAuthFields();
            this.validationHandler.init();
        }

        @Override
        public void save(DbNewsFeed dbNewsFeed) {
            try {
                this.feedUpdateIntervalField.commitEdit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            dbNewsFeed.name = this.feedTitleField.getText().trim();
            dbNewsFeed.authMethod = this.feedAuthBox.isSelected() ? DbNewsFeed.AuthMethod.HTTP_BASIC : DbNewsFeed.AuthMethod.ANONYMOUS;
            dbNewsFeed.authUser = this.feedAuthBox.isSelected() ? this.feedAuthLoginField.getText().trim() : null;
            dbNewsFeed.authPassword = this.feedAuthBox.isSelected() ? this.feedAuthPasswordField.getPassword() : null;
            dbNewsFeed.isArchived = this.feedArchiveBox.isSelected();
            dbNewsFeed.isUpdateEnabled = this.feedUpdateBox.isSelected();
            dbNewsFeed.updateInterval = ((Number)this.feedUpdateIntervalField.getValue()).longValue() * 60000L;
            dbNewsFeed.publishedAt = null;
            dbNewsFeed.url = this.feedUrlField.getUrl();
        }

        private void updateAuthFields() {
            this.feedAuthLoginLabel.setEnabled(this.feedAuthBox.isSelected());
            this.feedAuthLoginField.setEnabled(this.feedAuthBox.isSelected());
            this.feedAuthPasswordLabel.setEnabled(this.feedAuthBox.isSelected());
            this.feedAuthPasswordField.setEnabled(this.feedAuthBox.isSelected());
        }

        private void updateAutoUpdateFields() {
            this.feedUpdateIntervalField.setEnabled(this.feedUpdateBox.isSelected());
            this.feedUpdateIntervalLabel1.setEnabled(this.feedUpdateBox.isSelected());
            this.feedUpdateIntervalLabel2.setEnabled(this.feedUpdateBox.isSelected());
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.generalTitle.setTitle(StringUtils.capitalize((String)I18N.tr("general settings")));
            this.authTitle.setTitle(StringUtils.capitalize((String)I18N.tr("authentication")));
            this.optionsTitle.setTitle(StringUtils.capitalize((String)I18N.tr("further options")));
            this.feedTitleLabel.setText(StringUtils.capitalize((String)I18N.tr("title")) + ":");
            this.feedTitleField.setToolTipText(I18N.tr("Select a descriptive name for the news feed."));
            this.feedUrlLabel.setText(I18N.tr("URL") + ":");
            this.feedUrlField.setToolTipText(I18N.tr("Enter the URL, where the news feed is downloaded from."));
            this.feedUpdateIntervalLabel1.setText(I18N.tr("all"));
            this.feedUpdateIntervalLabel2.setText(I18N.tr("minutes"));
            this.feedAuthBox.setText(I18N.tr("URL is password protected."));
            this.feedAuthBox.setToolTipText(I18N.tr("Enable this option, if the news feed's URL is protected with a password."));
            this.feedAuthLoginLabel.setText(StringUtils.capitalize((String)I18N.tr("user")) + ":");
            this.feedAuthLoginField.setToolTipText(I18N.tr("Enter the username, that is required to access the protected URL."));
            this.feedAuthPasswordLabel.setText(StringUtils.capitalize((String)I18N.tr("password")) + ":");
            this.feedAuthPasswordField.setToolTipText(I18N.tr("Enter the password, that is required to access the protected URL."));
            this.feedArchiveBox.setText(I18N.tr("Permanently save entries of this news feed."));
            this.feedArchiveBox.setToolTipText(I18N.tr("Enable this option, if the downloaded news entries shall be saved permanently."));
            this.feedUpdateBox.setText(I18N.tr("Automatically check for new messages."));
            this.feedUpdateBox.setToolTipText(I18N.tr("Enable this option, if the program should automatically check for news updates."));
        }
    }
}

