/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.extensions.FrameSidebarAdapter;
import com.openindex.openestate.tool.extensions.FrameSidebarAddonExtension;
import com.openindex.openestate.tool.gui.DefaultMenu;
import com.openindex.openestate.tool.news.NewsPermission;
import com.openindex.openestate.tool.news.NewsPlugin;
import com.openindex.openestate.tool.news.db.DbNewsFeed;
import com.openindex.openestate.tool.news.db.DbNewsHandler;
import com.openindex.openestate.tool.utils.SidebarTree;
import com.openindex.openestate.tool.utils.SidebarTreeCellRenderer;
import com.openindex.openestate.tool.utils.SidebarTreeNode;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class NewsFrameSidebarExtension
extends FrameSidebarAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsFrameSidebarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(NewsFrameSidebarExtension.class);
    public static final int MENU_BEGIN = 0;
    public static final int MENU_REFRESH = 1;
    public static final int MENU_ADD = 2;
    public static final int MENU_ADD_BEGIN = 3;
    public static final int MENU_ADD_FEED = 4;
    public static final int MENU_ADD_END = 5;
    public static final int MENU_SELECTION = 6;
    public static final int MENU_END = 7;
    private static AbstractButton currentSidebarButton = null;
    private static Tree currentSidebarTree = null;

    private static JPopupMenu createActionMenu(TreeNode treeNode) {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Collection collection = NewsFrameSidebarExtension.getAddons((ImmoToolProject)immoToolProject, NewsFrameSidebarExtension.class);
        JPopupMenu jPopupMenu = new JPopupMenu();
        NewsFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)0, (SidebarTreeNode)treeNode, (Collection)collection);
        jPopupMenu.add(new JMenuItem((Action)((Object)new NewsPlugin.SidebarRefreshAction())));
        NewsFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)1, (SidebarTreeNode)treeNode, (Collection)collection);
        DefaultMenu defaultMenu = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("new entry")));
                this.setToolTipText(I18N.tr("Create a new entry in the news addon."));
            }
        };
        defaultMenu.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
        NewsFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)3, (SidebarTreeNode)treeNode, (Collection)collection);
        if (NewsPlugin.isUserAllowedTo(NewsPermission.FEEDS_EDIT)) {
            defaultMenu.add(new JMenuItem((Action)((Object)new NewsPlugin.FeedDialogAction())));
        }
        NewsFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)4, (SidebarTreeNode)treeNode, (Collection)collection);
        NewsFrameSidebarExtension.loadMenu((JMenu)defaultMenu, (int)5, (SidebarTreeNode)treeNode, (Collection)collection);
        if (defaultMenu.getItemCount() > 0) {
            jPopupMenu.add((JMenuItem)defaultMenu);
        }
        NewsFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)2, (SidebarTreeNode)treeNode, (Collection)collection);
        if (treeNode != null && treeNode.isFeed()) {
            DbNewsFeed dbNewsFeed = treeNode.getFeed();
            String string = dbNewsFeed != null ? StringUtils.trimToEmpty((String)dbNewsFeed.name) : StringUtils.capitalize((String)I18N.tr("all news"));
            jPopupMenu.add((Component)ImmoToolUtils.createMenuSeparator((String)StringUtils.abbreviate((String)string, (int)35)));
            jPopupMenu.add((Action)((Object)new NewsPlugin.EntryTableAction(dbNewsFeed != null ? dbNewsFeed.id : 0L, true)));
            if (dbNewsFeed != null && dbNewsFeed.id > 0L && NewsPlugin.isUserAllowedTo(NewsPermission.FEEDS_EDIT)) {
                jPopupMenu.add((Action)((Object)new NewsPlugin.FeedDialogAction(dbNewsFeed.id)));
            }
            if (dbNewsFeed != null && dbNewsFeed.id > 0L && NewsPlugin.isUserAllowedTo(NewsPermission.FEEDS_REMOVE)) {
                jPopupMenu.add((Action)((Object)new NewsPlugin.FeedRemoveAction(dbNewsFeed.id)));
            }
        }
        NewsFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)6, (SidebarTreeNode)treeNode, (Collection)collection);
        NewsFrameSidebarExtension.loadMenu((JPopupMenu)jPopupMenu, (int)7, (SidebarTreeNode)treeNode, (Collection)collection);
        return jPopupMenu;
    }

    public JComponent createComponent() {
        Tree tree = new Tree();
        tree.installDefaultListeners(true, true);
        tree.setRootVisible(false);
        tree.setCellRenderer((TreeCellRenderer)new SidebarTreeCellRenderer());
        tree.setModel(new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)new TreeNode(0))));
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeModel createTreeModel() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbNewsHandler dbNewsHandler = NewsPlugin.getDbNewsExtension().getNewsHandler();
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            TreeModel treeModel = NewsFrameSidebarExtension.createTreeModel(immoToolProject, connection, dbNewsHandler);
            return treeModel;
        }
        catch (Exception exception) {
            LOGGER.error("Can't load syndication feeds!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            TreeModel treeModel = null;
            return treeModel;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public static TreeModel createTreeModel(ImmoToolProject immoToolProject, Connection connection, DbNewsHandler dbNewsHandler) throws SQLException {
        TreeNode treeNode = new TreeNode(1);
        for (DbNewsFeed dbNewsFeed : dbNewsHandler.getFeeds(connection)) {
            treeNode.add((MutableTreeNode)((Object)new TreeNode(dbNewsFeed)));
        }
        TreeNode treeNode2 = new TreeNode(0);
        treeNode2.add((MutableTreeNode)((Object)treeNode));
        for (FrameSidebarAddonExtension frameSidebarAddonExtension : NewsFrameSidebarExtension.getAddons((ImmoToolProject)immoToolProject, NewsFrameSidebarExtension.class)) {
            frameSidebarAddonExtension.initTree(connection, (SidebarTreeNode)treeNode2);
        }
        return new DefaultTreeModel((javax.swing.tree.TreeNode)((Object)treeNode2));
    }

    public static AbstractButton getCurrentSidebarButton() {
        return currentSidebarButton;
    }

    public static Tree getCurrentSidebarTree() {
        return currentSidebarTree;
    }

    public Icon getIcon() {
        return NewsPlugin.getResourceIcon("news.png", 32);
    }

    public JPopupMenu getMenu() {
        return NewsFrameSidebarExtension.createActionMenu(null);
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("news"));
    }

    public String getTooltipText() {
        return I18N.tr("Manage news feeds.");
    }

    public void loadComponent(final JComponent jComponent) {
        ImmoToolUtils.executeTask((ImmoToolTask)new ImmoToolTask<TreeModel, Void>(){

            protected TreeModel doInBackground() {
                return NewsFrameSidebarExtension.this.createTreeModel();
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                LOGGER.error("Can't load sidebar component!");
                LOGGER.error("> " + throwable.getLocalizedMessage(), throwable);
            }

            protected void succeeded(TreeModel treeModel) {
                super.succeeded((Object)treeModel);
                ((Tree)((Object)jComponent)).setModel(treeModel);
                ((Tree)((Object)jComponent)).expandAll();
            }
        });
    }

    public void register(JComponent jComponent, AbstractButton abstractButton) {
        if (jComponent instanceof Tree) {
            NewsFrameSidebarExtension.setCurrentSidebar((Tree)((Object)jComponent), abstractButton);
        } else {
            LOGGER.warn("An invalid news-tree was registered!");
            NewsFrameSidebarExtension.setCurrentSidebar(null, null);
        }
    }

    private static synchronized void setCurrentSidebar(Tree tree, AbstractButton abstractButton) {
        currentSidebarTree = tree;
        currentSidebarButton = abstractButton;
    }

    public void unregister() {
        NewsFrameSidebarExtension.setCurrentSidebar(null, null);
    }

    public static class TreeNode
    extends SidebarTreeNode {
        private static final Icon newsIconSmall = NewsPlugin.getResourceIcon("news.png", 16);
        public static final int TYPE_ROOT = 0;
        public static final int TYPE_FEED = 1;
        private DbNewsFeed feed;
        private final int type;

        private TreeNode(int n) {
            this.type = n;
            this.feed = null;
        }

        private TreeNode(DbNewsFeed dbNewsFeed) {
            this.type = 1;
            this.feed = dbNewsFeed;
        }

        public void doShow(boolean bl) {
            if (this.isFeed()) {
                new NewsPlugin.EntryTableAction(this.feed != null ? this.feed.id : 0L, bl).actionPerformed(null);
            }
        }

        public DbNewsFeed getFeed() {
            return this.feed;
        }

        public JPopupMenu getMenu() {
            return NewsFrameSidebarExtension.createActionMenu(this);
        }

        public Icon getNodeIcon() {
            switch (this.type) {
                case 1: {
                    return this.feed != null ? newsIconSmall : null;
                }
            }
            return null;
        }

        public String getNodeText() {
            switch (this.type) {
                case 1: {
                    return this.feed != null ? this.feed.name : this.title(StringUtils.capitalize((String)I18N.tr("all news")));
                }
            }
            return "???";
        }

        public String getNodeTooltip() {
            switch (this.type) {
                case 1: {
                    return this.feed != null ? I18N.tr("Show entries of {0} news feed.", (Object)("<b>" + StringEscapeUtils.escapeXml11((String)this.feed.name) + "</b>")) : I18N.tr("Show entries of all news feeds.");
                }
            }
            return null;
        }

        public int getType() {
            return this.type;
        }

        public boolean isFeed() {
            return this.type == 1;
        }

        public void setFeed(DbNewsFeed dbNewsFeed) {
            this.feed = dbNewsFeed;
        }
    }

    public static class Tree
    extends SidebarTree {
        public TreeNode getAllFeedsNode() {
            TreeNode treeNode = this.getRootNode();
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (1 != treeNode2.getType()) continue;
                return treeNode2;
            }
            return null;
        }

        public TreeNode getRootNode() {
            return (TreeNode)((Object)this.getModel().getRoot());
        }

        public void putFeed(DbNewsFeed dbNewsFeed) {
            if (dbNewsFeed == null) {
                throw new IllegalArgumentException("No feed was provided!");
            }
            if (dbNewsFeed.id < 1L) {
                throw new IllegalArgumentException("An unsaved feed was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode = this.getAllFeedsNode();
            if (treeNode == null) {
                return;
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DbNewsFeed dbNewsFeed2;
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (treeNode2.getType() != 1 || (dbNewsFeed2 = treeNode2.getFeed()) == null || dbNewsFeed2.id != dbNewsFeed.id) continue;
                treeNode2.setFeed(dbNewsFeed);
                defaultTreeModel.nodeChanged((javax.swing.tree.TreeNode)((Object)treeNode2));
                return;
            }
            defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)new TreeNode(dbNewsFeed)), (MutableTreeNode)((Object)treeNode), treeNode.getChildCount());
        }

        public boolean removeFeed(long l) {
            if (l < 1L) {
                throw new IllegalArgumentException("An invalid feed-id was provided!");
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            TreeNode treeNode = this.getAllFeedsNode();
            if (treeNode == null) {
                return false;
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                DbNewsFeed dbNewsFeed;
                TreeNode treeNode2 = (TreeNode)((Object)treeNode.getChildAt(i));
                if (treeNode2.getType() != 1 || (dbNewsFeed = treeNode2.getFeed()) == null || dbNewsFeed.id != l) continue;
                defaultTreeModel.removeNodeFromParent((MutableTreeNode)((Object)treeNode2));
                return true;
            }
            return false;
        }
    }
}

