/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolApp;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolFrame;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolProjectPlugin;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.news.NewsEntryTablePanel;
import com.openindex.openestate.tool.news.NewsFeedDialog;
import com.openindex.openestate.tool.news.NewsFrameSidebarExtension;
import com.openindex.openestate.tool.news.NewsPermission;
import com.openindex.openestate.tool.news.NewsPluginUtils;
import com.openindex.openestate.tool.news.NewsUpdateTimer;
import com.openindex.openestate.tool.news.db.DbNewsFeed;
import com.openindex.openestate.tool.news.db.DbNewsHandler;
import com.openindex.openestate.tool.news.extensions.DbNewsExtension;
import com.openindex.openestate.tool.utils.ProjectPermission;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class NewsPlugin
extends ImmoToolProjectPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsPlugin.class);
    private static final I18n I18N = I18nFactory.getI18n(NewsPlugin.class);
    public static final String ID = "OpenEstate-Tool-News";
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/news/resources/";
    private static DbNewsExtension dbNewsExtension = null;
    private static NewsUpdateTimer updateTimer = null;

    public static synchronized void createTimer(AbstractDbDriver abstractDbDriver) {
        NewsPlugin.stopUpdateTimer();
        updateTimer = new NewsUpdateTimer(abstractDbDriver, dbNewsExtension.getNewsHandler());
    }

    protected void doStart() {
    }

    protected void doStop() {
        NewsPlugin.stopUpdateTimer();
    }

    public static DbNewsExtension getDbNewsExtension() {
        return dbNewsExtension;
    }

    public String getDescription() {
        return I18N.tr("Management of news feeds based on RSS / Atom.");
    }

    public ImageIcon getIcon() {
        return new ImageIcon(NewsPlugin.getResourceImage("news.png", 32));
    }

    public String getId() {
        return ID;
    }

    public static NewsPlugin getInstance() {
        return (NewsPlugin)ImmoToolEnvironment.getPlugin((String)ID);
    }

    public String getLicense() {
        return "Freeware";
    }

    public ProjectPermission[] getPermissions() {
        return NewsPermission.values();
    }

    public final String[] getRequiredProcedures() {
        return dbNewsExtension != null ? dbNewsExtension.getRequiredProcedures() : null;
    }

    public final String[] getRequiredViews() {
        return dbNewsExtension != null ? dbNewsExtension.getRequiredViews() : null;
    }

    public static Icon getResourceIcon(String string, int n) {
        return ImmoToolUtils.getResourceIcon((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)NewsPlugin.class.getClassLoader());
    }

    public static Image getResourceImage(String string, int n) {
        return ImmoToolUtils.getResourceImage((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)NewsPlugin.class.getClassLoader());
    }

    public static URL getResourceImageURL(String string, int n) {
        return ImmoToolUtils.getResourceImageURL((String)RESOURCE_PATH, (int)n, (String)string, (ClassLoader)NewsPlugin.class.getClassLoader());
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("news"));
    }

    public String getUninstallQuery(String string) throws IOException {
        DbNewsExtension dbNewsExtension = NewsPluginUtils.getDbNewsExtension(string);
        if (dbNewsExtension == null) {
            throw new IOException("Can't find a DbNewsExtension for driver '" + string + "'!");
        }
        return dbNewsExtension.getUninstallQuery();
    }

    public DbUpdateHandler getUpdateHandler(String string) {
        DbNewsExtension dbNewsExtension = NewsPluginUtils.getDbNewsExtension(string);
        if (dbNewsExtension == null) {
            LOGGER.warn("Can't find a DbNewsExtension for driver '" + string + "'!");
            return null;
        }
        return dbNewsExtension.getUpdateHandler();
    }

    public void install(Connection connection, DbExtension dbExtension, String string, boolean bl) throws SQLException, IOException {
        DbNewsExtension dbNewsExtension = NewsPluginUtils.getDbNewsExtension(string);
        if (dbNewsExtension == null) {
            throw new SQLException("Can't find a DbNewsExtension for driver '" + string + "'!");
        }
        dbNewsExtension.install(connection);
        super.install(connection, dbExtension, string, bl);
        if (bl) {
            Properties properties = NewsPluginUtils.getDefaultFeeds();
            int n = 0;
            String string2 = properties.getProperty("feed." + n + ".title");
            String string3 = properties.getProperty("feed." + n + ".url");
            while (string2 != null && string3 != null) {
                try {
                    DbNewsFeed dbNewsFeed = new DbNewsFeed();
                    dbNewsFeed.name = string2;
                    dbNewsFeed.url = new URI(string3);
                    dbNewsFeed.isUpdateEnabled = true;
                    dbNewsFeed.updateInterval = 900000L;
                    dbNewsExtension.getNewsHandler().saveFeed(connection, dbNewsFeed);
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOGGER.warn("Can't save default news feed!");
                    LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                }
                string2 = properties.getProperty("feed." + ++n + ".title");
                string3 = properties.getProperty("feed." + n + ".url");
            }
        }
    }

    public boolean isAllowed(ImmoToolProject immoToolProject) {
        return NewsPlugin.isUserAllowedTo(NewsPermission.USE_PLUGIN, immoToolProject);
    }

    public boolean isUsable(ImmoToolProject immoToolProject) {
        return super.isUsable(immoToolProject) && this.isAllowed(immoToolProject);
    }

    public static boolean isUserAllowedTo(NewsPermission newsPermission) {
        return NewsPlugin.isUserAllowedTo(newsPermission, ImmoToolProject.getAppInstance());
    }

    public static boolean isUserAllowedTo(NewsPermission newsPermission, ImmoToolProject immoToolProject) {
        if (immoToolProject == null) {
            return false;
        }
        DbUser dbUser = immoToolProject.getUser();
        return dbUser != null && dbUser.isAllowedTo(ID, (ProjectPermission)newsPermission);
    }

    public static void loadSettings(ImmoToolProject immoToolProject) {
    }

    public static void loadSettings(ImmoToolProject immoToolProject, Connection connection) {
    }

    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        NewsPlugin.getDbNewsExtension().repair(connection, abstractDbDriver);
    }

    public static void saveSettings(ImmoToolProject immoToolProject) {
    }

    public static void saveSettings(ImmoToolProject immoToolProject, Connection connection) {
    }

    public static void setDbNewsExtension(DbNewsExtension dbNewsExtension) {
        NewsPlugin.dbNewsExtension = dbNewsExtension;
    }

    public static void startUpdateTimer() {
        NewsPlugin.startUpdateTimer(-1);
    }

    public static void startUpdateTimer(int n) {
        if (updateTimer != null) {
            updateTimer.setInitialDelay(n >= 0 ? n : updateTimer.getDelay());
            updateTimer.start();
        }
    }

    public static void stopUpdateTimer() {
        if (updateTimer != null) {
            updateTimer.stop();
        }
    }

    public static void unloadSettings() {
    }

    public static final class SidebarSelectAction
    extends AbstractI18nAction {
        public SidebarSelectAction() {
            this.setSmallIcon(NewsPlugin.getResourceIcon("news.png", 16));
            this.setEnabled(NewsPlugin.isUserAllowedTo(NewsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolFrame immoToolFrame = (ImmoToolFrame)ImmoToolApp.getInstance().getFrame();
            if (immoToolFrame != null) {
                immoToolFrame.selectSidebar(NewsFrameSidebarExtension.class);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show news view")));
            this.setShortDescription(I18N.tr("Show news view in the sidebar."));
        }
    }

    private static final class SidebarRefreshTask
    extends ImmoToolTask<TreeModel, Void> {
        private final NewsFrameSidebarExtension.Tree tree;

        private SidebarRefreshTask(NewsFrameSidebarExtension.Tree tree) {
            this.tree = tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TreeModel doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbNewsHandler dbNewsHandler = NewsPlugin.getDbNewsExtension().getNewsHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                TreeModel treeModel = NewsFrameSidebarExtension.createTreeModel(immoToolProject, connection, dbNewsHandler);
                return treeModel;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't refresh sidebar!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(TreeModel treeModel) {
            super.succeeded((Object)treeModel);
            if (treeModel == null) {
                return;
            }
            this.tree.setModel(treeModel);
            this.tree.expandAll();
        }
    }

    public static final class SidebarRefreshAction
    extends AbstractI18nAction {
        public SidebarRefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.setEnabled(NewsPlugin.isUserAllowedTo(NewsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewsFrameSidebarExtension.Tree tree = NewsFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                ImmoToolUtils.executeTask((ImmoToolTask)new SidebarRefreshTask(tree));
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Refresh news view in the sidebar."));
        }
    }

    private static final class FeedRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long feedId;

        private FeedRemoveTask(long l) {
            this.feedId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbNewsExtension.getNewsHandler().removeFeed(connection, this.feedId);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't remove news feed!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            NewsFrameSidebarExtension.Tree tree = NewsFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                tree.removeFeed(this.feedId);
            }
        }
    }

    public static final class FeedRemoveAction
    extends AbstractI18nAction {
        private final long feedId;

        public FeedRemoveAction(long l) {
            this.feedId = l;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(NewsPlugin.isUserAllowedTo(NewsPermission.FEEDS_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.feedId < 1L) {
                return;
            }
            boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove news feed {0}?", (Object)("#" + this.feedId)), (Component)ImmoToolEnvironment.getFrame());
            if (bl) {
                ImmoToolUtils.executeTask((ImmoToolTask)new FeedRemoveTask(this.feedId));
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove news feed")));
            this.setShortDescription(I18N.tr("Remove the selected news feed."));
        }
    }

    private static final class FeedDialogTask
    extends ImmoToolTask<DbNewsFeed, Void> {
        private final long feedId;

        private FeedDialogTask(long l) {
            this.feedId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbNewsFeed doInBackground() throws Exception {
            DbNewsFeed dbNewsFeed;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbNewsFeed dbNewsFeed2 = dbNewsFeed = this.feedId > 0L ? NewsFeedDialog.showDialog(this.feedId, immoToolProject, (Window)ImmoToolEnvironment.getFrame()) : NewsFeedDialog.showDialog(immoToolProject, (Window)ImmoToolEnvironment.getFrame());
            if (dbNewsFeed == null) {
                return null;
            }
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbNewsExtension.getNewsHandler().saveFeed(connection, dbNewsFeed);
                DbNewsFeed dbNewsFeed3 = dbNewsFeed;
                return dbNewsFeed3;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load form for news feed!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(DbNewsFeed dbNewsFeed) {
            super.succeeded((Object)dbNewsFeed);
            if (dbNewsFeed == null) {
                return;
            }
            NewsFrameSidebarExtension.Tree tree = NewsFrameSidebarExtension.getCurrentSidebarTree();
            if (tree != null) {
                tree.putFeed(dbNewsFeed);
            }
        }
    }

    public static final class FeedDialogAction
    extends AbstractI18nAction {
        private final long feedId;

        public FeedDialogAction() {
            this(0L);
        }

        public FeedDialogAction(long l) {
            this.feedId = l;
            if (l < 1L) {
                this.setSmallIcon(NewsPlugin.getResourceIcon("news.png", 16));
                this.setEnabled(NewsPlugin.isUserAllowedTo(NewsPermission.FEEDS_EDIT));
            } else {
                this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
                this.setEnabled(NewsPlugin.isUserAllowedTo(NewsPermission.FEEDS_EDIT));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new FeedDialogTask(this.feedId));
        }

        protected final void updateLocalization() {
            if (this.feedId < 1L) {
                this.setName(StringUtils.capitalize((String)I18N.tr("add news feed")));
                this.setShortDescription(I18N.tr("Add a new news feed."));
            } else {
                this.setName(StringUtils.capitalize((String)I18N.tr("edit news feed")));
                this.setShortDescription(I18N.tr("Show details about the news feed."));
            }
        }
    }

    private static final class EntryTableTask
    extends ImmoToolTask<NewsEntryTablePanel, Void> {
        private final long feedId;
        private final boolean asNewTab;

        private EntryTableTask(long l, boolean bl) {
            this.feedId = l > 0L ? l : 0L;
            this.asNewTab = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected NewsEntryTablePanel doInBackground() throws Exception {
            Object object;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbNewsHandler dbNewsHandler = NewsPlugin.getDbNewsExtension().getNewsHandler();
            DbNewsFeed dbNewsFeed = null;
            if (this.feedId > 0L) {
                object = null;
                try {
                    object = immoToolProject.getDbConnection();
                    dbNewsFeed = dbNewsHandler.getFeed((Connection)object, this.feedId);
                    if (dbNewsFeed == null) {
                        throw new Exception("Can't find news feed #" + this.feedId + "!");
                    }
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)object);
                }
            }
            AbstractMainTab abstractMainTab = object = !this.asNewTab ? ImmoToolAppUtils.getMatchingTab(NewsEntryTablePanel.class) : null;
            if (object instanceof NewsEntryTablePanel) {
                NewsEntryTablePanel newsEntryTablePanel = (NewsEntryTablePanel)((Object)object);
                if (newsEntryTablePanel.getCurrentFeedId() != this.feedId) {
                    newsEntryTablePanel.setFeed(dbNewsFeed);
                    newsEntryTablePanel.loadInBackground(immoToolProject.getDbDriver());
                }
                ImmoToolAppUtils.selectTab((Component)((Object)newsEntryTablePanel));
                return null;
            }
            return NewsEntryTablePanel.createTab(dbNewsFeed);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load news table!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(NewsEntryTablePanel newsEntryTablePanel) {
            super.succeeded((Object)newsEntryTablePanel);
            if (newsEntryTablePanel != null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)newsEntryTablePanel);
                newsEntryTablePanel.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            }
        }
    }

    public static final class EntryTableAction
    extends AbstractI18nAction {
        private final long feedId;
        private final boolean asNewTab;

        public EntryTableAction() {
            this(0L, false);
        }

        public EntryTableAction(long l) {
            this(l, false);
        }

        public EntryTableAction(boolean bl) {
            this(0L, bl);
        }

        public EntryTableAction(long l, boolean bl) {
            this.feedId = l;
            this.asNewTab = bl;
            this.setSmallIcon(NewsPlugin.getResourceIcon("news.png", 16));
            this.setEnabled(NewsPlugin.isUserAllowedTo(NewsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new EntryTableTask(this.feedId, this.asNewTab));
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show news messages")));
            this.setShortDescription(I18N.tr("Show a table of all news messages."));
        }
    }
}

