/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news.db;

import com.openindex.openestate.tool.news.db.DbNewsEntry;
import com.openindex.openestate.tool.news.db.DbNewsFeed;
import com.openindex.openestate.tool.news.db.DbNewsHandler;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class DbNewsHandlerImpl
implements DbNewsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbNewsHandlerImpl.class);
    private static final I18n I18N = I18nFactory.getI18n(DbNewsHandlerImpl.class);

    @Override
    public final DbNewsEntry[] getEntries(Connection connection) throws SQLException {
        return this.getEntries(connection, null);
    }

    @Override
    public final DbNewsEntry[] getEntries(Connection connection, long l) throws SQLException {
        return this.getEntries(connection, new long[]{l});
    }

    @Override
    public abstract DbNewsEntry[] getEntries(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbNewsEntry getEntry(Connection var1, long var2, String var4) throws SQLException;

    @Override
    public final long[] getEntryIds(Connection connection) throws SQLException {
        return this.getEntryIds(connection, null);
    }

    @Override
    public final long[] getEntryIds(Connection connection, long l) throws SQLException {
        return this.getEntryIds(connection, new long[]{l});
    }

    @Override
    public abstract long[] getEntryIds(Connection var1, long[] var2) throws SQLException;

    @Override
    public final DbNewsFeed getFeed(Connection connection, long l) throws SQLException {
        DbNewsFeed[] dbNewsFeedArray = this.getFeeds(connection, new long[]{l});
        return dbNewsFeedArray != null && dbNewsFeedArray.length > 0 ? dbNewsFeedArray[0] : null;
    }

    @Override
    public final DbNewsFeed[] getFeeds(Connection connection) throws SQLException {
        return this.getFeeds(connection, (Boolean)null);
    }

    @Override
    public abstract DbNewsFeed[] getFeeds(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbNewsFeed[] getFeeds(Connection var1, Boolean var2) throws SQLException;

    @Override
    public final long[] getFeedIds(Connection connection) throws SQLException {
        return this.getFeedIds(connection, null);
    }

    @Override
    public abstract long[] getFeedIds(Connection var1, Boolean var2) throws SQLException;

    @Override
    public final void removeEntry(Connection connection, long l) throws SQLException {
        this.removeEntries(connection, new long[]{l});
    }

    @Override
    public abstract void removeEntries(Connection var1, long[] var2) throws SQLException;

    @Override
    public final void removeFeed(Connection connection, long l) throws SQLException {
        if (l > 0L) {
            this.removeFeeds(connection, new long[]{l});
        }
    }

    @Override
    public abstract void removeFeeds(Connection var1, long[] var2) throws SQLException;

    @Override
    public final void removeFeedEntries(Connection connection, long l) throws SQLException {
        this.removeFeedEntries(connection, new long[]{l});
    }

    @Override
    public final void removeFeedEntries(Connection connection, long[] lArray) throws SQLException {
        if (lArray == null || lArray.length < 1) {
            return;
        }
        this.removeFeeds(connection, this.getEntryIds(connection, lArray));
    }

    @Override
    public abstract void saveEntry(Connection var1, DbNewsEntry var2) throws SQLException;

    @Override
    public abstract void saveFeed(Connection var1, DbNewsFeed var2) throws SQLException;
}

