/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.news.db.DbNewsEntry;
import com.openindex.openestate.tool.news.db.DbNewsFeed;
import com.openindex.openestate.tool.news.db.DbNewsHandlerImpl;
import com.openindex.openestate.tool.utils.Permission;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbNewsHandler
extends DbNewsHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbNewsHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbNewsHandler.class);
    public static final String PROC_REMOVE_FEEDS = "remove_immotool_news_feeds";
    public static final String PROC_REMOVE_ENTRIES = "remove_immotool_news_entries";
    public static final String PROC_SAVE_FEEDS = "save_immotool_news_feeds";
    public static final String PROC_SAVE_ENTRIES = "save_immotool_news_entries";
    public static final String VIEW_FEEDS = "view_immotool_news_feeds";
    public static final String VIEW_ENTRIES = "view_immotool_news_entries";
    public static final String TABLE_NEWS_FEEDS = "immotool_news_feeds";
    public static final String FIELD_FEED_ID = "feed_id";
    public static final String FIELD_FEED_NAME = "feed_name";
    public static final String FIELD_FEED_URL = "feed_url";
    public static final String FIELD_FEED_AUTH_METHOD = "feed_auth_method";
    public static final String FIELD_FEED_AUTH_USER = "feed_auth_user";
    public static final String FIELD_FEED_AUTH_PASS = "feed_auth_pass";
    public static final String FIELD_FEED_NOTES = "feed_notes";
    public static final String FIELD_FEED_ARCHIVED = "feed_archived";
    public static final String FIELD_FEED_UPDATE_ENABLED = "feed_update_enabled";
    public static final String FIELD_FEED_UPDATE_INTERVAL = "feed_update_interval";
    public static final String FIELD_FEED_DOWNLOADED_AT = "feed_downloaded_at";
    public static final String FIELD_FEED_PUBLISHED_AT = "feed_published_at";
    public static final String TABLE_NEWS_ENTRIES = "immotool_news_entries";
    public static final String FIELD_ENTRY_ID = "entry_id";
    public static final String FIELD_ENTRY_URI = "entry_uri";
    public static final String FIELD_ENTRY_TITLE = "entry_title";
    public static final String FIELD_ENTRY_AUTHOR = "entry_author";
    public static final String FIELD_ENTRY_CONTENT = "entry_content";
    public static final String FIELD_ENTRY_LINK = "entry_link";
    public static final String FIELD_ENTRY_TIME = "entry_time";
    public static final String FIELD_ENTRY_NEW = "entry_new";
    public static final String FIELD_ENTRY_STICKY = "entry_sticky";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_ACCESS_OWNER_ID = "access_owner_id";
    private static final String FIELD_ACCESS_GROUP_ID = "access_group_id";
    private static final String FIELD_ACCESS_PERMISSIONS = "access_permissions";

    private static DbNewsEntry createEntry(ResultSet resultSet) throws SQLException {
        String string;
        DbNewsEntry dbNewsEntry = new DbNewsEntry();
        dbNewsEntry.id = resultSet.getLong(FIELD_ENTRY_ID);
        dbNewsEntry.feedId = resultSet.getLong(FIELD_FEED_ID);
        dbNewsEntry.author = resultSet.getString(FIELD_ENTRY_AUTHOR);
        dbNewsEntry.content = resultSet.getString(FIELD_ENTRY_CONTENT);
        dbNewsEntry.title = resultSet.getString(FIELD_ENTRY_TITLE);
        dbNewsEntry.time = resultSet.getTimestamp(FIELD_ENTRY_TIME);
        dbNewsEntry.isNew = resultSet.getBoolean(FIELD_ENTRY_NEW);
        dbNewsEntry.isSticky = resultSet.getBoolean(FIELD_ENTRY_STICKY);
        dbNewsEntry.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbNewsEntry.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        try {
            string = resultSet.getString(FIELD_ENTRY_URI);
            if (StringUtils.isNotBlank((CharSequence)string)) {
                dbNewsEntry.uri = new URI(string.trim());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            dbNewsEntry.uri = null;
            LOGGER.warn("Can't read feed-uri!");
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
        }
        try {
            string = resultSet.getString(FIELD_ENTRY_LINK);
            if (StringUtils.isNotBlank((CharSequence)string)) {
                dbNewsEntry.link = new URI(string.trim());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            dbNewsEntry.link = null;
            LOGGER.warn("Can't read feed-link!");
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
        }
        return dbNewsEntry;
    }

    private static DbNewsFeed createFeed(ResultSet resultSet) throws SQLException {
        DbNewsFeed dbNewsFeed = new DbNewsFeed();
        dbNewsFeed.id = resultSet.getLong(FIELD_FEED_ID);
        dbNewsFeed.name = resultSet.getString(FIELD_FEED_NAME);
        dbNewsFeed.notes = resultSet.getString(FIELD_FEED_NOTES);
        dbNewsFeed.isArchived = resultSet.getBoolean(FIELD_FEED_ARCHIVED);
        dbNewsFeed.isUpdateEnabled = resultSet.getBoolean(FIELD_FEED_UPDATE_ENABLED);
        dbNewsFeed.updateInterval = resultSet.getLong(FIELD_FEED_UPDATE_INTERVAL);
        dbNewsFeed.publishedAt = resultSet.getTimestamp(FIELD_FEED_PUBLISHED_AT);
        dbNewsFeed.downloadedAt = resultSet.getTimestamp(FIELD_FEED_DOWNLOADED_AT);
        dbNewsFeed.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbNewsFeed.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        dbNewsFeed.ownerUserId = resultSet.getLong(FIELD_ACCESS_OWNER_ID);
        dbNewsFeed.ownerGroupId = resultSet.getLong(FIELD_ACCESS_GROUP_ID);
        dbNewsFeed.permission = new Permission(resultSet.getInt(FIELD_ACCESS_PERMISSIONS));
        dbNewsFeed.authUser = resultSet.getString(FIELD_FEED_AUTH_USER);
        String string = resultSet.getString(FIELD_FEED_AUTH_PASS);
        dbNewsFeed.authPassword = !StringUtils.isBlank((CharSequence)string) ? string.toCharArray() : null;
        String string2 = resultSet.getString(FIELD_FEED_AUTH_METHOD);
        try {
            dbNewsFeed.authMethod = !StringUtils.isBlank((CharSequence)string2) ? DbNewsFeed.AuthMethod.valueOf(string2) : DbNewsFeed.AuthMethod.ANONYMOUS;
        }
        catch (Exception exception) {
            dbNewsFeed.authMethod = DbNewsFeed.AuthMethod.ANONYMOUS;
            LOGGER.warn("Can't read auth method for feed #" + dbNewsFeed.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            dbNewsFeed.url = new URI(resultSet.getString(FIELD_FEED_URL));
        }
        catch (URISyntaxException uRISyntaxException) {
            dbNewsFeed.url = null;
            LOGGER.warn("Can't read feed-url!");
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
        }
        return dbNewsFeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbNewsEntry[] getEntries(Connection connection, long[] lArray) throws SQLException {
        DbNewsEntry[] dbNewsEntryArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbNewsEntry[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_news_entries ORDER BY entry_time DESC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_news_entries WHERE feed_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_ENTRY_TIME + " DESC;");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbNewsEntry> arrayList = new ArrayList<DbNewsEntry>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbNewsHandler.createEntry(resultSet));
            }
            dbNewsEntryArray = arrayList.toArray(new DbNewsEntry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbNewsEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbNewsEntry getEntry(Connection connection, long l, String string) throws SQLException {
        DbNewsEntry dbNewsEntry;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_news_entries WHERE feed_id = ? AND entry_uri = ? LIMIT 1;");
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            dbNewsEntry = resultSet.next() ? HSqlDbNewsHandler.createEntry(resultSet) : null;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbNewsEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getEntryIds(Connection connection, long[] lArray) throws SQLException {
        long[] lArray2;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT entry_id FROM view_immotool_news_entries ORDER BY entry_time DESC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT entry_id FROM view_immotool_news_entries WHERE feed_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_ENTRY_TIME + " DESC;");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_ENTRY_ID));
            }
            lArray2 = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbNewsFeed[] getFeeds(Connection connection, long[] lArray) throws SQLException {
        DbNewsFeed[] dbNewsFeedArray;
        if (lArray != null && lArray.length < 1) {
            return new DbNewsFeed[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_news_feeds ORDER BY feed_name ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_news_feeds WHERE feed_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_FEED_NAME + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbNewsFeed> arrayList = new ArrayList<DbNewsFeed>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbNewsHandler.createFeed(resultSet));
            }
            dbNewsFeedArray = arrayList.toArray(new DbNewsFeed[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbNewsFeedArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbNewsFeed[] getFeeds(Connection connection, Boolean bl) throws SQLException {
        DbNewsFeed[] dbNewsFeedArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (bl == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_news_feeds ORDER BY feed_name ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_news_feeds WHERE feed_update_enabled = ? ORDER BY feed_name ASC;");
                preparedStatement.setBoolean(1, bl);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbNewsFeed> arrayList = new ArrayList<DbNewsFeed>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbNewsHandler.createFeed(resultSet));
            }
            dbNewsFeedArray = arrayList.toArray(new DbNewsFeed[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbNewsFeedArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getFeedIds(Connection connection, Boolean bl) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (bl == null) {
                preparedStatement = connection.prepareStatement("SELECT feed_id FROM view_immotool_news_feeds ORDER BY feed_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT feed_id FROM view_immotool_news_feeds WHERE feed_update_enabled = ? ORDER BY feed_id ASC;");
                preparedStatement.setBoolean(1, bl);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_FEED_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    @Override
    public void removeEntries(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_news_entries(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void removeFeeds(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_news_feeds(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveEntry(Connection connection, DbNewsEntry dbNewsEntry) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            long l;
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_news_entries(:entry_id, :feed_id, :entry_uri, :entry_title, :entry_author, :entry_content, :entry_link, :entry_time, :entry_new, :entry_sticky);");
            namedCallableStatement.setLong(FIELD_ENTRY_ID, dbNewsEntry.id);
            namedCallableStatement.setLong(FIELD_FEED_ID, dbNewsEntry.feedId);
            namedCallableStatement.setBoolean(FIELD_ENTRY_NEW, dbNewsEntry.isNew);
            namedCallableStatement.setBoolean(FIELD_ENTRY_STICKY, dbNewsEntry.isSticky);
            namedCallableStatement.setString(FIELD_ENTRY_CONTENT, dbNewsEntry.content);
            namedCallableStatement.setString(FIELD_ENTRY_URI, dbNewsEntry.uri != null ? StringUtils.abbreviate((String)dbNewsEntry.uri.toString(), (int)255) : null);
            namedCallableStatement.setString(FIELD_ENTRY_LINK, dbNewsEntry.link != null ? StringUtils.abbreviate((String)dbNewsEntry.link.toString(), (int)255) : null);
            namedCallableStatement.setString(FIELD_ENTRY_TITLE, StringUtils.abbreviate((String)dbNewsEntry.title, (int)255));
            namedCallableStatement.setString(FIELD_ENTRY_AUTHOR, StringUtils.abbreviate((String)dbNewsEntry.author, (int)255));
            namedCallableStatement.setTimestamp(FIELD_ENTRY_TIME, dbNewsEntry.time != null ? new Timestamp(dbNewsEntry.time.getTime()) : null);
            namedCallableStatement.execute();
            long l2 = l = dbNewsEntry.id < 1L ? namedCallableStatement.getLong(FIELD_ENTRY_ID) : dbNewsEntry.id;
            if (l < 1L) {
                throw new SQLException("Can't determine ID of the saved object!");
            }
            connection.commit();
            if (dbNewsEntry.id < 1L) {
                dbNewsEntry.id = l;
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveFeed(Connection connection, DbNewsFeed dbNewsFeed) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            long l;
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_news_feeds(:feed_id, :feed_name, :feed_url, :feed_auth_method, :feed_auth_user, :feed_auth_pass, :feed_notes, :feed_archived, :feed_update_enabled, :feed_update_interval, :feed_downloaded_at, :feed_published_at, :access_owner_id, :access_group_id, :access_permissions);");
            namedCallableStatement.setLong(FIELD_FEED_ID, dbNewsFeed.id);
            namedCallableStatement.setLong(FIELD_FEED_UPDATE_INTERVAL, dbNewsFeed.updateInterval);
            namedCallableStatement.setBoolean(FIELD_FEED_ARCHIVED, dbNewsFeed.isArchived);
            namedCallableStatement.setBoolean(FIELD_FEED_UPDATE_ENABLED, dbNewsFeed.isUpdateEnabled);
            namedCallableStatement.setString(FIELD_FEED_NOTES, dbNewsFeed.notes);
            namedCallableStatement.setString(FIELD_FEED_NAME, StringUtils.abbreviate((String)dbNewsFeed.name, (int)100));
            namedCallableStatement.setString(FIELD_FEED_URL, dbNewsFeed.url != null ? StringUtils.abbreviate((String)dbNewsFeed.url.toString(), (int)255) : null);
            namedCallableStatement.setString(FIELD_FEED_AUTH_METHOD, dbNewsFeed.authMethod != null ? dbNewsFeed.authMethod.name() : DbNewsFeed.AuthMethod.ANONYMOUS.name());
            namedCallableStatement.setString(FIELD_FEED_AUTH_USER, StringUtils.abbreviate((String)dbNewsFeed.authUser, (int)100));
            namedCallableStatement.setString(FIELD_FEED_AUTH_PASS, dbNewsFeed.authPassword != null ? StringUtils.abbreviate((String)String.valueOf(dbNewsFeed.authPassword), (int)255) : null);
            namedCallableStatement.setTimestamp(FIELD_FEED_DOWNLOADED_AT, dbNewsFeed.downloadedAt != null ? new Timestamp(dbNewsFeed.downloadedAt.getTime()) : null);
            namedCallableStatement.setTimestamp(FIELD_FEED_PUBLISHED_AT, dbNewsFeed.publishedAt != null ? new Timestamp(dbNewsFeed.publishedAt.getTime()) : null);
            namedCallableStatement.setLong(FIELD_ACCESS_OWNER_ID, dbNewsFeed.ownerUserId);
            namedCallableStatement.setLong(FIELD_ACCESS_GROUP_ID, dbNewsFeed.ownerGroupId);
            namedCallableStatement.setInt(FIELD_ACCESS_PERMISSIONS, dbNewsFeed.permission != null ? dbNewsFeed.permission.getValue() : -1);
            namedCallableStatement.execute();
            long l2 = l = dbNewsFeed.id < 1L ? namedCallableStatement.getLong(FIELD_FEED_ID) : dbNewsFeed.id;
            if (l < 1L) {
                throw new SQLException("Can't determine ID of the saved object!");
            }
            connection.commit();
            if (dbNewsFeed.id <= 0L) {
                dbNewsFeed.id = l;
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

