/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTable;
import com.openindex.openestate.tool.news.NewsDownloadTask;
import com.openindex.openestate.tool.news.NewsEntryTable;
import com.openindex.openestate.tool.news.NewsPlugin;
import com.openindex.openestate.tool.news.db.DbNewsEntry;
import com.openindex.openestate.tool.news.db.DbNewsFeed;
import com.openindex.openestate.tool.news.db.DbNewsHandler;
import com.openindex.openestate.tool.utils.XHTMLViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class NewsEntryTablePanel
extends AbstractMainTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsEntryTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(NewsEntryTablePanel.class);
    private static final String TABLE_ID = "NewsEntryTablePanel.Table";
    private DbNewsFeed currentFeed = null;
    private DbNewsEntry currentEntry = null;
    private URI currentEntryUrl = null;
    private JSplitPane mainSplitter;
    private int mainSplitterLocation = -1;
    private Table table;
    private JXTitledSeparator viewerTitle;
    private XHTMLViewer viewer;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction entryOpenLinkAction;

    private NewsEntryTablePanel() {
        this.updateLocalization();
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.refreshAction = this.createDefaultRefreshAction();
        this.closeAction = this.createDefaultCloseAction();
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.refreshAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildMainComponent() {
        this.viewer = new XHTMLViewer();
        this.viewer.registerDefaultListeners();
        this.viewerTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.entryOpenLinkAction = new EntryOpenLinkAction();
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder((Border)Paddings.DIALOG);
        jPanel.setVisible(false);
        jPanel.add((Component)ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.viewerTitle, (Action[])new Action[]{this.entryOpenLinkAction}), "North");
        jPanel.add((Component)this.viewer, "Center");
        this.mainSplitter = new JSplitPane(0);
        this.mainSplitter.setTopComponent(((Table)this.createTable()).createScrollPane());
        this.mainSplitter.setBottomComponent(jPanel);
        return this.mainSplitter;
    }

    public static NewsEntryTablePanel createTab() {
        return NewsEntryTablePanel.createTab(null);
    }

    public static NewsEntryTablePanel createTab(DbNewsFeed dbNewsFeed) {
        NewsEntryTablePanel newsEntryTablePanel = new NewsEntryTablePanel();
        newsEntryTablePanel.setFeed(dbNewsFeed);
        return newsEntryTablePanel;
    }

    protected JXTable createTable() {
        this.table = new Table();
        return this.table;
    }

    private void doEntryOpenLink() {
        if (this.currentEntryUrl != null) {
            ImmoToolUtils.openURL((URI)this.currentEntryUrl);
        }
    }

    private void doEntryView(DbNewsEntry dbNewsEntry) {
        this.currentEntry = dbNewsEntry;
        this.currentEntryUrl = null;
        if (dbNewsEntry == null) {
            this.mainSplitter.getBottomComponent().setVisible(false);
            this.setButtonsEnabled(true);
            return;
        }
        this.currentEntryUrl = dbNewsEntry.link;
        if (this.currentEntryUrl == null) {
            this.currentEntryUrl = this.currentEntry.uri;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new EntryViewTask(this.currentEntry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadInBackground(Connection connection) throws Exception {
        this.mainSplitter.getBottomComponent().setVisible(false);
        this.table.setEnabled(false);
        this.table.clearSelection();
        this.table.clearRows();
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        try {
            Serializable[] serializableArray;
            long[] lArray;
            DbNewsHandler dbNewsHandler = NewsPlugin.getDbNewsExtension().getNewsHandler();
            if (this.currentFeed != null) {
                lArray = new long[]{this.currentFeed.id};
                hashMap.put(this.currentFeed.id, this.currentFeed.name);
            } else {
                serializableArray = dbNewsHandler.getFeeds(connection);
                lArray = new long[serializableArray.length];
                for (int i = 0; i < serializableArray.length; ++i) {
                    lArray[i] = serializableArray[i].id;
                    hashMap.put(((DbNewsFeed)serializableArray[i]).id, ((DbNewsFeed)serializableArray[i]).name);
                }
            }
            serializableArray = dbNewsHandler.getEntries(connection, lArray);
            arrayList.addAll(Arrays.asList(serializableArray));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList, hashMap){
                final /* synthetic */ List val$entriesList;
                final /* synthetic */ Map val$feedNames;
                {
                    this.val$entriesList = list;
                    this.val$feedNames = map;
                }

                @Override
                public void run() {
                    try {
                        for (DbNewsEntry dbNewsEntry : this.val$entriesList) {
                            NewsEntryTablePanel.this.table.addRow(new NewsEntryTable.Row(dbNewsEntry, StringUtils.trimToNull((String)((String)this.val$feedNames.get(dbNewsEntry.feedId)))));
                        }
                    }
                    finally {
                        NewsEntryTablePanel.this.table.setEnabled(true);
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void doRefresh() {
        this.setFeed(this.currentFeed);
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new FeedDownloadTask(ImmoToolProject.getAppInstance().getDbDriver(), NewsPlugin.getDbNewsExtension().getNewsHandler()));
    }

    public DbNewsFeed getCurrentFeed() {
        return this.currentFeed;
    }

    public long getCurrentFeedId() {
        return this.currentFeed != null ? this.currentFeed.id : 0L;
    }

    protected Icon getHeaderIcon() {
        return NewsPlugin.getResourceIcon("news.png", 32);
    }

    protected String getHeaderTitle() {
        int n;
        String string = StringUtils.capitalize((String)I18N.tr("news messages"));
        int n2 = n = this.table != null ? this.table.getRowCount() : 0;
        if (n > 0) {
            string = string + " / ";
            string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        return string;
    }

    public String getTabTitle() {
        return this.currentFeed != null && this.currentFeed.id > 0L ? StringUtils.capitalize((String)I18N.tr("news from {0}", (Object)StringUtils.trimToEmpty((String)this.currentFeed.name))) : StringUtils.capitalize((String)I18N.tr("all news"));
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.closeAction.setEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.entryOpenLinkAction.setEnabled(bl && this.table.getSelectedRowCount() > 0 && this.currentEntryUrl != null);
    }

    public void setFeed(DbNewsFeed dbNewsFeed) {
        this.currentFeed = dbNewsFeed;
        this.table.clearSelection();
        this.table.clearRows();
        this.mainSplitter.getBottomComponent().setVisible(false);
        this.updateLocalization();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.viewerTitle.setTitle(StringUtils.capitalize((String)I18N.tr("selected news message")));
    }

    private class FeedDownloadTask
    extends NewsDownloadTask {
        private final AbstractDbDriver dbDriver;
        private final DbNewsHandler newsHandler;

        private FeedDownloadTask(AbstractDbDriver abstractDbDriver, DbNewsHandler dbNewsHandler) {
            super(abstractDbDriver, dbNewsHandler);
            this.dbDriver = abstractDbDriver;
            this.newsHandler = dbNewsHandler;
        }

        @Override
        protected Integer executeTask(Connection connection) throws Exception {
            if (NewsEntryTablePanel.this.currentFeed != null) {
                this.addFeed(NewsEntryTablePanel.this.currentFeed);
            } else {
                for (DbNewsFeed dbNewsFeed : this.newsHandler.getFeeds(connection)) {
                    this.addFeed(dbNewsFeed);
                }
            }
            return super.executeTask(connection);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't download news feed!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            NewsEntryTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Integer n) {
            super.succeeded((Object)n);
            NewsEntryTablePanel.this.loadInBackground(this.dbDriver);
        }
    }

    private class EntryViewTask
    extends ImmoToolTask<Document, Void> {
        private final DbNewsEntry entry;

        private EntryViewTask(DbNewsEntry dbNewsEntry) {
            this.entry = dbNewsEntry;
        }

        protected Document doInBackground() throws Exception {
            DateFormat dateFormat = DateFormat.getDateInstance(2);
            DateFormat dateFormat2 = DateFormat.getTimeInstance(3);
            String string = this.entry.title;
            if (string != null && string.trim().length() > 0) {
                string = "<h2 style=\"margin-top:0;\">" + string.trim() + "</h2>";
            }
            Date date = this.entry.time;
            String string2 = this.entry.author;
            if (string2 != null && string2.trim().length() > 0) {
                string = string + "<i>" + string2 + "</i>";
            }
            String string3 = "<html><div style=\"font-family:sans-serif; padding:5px;\">";
            string3 = string3 + "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">";
            string3 = string3 + "<tr valign=\"top\">";
            string3 = string3 + "<td>" + string + "</td>";
            if (date != null) {
                string3 = string3 + "<td align=\"right\">" + dateFormat.format(date) + "<br/>" + dateFormat2.format(date) + "</td>";
            }
            string3 = string3 + "</tr>";
            string3 = string3 + "<tr><td colspan=\"2\"><hr></td></tr>";
            string3 = string3 + "<tr><td colspan=\"2\">";
            String string4 = this.entry.content;
            if (string4.length() > 0) {
                string3 = string3 + "<div>" + string4 + "</div>";
            }
            string3 = string3 + "</td></tr>";
            string3 = string3 + "</table>";
            string3 = string3 + "</div></html>";
            return XHTMLViewer.parseDocument((String)string3);
        }

        protected void finished() {
            super.finished();
            NewsEntryTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Document document) {
            super.succeeded((Object)document);
            if (document == null) {
                return;
            }
            NewsEntryTablePanel.this.viewer.setDocument(document);
            if (!NewsEntryTablePanel.this.mainSplitter.getBottomComponent().isVisible()) {
                NewsEntryTablePanel.this.mainSplitter.getBottomComponent().setVisible(true);
                if (NewsEntryTablePanel.this.mainSplitterLocation > 0) {
                    NewsEntryTablePanel.this.mainSplitter.setDividerLocation(NewsEntryTablePanel.this.mainSplitterLocation);
                } else {
                    NewsEntryTablePanel.this.mainSplitter.setDividerLocation(0.5);
                }
            }
            NewsEntryTablePanel.this.mainSplitterLocation = NewsEntryTablePanel.this.mainSplitter.getDividerLocation();
        }
    }

    private class EntryOpenLinkAction
    extends AbstractI18nAction {
        private EntryOpenLinkAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"web.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NewsEntryTablePanel.this.doEntryOpenLink();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("open website")));
            this.setShortDescription(I18N.tr("Open news message in the web browser."));
        }
    }

    private class Table
    extends NewsEntryTable<NewsEntryTable.Row> {
        public Table() {
            super(NewsEntryTablePanel.TABLE_ID);
        }

        protected void doSelect() {
            int n = this.getSelectedRow();
            NewsEntryTablePanel.this.doEntryView(n > -1 ? this.getEntryAt(this.convertRowIndexToModel(n)) : null);
        }
    }
}

