-- -----------------------------------------------------
-- News-Addon for OpenEstate-ImmoTool
-- update 4 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Add field 'feed_auth_method' to 'immotool_news_feeds'
-- Rebuild 'view_immotool_news_feeds'
-- Rebuild 'save_immotool_news_feeds'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Add field 'feed_auth_method' to 'immotool_news_feeds'
-- -----------------------------------------------------
ALTER TABLE immotool_news_feeds
  ADD COLUMN feed_auth_method VARCHAR(50) DEFAULT NULL NULL
  BEFORE feed_auth_user;
UPDATE immotool_news_feeds
  SET feed_auth_method = 'ANONYMOUS'
  WHERE feed_auth_method IS NULL;

-- -----------------------------------------------------
-- Rebuild 'view_immotool_news_feeds'
-- -----------------------------------------------------
ALTER VIEW view_immotool_news_feeds AS
  SELECT * FROM immotool_news_feeds
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(access_permissions, 64) = 64)
    OR
    (BITAND(access_permissions, 8) = 8 AND access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(access_permissions, 1) = 1 AND access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );

-- -----------------------------------------------------
-- Rebuild 'save_immotool_news_feeds'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_immotool_news_feeds;
\.
CREATE PROCEDURE save_immotool_news_feeds(
    INOUT val_feed_id BIGINT,
    val_feed_name VARCHAR(100),
    val_feed_url VARCHAR(255),
    val_feed_auth_method VARCHAR(50),
    val_feed_auth_user VARCHAR(100),
    val_feed_auth_pass VARCHAR(255),
    val_feed_notes LONGVARCHAR,
    val_feed_archived BOOLEAN,
    val_feed_update_enabled BOOLEAN,
    val_feed_update_interval BIGINT,
    val_feed_downloaded_at TIMESTAMP WITH TIME ZONE,
    val_feed_published_at TIMESTAMP WITH TIME ZONE,
    val_access_owner_id BIGINT,
    val_access_group_id BIGINT,
    val_access_permissions INT
  )
  SPECIFIC save_immotool_news_feeds
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neuen Feed erzeugen
    IF val_feed_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Feed speichern
      INSERT INTO immotool_news_feeds (
        feed_name,
        feed_url,
        feed_auth_method,
        feed_auth_user,
        feed_auth_pass,
        feed_notes,
        feed_archived,
        feed_update_enabled,
        feed_update_interval,
        feed_downloaded_at,
        feed_published_at,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_feed_name,
        val_feed_url,
        val_feed_auth_method,
        val_feed_auth_user,
        val_feed_auth_pass,
        val_feed_notes,
        val_feed_archived,
        val_feed_update_enabled,
        val_feed_update_interval,
        val_feed_downloaded_at,
        val_feed_published_at,
        owner_uid,
        owner_gid,
        permissions);

      -- ID zurückliefern
      SET val_feed_id = IDENTITY();

    -- Bestehenden Feed bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_news_feeds
        WHERE feed_id = val_feed_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>1 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>1 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>1 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Feed bearbeiten
      UPDATE immotool_news_feeds
        SET
          feed_name = val_feed_name,
          feed_url = val_feed_url,
          feed_auth_method = val_feed_auth_method,
          feed_auth_user = val_feed_auth_user,
          feed_auth_pass = val_feed_auth_pass,
          feed_notes = val_feed_notes,
          feed_archived = val_feed_archived,
          feed_update_enabled = val_feed_update_enabled,
          feed_update_interval = val_feed_update_interval,
          feed_downloaded_at = val_feed_downloaded_at,
          feed_published_at = val_feed_published_at,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          feed_id = val_feed_id;

    END IF;

  END;
.;
GRANT EXECUTE
  ON PROCEDURE save_immotool_news_feeds
  TO "IMMOTOOL";