-- -----------------------------------------------------
-- News-Addon for OpenEstate-ImmoTool
-- update 2 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Add field 'entry_link' to table 'immotool_news_entries'
-- Rename field 'entry_url' to 'entry_uri' in table 'immotool_news_entries'
-- -----------------------------------------------------

DROP PROCEDURE IF EXISTS save_immotool_news_entries RESTRICT;
DROP VIEW IF EXISTS view_immotool_news_entries RESTRICT;

ALTER TABLE immotool_news_entries
  ALTER COLUMN entry_url RENAME TO entry_uri;

ALTER TABLE immotool_news_entries
  ADD COLUMN entry_link VARCHAR(255) DEFAULT NULL NULL
  BEFORE entry_time;

CREATE VIEW view_immotool_news_entries AS
  SELECT * FROM immotool_news_entries
  WHERE feed_id IN (SELECT feed_id FROM view_immotool_news_feeds);

\.
CREATE PROCEDURE save_immotool_news_entries(
  INOUT val_entry_id BIGINT,
  val_feed_id BIGINT,
  val_entry_uri VARCHAR(255),
  val_entry_title VARCHAR(255),
  val_entry_author VARCHAR(255),
  val_entry_content LONGVARCHAR,
  val_entry_link VARCHAR(255),
  val_entry_time TIMESTAMP WITH TIME ZONE,
  val_entry_new BOOLEAN,
  val_entry_sticky BOOLEAN )
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_feed_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    IF NOT allowed = TRUE AND val_feed_id IS NOT NULL AND val_feed_id > 0 THEN
      SET allowed = can_write_immotool_news_feeds( val_feed_id );
    END IF;
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neuen Eintrag erzeugen
    IF val_entry_id < 1 THEN
      -- Eintrag speichern
      INSERT INTO immotool_news_entries (
        feed_id,
        entry_uri,
        entry_title,
        entry_author,
        entry_content,
        entry_link,
        entry_time,
        entry_new,
        entry_sticky )
      VALUES (
        val_feed_id,
        val_entry_uri,
        val_entry_title,
        val_entry_author,
        val_entry_content,
        val_entry_link,
        val_entry_time,
        val_entry_new,
        val_entry_sticky );

      -- ID zurückliefern
      SET val_entry_id = IDENTITY();

    -- Bestehenden Eintrag bearbeiten
    ELSE
      -- Eintrag bearbeiten
      UPDATE immotool_news_entries
        SET
          feed_id = val_feed_id,
          entry_uri = val_entry_uri,
          entry_title = val_entry_title,
          entry_author = val_entry_author,
          entry_content = val_entry_content,
          entry_link = val_entry_link,
          entry_time = val_entry_time,
          entry_new = val_entry_new,
          entry_sticky = val_entry_sticky,
          modified_at = NOW()
        WHERE
          entry_id = val_entry_id;

    END IF;

  END;
.;

GRANT SELECT
  ON view_immotool_news_entries
  TO "IMMOTOOL";

GRANT EXECUTE
  ON PROCEDURE save_immotool_news_entries
  TO "IMMOTOOL";
