/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.CustomValuesImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressImpl
extends AbstractImplItem
implements SerializableXmlElement {
    private static final long serialVersionUID = 7705499966390210549L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AddressImpl.class);
    public static final String XML_ATTRIB_STREET = "Street";
    public static final String XML_ATTRIB_STREET_2 = "Street2";
    public static final String XML_ATTRIB_STREET_NR = "StreetNr";
    public static final String XML_ATTRIB_POSTAL_CODE = "PostalCode";
    public static final String XML_ATTRIB_CITY = "City";
    public static final String XML_ATTRIB_DISTRICT = "District";
    public static final String XML_ATTRIB_COUNTRY = "Country";
    public static final String XML_ATTRIB_REGION = "Region";
    public static final String XML_ATTRIB_LATITUDE = "Latitude";
    public static final String XML_ATTRIB_LONGITUDE = "Longitude";
    private static final String OLD_XML_ATTRIB_CITY_PART = "CityPart";
    public static final String ADDRESS_XML_ELEMENT = "Address";
    private static final String XML_ELEMENT_VALUES = "CustomValues";
    private static final String OLD_SIMPLEADRESS_XML_ELEMENT = "SimpleAdress";
    private CustomValuesImpl customValues = new CustomValuesImpl();

    public String getCity() {
        return (String)this.getValue(XML_ATTRIB_CITY);
    }

    @Deprecated
    public String getCityPart() {
        return this.getDistrict();
    }

    public String getCountry() {
        return (String)this.getValue(XML_ATTRIB_COUNTRY);
    }

    public CustomValuesImpl getCustomValues() {
        return this.customValues;
    }

    public String getDistrict() {
        return (String)this.getValue(XML_ATTRIB_DISTRICT);
    }

    public BigDecimal getLatitude() {
        return (BigDecimal)this.getValue(XML_ATTRIB_LATITUDE);
    }

    public BigDecimal getLongitude() {
        return (BigDecimal)this.getValue(XML_ATTRIB_LONGITUDE);
    }

    public String getPostalCode() {
        return (String)this.getValue(XML_ATTRIB_POSTAL_CODE);
    }

    public String getRegion() {
        return (String)this.getValue(XML_ATTRIB_REGION);
    }

    public String getStreet() {
        return (String)this.getValue(XML_ATTRIB_STREET);
    }

    public String getStreet2() {
        return (String)this.getValue(XML_ATTRIB_STREET_2);
    }

    public String getStreetNr() {
        return (String)this.getValue(XML_ATTRIB_STREET_NR);
    }

    public static boolean isAddressRootElement(Element element) {
        if (element == null) {
            return false;
        }
        String string = element.getName();
        return ADDRESS_XML_ELEMENT.equals(string) || OLD_SIMPLEADRESS_XML_ELEMENT.equals(string);
    }

    @Override
    public void merge(AbstractImplItem abstractImplItem) {
        super.merge(abstractImplItem);
        if (abstractImplItem instanceof AddressImpl) {
            this.customValues.merge(((AddressImpl)abstractImplItem).getCustomValues());
        }
    }

    public static AddressImpl parseAddress(Document document) throws DocumentException {
        AddressImpl addressImpl = new AddressImpl();
        addressImpl.readFromXml(document);
        return addressImpl;
    }

    public void readFromMap(Map<String, String> map, String string) {
        String string2 = string != null && string.length() > 0 ? string + "address." : "address.";
        this.setCity(map.get(string2 + "city"));
        this.setCountry(map.get(string2 + "country"));
        this.setDistrict(map.get(string2 + "district"));
        this.setPostalCode(map.get(string2 + "postalcode"));
        this.setRegion(map.get(string2 + "region"));
        this.setStreet(map.get(string2 + "street"));
        this.setStreet2(map.get(string2 + "street2"));
        this.setStreetNr(map.get(string2 + "streetNr"));
        if (map.containsKey(string2 + "latitude") && map.containsKey(string2 + "longitude")) {
            try {
                this.setLatitude(new BigDecimal(map.get(string2 + "latitude")));
                this.setLongitude(new BigDecimal(map.get(string2 + "longitude")));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read geo coordinates!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.setLatitude(null);
                this.setLongitude(null);
            }
        }
        this.getCustomValues().readFromMap(map, string2);
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        Element element = (Element)document.selectSingleNode(ADDRESS_XML_ELEMENT);
        if (element == null) {
            element = (Element)document.selectSingleNode(OLD_SIMPLEADRESS_XML_ELEMENT);
        }
        this.readFromXml(element);
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        this.setStreet(AddressImpl.selectAttribute(element, XML_ATTRIB_STREET));
        this.setStreet2(AddressImpl.selectAttribute(element, XML_ATTRIB_STREET_2));
        this.setStreetNr(AddressImpl.selectAttribute(element, XML_ATTRIB_STREET_NR));
        this.setPostalCode(AddressImpl.selectAttribute(element, XML_ATTRIB_POSTAL_CODE));
        this.setCity(AddressImpl.selectAttribute(element, XML_ATTRIB_CITY));
        this.setCountry(AddressImpl.selectAttribute(element, XML_ATTRIB_COUNTRY));
        this.setRegion(AddressImpl.selectAttribute(element, XML_ATTRIB_REGION));
        this.setLatitude(AddressImpl.selectAttributeAsBigDecimal(element, XML_ATTRIB_LATITUDE));
        this.setLongitude(AddressImpl.selectAttributeAsBigDecimal(element, XML_ATTRIB_LONGITUDE));
        String string = AddressImpl.selectAttribute(element, XML_ATTRIB_DISTRICT);
        if (string == null) {
            string = AddressImpl.selectAttribute(element, OLD_XML_ATTRIB_CITY_PART);
        }
        this.setDistrict(string);
        for (Node node : AddressImpl.selectChildElements(element)) {
            if (!XML_ELEMENT_VALUES.equals(node.getName())) continue;
            this.customValues.readFromXml((Element)node);
        }
    }

    public void serializeToMap(Map<String, String> map, String string) {
        String string2;
        String string3 = string2 = string != null && string.length() > 0 ? string + "address." : "address.";
        if (this.getStreet() != null) {
            map.put(string2 + "city", this.getCity());
        }
        if (this.getCountry() != null) {
            map.put(string2 + "country", this.getCountry());
        }
        if (this.getDistrict() != null) {
            map.put(string2 + "district", this.getDistrict());
        }
        if (this.getPostalCode() != null) {
            map.put(string2 + "postalcode", this.getPostalCode());
        }
        if (this.getRegion() != null) {
            map.put(string2 + "region", this.getRegion());
        }
        if (this.getStreet() != null) {
            map.put(string2 + "street", this.getStreet());
        }
        if (this.getStreet2() != null) {
            map.put(string2 + "street2", this.getStreet2());
        }
        if (this.getStreetNr() != null) {
            map.put(string2 + "streetNr", this.getStreetNr());
        }
        if (this.getLatitude() != null && this.getLongitude() != null) {
            map.put(string2 + "latitude", this.getLatitude().toString());
            map.put(string2 + "longitude", this.getLongitude().toString());
        }
        this.getCustomValues().serializeToMap(map, string2);
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(ADDRESS_XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.add(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        if (this.getStreet() != null) {
            element.addAttribute(XML_ATTRIB_STREET, this.getStreet());
        }
        if (this.getStreet2() != null) {
            element.addAttribute(XML_ATTRIB_STREET_2, this.getStreet2());
        }
        if (this.getStreetNr() != null) {
            element.addAttribute(XML_ATTRIB_STREET_NR, this.getStreetNr());
        }
        if (this.getPostalCode() != null) {
            element.addAttribute(XML_ATTRIB_POSTAL_CODE, this.getPostalCode());
        }
        if (this.getCity() != null) {
            element.addAttribute(XML_ATTRIB_CITY, this.getCity());
        }
        if (this.getDistrict() != null) {
            element.addAttribute(XML_ATTRIB_DISTRICT, this.getDistrict());
        }
        if (this.getCountry() != null) {
            element.addAttribute(XML_ATTRIB_COUNTRY, this.getCountry());
        }
        if (this.getRegion() != null) {
            element.addAttribute(XML_ATTRIB_REGION, this.getRegion());
        }
        if (this.getLatitude() != null) {
            element.addAttribute(XML_ATTRIB_LATITUDE, this.getLatitude().toString());
        }
        if (this.getLongitude() != null) {
            element.addAttribute(XML_ATTRIB_LONGITUDE, this.getLongitude().toString());
        }
        if (!this.customValues.getValueMap().isEmpty()) {
            this.customValues.serializeToXml(element.addElement(XML_ELEMENT_VALUES));
        }
    }

    public void setCity(String string) {
        this.putValue(XML_ATTRIB_CITY, string);
    }

    @Deprecated
    public void setCityPart(String string) {
        this.setDistrict(string);
    }

    public void setCountry(String string) {
        this.putValue(XML_ATTRIB_COUNTRY, string);
    }

    public void setCustomValues(CustomValuesImpl customValuesImpl) {
        this.customValues = customValuesImpl;
    }

    public void setDistrict(String string) {
        this.putValue(XML_ATTRIB_DISTRICT, string);
    }

    public void setLatitude(BigDecimal bigDecimal) {
        this.putValue(XML_ATTRIB_LATITUDE, bigDecimal);
    }

    public void setLongitude(BigDecimal bigDecimal) {
        this.putValue(XML_ATTRIB_LONGITUDE, bigDecimal);
    }

    public void setPostalCode(String string) {
        this.putValue(XML_ATTRIB_POSTAL_CODE, string);
    }

    public void setRegion(String string) {
        this.putValue(XML_ATTRIB_REGION, string);
    }

    public void setStreet(String string) {
        this.putValue(XML_ATTRIB_STREET, string);
    }

    public void setStreet2(String string) {
        this.putValue(XML_ATTRIB_STREET_2, string);
    }

    public void setStreetNr(String string) {
        this.putValue(XML_ATTRIB_STREET_NR, string);
    }

    public String writeCountry() {
        return this.writeCountry(Locale.getDefault());
    }

    public String writeCountry(Locale locale) {
        return this.getCountry() != null && this.getCountry().trim().length() > 0 ? AddressImpl.writeCountry(this.getCountry(), locale) : "";
    }

    public static String writeCountry(String string) {
        return AddressImpl.writeCountry(string, Locale.getDefault());
    }

    public static String writeCountry(String string, Locale locale) {
        if (string == null) {
            return "";
        }
        return new Locale(string.toLowerCase(), string.toUpperCase()).getDisplayCountry(locale);
    }

    public final String writeFullAddress() {
        return this.writeFullAddress(System.lineSeparator(), Locale.getDefault());
    }

    public final String writeFullAddress(Locale locale) {
        return this.writeFullAddress(System.lineSeparator(), locale);
    }

    public String writeFullAddress(String string) {
        return this.writeFullAddress(string, Locale.getDefault());
    }

    public String writeFullAddress(String string, Locale locale) {
        String string2 = this.writeStreet();
        String string3 = this.writePostal();
        String string4 = this.writeCountry(locale);
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null && string2.trim().length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2.trim());
        }
        if (string3 != null && string3.trim().length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string3.trim());
        }
        if (string4 != null && string4.trim().length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public final String writeFullAdress() {
        return this.writeFullAddress();
    }

    @Deprecated
    public final String writeFullAdress(Locale locale) {
        return this.writeFullAddress(locale);
    }

    @Deprecated
    public String writeFullAdress(String string) {
        return this.writeFullAddress(string);
    }

    @Deprecated
    public String writeFullAdress(String string, Locale locale) {
        return this.writeFullAddress(string, locale);
    }

    public String writePostal() {
        String string = this.getCountry();
        String string2 = this.getPostalCode();
        String string3 = this.getCity();
        String string4 = this.getDistrict();
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null && string2.trim().length() > 0 || string3 != null && string3.trim().length() > 0) {
            if (string2 != null) {
                if (string != null) {
                    stringBuilder.append(string.trim()).append('-');
                }
                stringBuilder.append(string2.trim());
            }
            if (string3 != null) {
                stringBuilder.append(' ').append(string3.trim());
            }
            if (string4 != null) {
                stringBuilder.append(' ').append(string4.trim());
            }
        }
        return stringBuilder.toString().trim();
    }

    public String writeStreet() {
        String string = this.getStreet();
        String string2 = this.getStreetNr();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.trim().length() > 0) {
            stringBuilder.append(this.getStreet());
            if (string2 != null) {
                stringBuilder.append(' ').append(string2.trim());
            }
        }
        return stringBuilder.toString().trim();
    }
}

