/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.PersonAddressImpl;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentContactImpl
extends PersonAddressImpl
implements SerializableXmlElement {
    private static final long serialVersionUID = -7165140159888537925L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentContactImpl.class);
    public static final String XML_ATTRIB_ID = "Id";
    public static final String XML_ATTRIB_CONTACT_WEBSITE = "ContactWebsite";
    public static final String AGENTCONTACT_XML_ELEMENT = "AgentContact";
    public static final String XML_ELEMENT_CONTACT_OFFICE_HOURS = "ContactOfficeHours";

    public AgentContactImpl() {
    }

    public AgentContactImpl(Document document) throws DocumentException {
        this();
        this.readFromXml(document);
    }

    public long calculateHash() {
        TreeSet<String> treeSet = new TreeSet<String>(this.getValues().keySet());
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : treeSet) {
            if (string.equals(XML_ATTRIB_ID)) continue;
            stringBuilder.append(string);
            if (this.getValue(string) == null) continue;
            stringBuilder.append(",").append(this.getValue(string).toString());
        }
        return stringBuilder.toString().hashCode();
    }

    public String getContactOfficeHours() {
        return (String)this.getValue(XML_ELEMENT_CONTACT_OFFICE_HOURS);
    }

    public URI getContactWebsite() {
        return (URI)this.getValue(XML_ATTRIB_CONTACT_WEBSITE);
    }

    public String getId() {
        return (String)this.getValue(XML_ATTRIB_ID);
    }

    @Override
    public void readFromMap(Map<String, String> map, String string) {
        super.readFromMap(map, string);
        String string2 = string != null && string.length() > 0 ? string + "contact." : "contact.";
        this.setId(map.get(string2 + "id"));
        this.setContactOfficeHours(map.get(string2 + "officeHours"));
        String string3 = StringUtils.trimToNull((String)map.get(string2 + "website"));
        if (string3 != null && StringUtils.isNotBlank((CharSequence)StringUtils.substringAfter((String)string3, (String)":"))) {
            try {
                this.setContactWebsite(new URI(string3));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't read contact website (" + string3 + ")!");
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                this.setContactWebsite(null);
            }
        }
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml((Element)document.selectSingleNode(AGENTCONTACT_XML_ELEMENT));
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        super.readFromXml(element);
        this.setId(AgentContactImpl.selectAttribute(element, XML_ATTRIB_ID, null));
        this.setContactWebsite(AgentContactImpl.selectAttributeAsURI(element, XML_ATTRIB_CONTACT_WEBSITE));
        for (Node node : AgentContactImpl.selectChildElements(element)) {
            if (!XML_ELEMENT_CONTACT_OFFICE_HOURS.equals(node.getName())) continue;
            this.setContactOfficeHours(node.getText());
        }
    }

    @Override
    public void serializeToMap(Map<String, String> map, String string) {
        String string2;
        super.serializeToMap(map, string);
        String string3 = string2 = string != null && string.length() > 0 ? string + "contact." : "contact.";
        if (this.getId() != null) {
            map.put(string2 + "id", this.getId());
        }
        if (!StringUtils.isBlank((CharSequence)this.getContactOfficeHours())) {
            map.put(string2 + "officeHours", StringUtils.trimToEmpty((String)this.getContactOfficeHours()));
        }
        if (this.getContactWebsite() != null) {
            map.put(string2 + "website", this.getContactWebsite().toString());
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(AGENTCONTACT_XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.add(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        element.addAttribute(XML_ATTRIB_ID, this.getId());
        if (this.getContactWebsite() != null) {
            element.addAttribute(XML_ATTRIB_CONTACT_WEBSITE, this.getContactWebsite().toString());
        }
        if (!StringUtils.isBlank((CharSequence)this.getContactOfficeHours())) {
            Element element2 = element.addElement(XML_ELEMENT_CONTACT_OFFICE_HOURS);
            element2.setText(StringUtils.trimToNull((String)this.getContactOfficeHours()));
        }
        super.serializeToXml(element);
    }

    public void setContactOfficeHours(String string) {
        this.putValue(XML_ELEMENT_CONTACT_OFFICE_HOURS, StringUtils.trimToNull((String)string));
    }

    public void setContactWebsite(URI uRI) {
        this.putValue(XML_ATTRIB_CONTACT_WEBSITE, uRI);
    }

    public void setId(String string) {
        this.putValue(XML_ATTRIB_ID, StringUtils.trimToNull((String)string));
    }
}

