/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.CustomValueImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomValuesImpl
extends AbstractImplItem
implements SerializableXmlElement {
    private static final long serialVersionUID = -1351509821354188675L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomValuesImpl.class);
    public static final String XML_ELEMENT = "CustomValues";
    public static final String XML_ELEMENT_VALUE = "CustomValue";
    private final Map<String, CustomValueImpl> customValues = new TreeMap<String, CustomValueImpl>();

    public CustomValueImpl getCustomValue(String string) {
        return this.hasCustomValue(string) ? this.customValues.get(string) : null;
    }

    public Map<String, CustomValueImpl> getValueMap() {
        return this.customValues;
    }

    public boolean hasCustomValue(String string) {
        return this.customValues.containsKey(string);
    }

    @Override
    public void merge(AbstractImplItem abstractImplItem) {
        if (abstractImplItem instanceof CustomValuesImpl) {
            this.getValueMap().putAll(((CustomValuesImpl)abstractImplItem).getValueMap());
        } else {
            super.merge(abstractImplItem);
        }
    }

    public void putCustomValue(String string, Object object, int n) {
        if (this.hasCustomValue(string)) {
            if (object == null) {
                this.getValueMap().remove(string);
            } else {
                this.getValueMap().get(string).setObject(object, n);
            }
        } else if (object != null) {
            this.getValueMap().put(string, new CustomValueImpl(string, object, n));
        }
    }

    public void readFromMap(Map<String, String> map, String string) {
        String string2 = string != null && string.length() > 0 ? string + "custom." : "custom.";
        String string3 = string2 + "boolean.";
        String string4 = string2 + "date.";
        String string5 = string2 + "datetime.";
        String string6 = string2 + "decimal.";
        String string7 = string2 + "integer.";
        String string8 = string2 + "string.";
        String string9 = string2 + "text.";
        String string10 = string2 + "time.";
        String string11 = string2 + "url.";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string12 = entry.getKey();
            try {
                String string13;
                if (string12.startsWith(string3)) {
                    this.putCustomValue(string12.substring(string3.length()), Boolean.valueOf(entry.getValue()), 0);
                    continue;
                }
                if (string12.startsWith(string4)) {
                    this.putCustomValue(string12.substring(string4.length()), OpenEstateUtils.getXsdDateFormat().parse(entry.getValue()), 1);
                    continue;
                }
                if (string12.startsWith(string5)) {
                    this.putCustomValue(string12.substring(string5.length()), OpenEstateUtils.getXsdDateTimeFormat().parse(entry.getValue()), 2);
                    continue;
                }
                if (string12.startsWith(string6)) {
                    this.putCustomValue(string12.substring(string6.length()), new BigDecimal(entry.getValue()), 3);
                    continue;
                }
                if (string12.startsWith(string7)) {
                    this.putCustomValue(string12.substring(string7.length()), BigInteger.valueOf(Long.parseLong(entry.getValue())), 4);
                    continue;
                }
                if (string12.startsWith(string8)) {
                    this.putCustomValue(string12.substring(string8.length()), entry.getValue(), 5);
                    continue;
                }
                if (string12.startsWith(string9)) {
                    this.putCustomValue(string12.substring(string9.length()), entry.getValue(), 6);
                    continue;
                }
                if (string12.startsWith(string10)) {
                    this.putCustomValue(string12.substring(string10.length()), OpenEstateUtils.getXsdTimeFormat().parse(entry.getValue()), 7);
                    continue;
                }
                if (!string12.startsWith(string11) || (string13 = StringUtils.trimToNull((String)entry.getValue())) == null) continue;
                this.putCustomValue(string12.substring(string11.length()), new URI(string13), 8);
            }
            catch (Throwable throwable) {
                LOGGER.warn("Can't read custom value!");
                LOGGER.warn("> " + string12);
                LOGGER.warn("> " + throwable.getLocalizedMessage(), throwable);
            }
        }
    }

    @Override
    public void readFromXml(Document document) throws DocumentException {
        this.readFromXml(document.getRootElement());
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        this.customValues.clear();
        for (Node node : CustomValuesImpl.selectChildElements(element)) {
            if (!XML_ELEMENT_VALUE.equals(node.getName())) continue;
            CustomValueImpl customValueImpl = new CustomValueImpl();
            customValueImpl.readFromXml((Element)node);
            this.customValues.put(customValueImpl.getObjectKey(), customValueImpl);
        }
    }

    public void serializeToMap(Map<String, String> map, String string) {
        String string2 = string != null && string.length() > 0 ? string + "custom." : "custom.";
        String string3 = string2 + "boolean.";
        String string4 = string2 + "date.";
        String string5 = string2 + "datetime.";
        String string6 = string2 + "decimal.";
        String string7 = string2 + "integer.";
        String string8 = string2 + "string.";
        String string9 = string2 + "text.";
        String string10 = string2 + "time.";
        String string11 = string2 + "url.";
        for (CustomValueImpl customValueImpl : this.customValues.values()) {
            if (customValueImpl.getObject() == null) continue;
            if (customValueImpl.isBoolean()) {
                map.put(string3 + customValueImpl.getObjectKey(), customValueImpl.getBoolean().toString());
                continue;
            }
            if (customValueImpl.isDate()) {
                map.put(string4 + customValueImpl.getObjectKey(), OpenEstateUtils.getXsdDateFormat().format(customValueImpl.getDate()));
                continue;
            }
            if (customValueImpl.isDateTime()) {
                map.put(string5 + customValueImpl.getObjectKey(), OpenEstateUtils.getXsdDateTimeFormat().format(customValueImpl.getDateTime()));
                continue;
            }
            if (customValueImpl.isDecimal()) {
                map.put(string6 + customValueImpl.getObjectKey(), customValueImpl.getDecimal().toString());
                continue;
            }
            if (customValueImpl.isInteger()) {
                map.put(string7 + customValueImpl.getObjectKey(), customValueImpl.getInteger().toString());
                continue;
            }
            if (customValueImpl.isString()) {
                map.put(string8 + customValueImpl.getObjectKey(), customValueImpl.getString().trim());
                continue;
            }
            if (customValueImpl.isText()) {
                map.put(string9 + customValueImpl.getObjectKey(), customValueImpl.getText().trim());
                continue;
            }
            if (customValueImpl.isTime()) {
                map.put(string10 + customValueImpl.getObjectKey(), OpenEstateUtils.getXsdTimeFormat().format(customValueImpl.getTime()));
                continue;
            }
            if (!customValueImpl.isUrl()) continue;
            map.put(string11 + customValueImpl.getObjectKey(), customValueImpl.getUrl().toString());
        }
    }

    @Override
    public void serializeToXml(Document document) throws DocumentException {
        Element element = DocumentFactory.getInstance().createElement(XML_ELEMENT, "http://www.openestate.org/1.0/");
        this.serializeToXml(element);
        document.setRootElement(element);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (element == null) {
            return;
        }
        for (CustomValueImpl customValueImpl : this.customValues.values()) {
            if (customValueImpl.getObject() == null) continue;
            customValueImpl.serializeToXml(element.addElement(XML_ELEMENT_VALUE));
        }
    }
}

