/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl;

import com.openindex.openestate.impl.AbstractImplItem;
import com.openindex.openestate.impl.SerializableXmlType;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import com.openindex.openestate.impl.values.VolumeValue;
import java.math.BigDecimal;
import java.util.Currency;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNumericImpl
extends AbstractImplItem
implements SerializableXmlType {
    private static final long serialVersionUID = 290722559438969005L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchNumericImpl.class);
    private static final String XML_ATTRIB_MAX = "Max";
    private static final String XML_ATTRIB_MIN = "Min";
    private static final String XML_ATTRIB_AREA_UNIT = "AreaUnit";
    private static final String XML_ATTRIB_CURRENCY_UNIT = "CurrencyUnit";
    private static final String XML_ATTRIB_LENGTH_UNIT = "LengthUnit";
    private static final String XML_ATTRIB_VOLUME_UNIT = "VolumeUnit";
    private static final String XML_ATTRIB_ENERGY_CONSUMPTION_UNIT = "EnergyConsumptionUnit";
    private BigDecimal min = null;
    private BigDecimal max = null;
    private AreaValue.Unit areaUnit = null;
    private Currency currencyUnit = null;
    private LengthValue.Unit lengthUnit = null;
    private VolumeValue.Unit volumeUnit = null;
    private EnergyConsumptionValue.Unit energyConsumptionUnit = null;
    private long order = 0L;

    public AreaValue.Unit getAreaUnit() {
        return this.areaUnit;
    }

    public Currency getCurrencyUnit() {
        return this.currencyUnit;
    }

    public LengthValue.Unit getLengthUnit() {
        return this.lengthUnit;
    }

    public EnergyConsumptionValue.Unit getEnergyConsumptionUnit() {
        return this.energyConsumptionUnit;
    }

    public BigDecimal getMax() {
        return this.max;
    }

    public BigDecimal getMin() {
        return this.min;
    }

    public long getOrder() {
        return this.order;
    }

    public VolumeValue.Unit getVolumeUnit() {
        return this.volumeUnit;
    }

    public boolean isMatching(AreaValue areaValue) {
        Number number = this.areaUnit != null ? AreaValue.convert(areaValue, this.areaUnit) : Double.valueOf(areaValue.doubleValue());
        return this.isMatching(number);
    }

    public boolean isMatching(EnergyConsumptionValue energyConsumptionValue) {
        Number number = this.lengthUnit != null ? EnergyConsumptionValue.convert(energyConsumptionValue, this.energyConsumptionUnit) : Double.valueOf(energyConsumptionValue.doubleValue());
        return this.isMatching(number);
    }

    public boolean isMatching(LengthValue lengthValue) {
        Number number = this.lengthUnit != null ? LengthValue.convert(lengthValue, this.lengthUnit) : Double.valueOf(lengthValue.doubleValue());
        return this.isMatching(number);
    }

    public boolean isMatching(VolumeValue volumeValue) {
        Number number = this.volumeUnit != null ? VolumeValue.convert(volumeValue, this.volumeUnit) : Double.valueOf(volumeValue.doubleValue());
        return this.isMatching(number);
    }

    public boolean isMatching(Number number) {
        if (this.min == null && this.max == null) {
            return true;
        }
        BigDecimal bigDecimal = new BigDecimal(number.doubleValue());
        if (this.min != null && this.min.compareTo(bigDecimal) > 0) {
            return false;
        }
        return this.max == null || this.max.compareTo(bigDecimal) >= 0;
    }

    @Override
    public void readFromXml(Element element) throws DocumentException {
        this.setMax(SearchNumericImpl.selectAttributeAsBigDecimal(element, XML_ATTRIB_MAX, null));
        this.setMin(SearchNumericImpl.selectAttributeAsBigDecimal(element, XML_ATTRIB_MIN, null));
        String string = SearchNumericImpl.selectAttribute(element, XML_ATTRIB_AREA_UNIT, null);
        this.setAreaUnit(string != null ? AreaValue.Unit.valueOf(string) : null);
        string = SearchNumericImpl.selectAttribute(element, XML_ATTRIB_CURRENCY_UNIT, null);
        this.setCurrencyUnit(string != null ? Currency.getInstance(string) : null);
        string = SearchNumericImpl.selectAttribute(element, XML_ATTRIB_LENGTH_UNIT, null);
        this.setLengthUnit(string != null ? LengthValue.Unit.valueOf(string) : null);
        string = SearchNumericImpl.selectAttribute(element, XML_ATTRIB_VOLUME_UNIT, null);
        this.setVolumeUnit(string != null ? VolumeValue.Unit.valueOf(string) : null);
        string = SearchNumericImpl.selectAttribute(element, XML_ATTRIB_ENERGY_CONSUMPTION_UNIT, null);
        this.setEnergyConsumptionUnit(string != null ? EnergyConsumptionValue.Unit.valueOf(string) : null);
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        if (this.max != null) {
            element.addAttribute(XML_ATTRIB_MAX, this.max.toString());
        }
        if (this.min != null) {
            element.addAttribute(XML_ATTRIB_MIN, this.min.toString());
        }
        if (this.areaUnit != null) {
            element.addAttribute(XML_ATTRIB_AREA_UNIT, this.areaUnit.name());
        }
        if (this.currencyUnit != null) {
            element.addAttribute(XML_ATTRIB_CURRENCY_UNIT, this.currencyUnit.getCurrencyCode());
        }
        if (this.lengthUnit != null) {
            element.addAttribute(XML_ATTRIB_LENGTH_UNIT, this.lengthUnit.name());
        }
        if (this.volumeUnit != null) {
            element.addAttribute(XML_ATTRIB_VOLUME_UNIT, this.volumeUnit.name());
        }
        if (this.energyConsumptionUnit != null) {
            element.addAttribute(XML_ATTRIB_ENERGY_CONSUMPTION_UNIT, this.energyConsumptionUnit.name());
        }
    }

    public void setAreaUnit(AreaValue.Unit unit) {
        this.areaUnit = unit;
    }

    public void setCurrencyUnit(Currency currency) {
        this.currencyUnit = currency;
    }

    public void setEnergyConsumptionUnit(EnergyConsumptionValue.Unit unit) {
        this.energyConsumptionUnit = unit;
    }

    public void setLengthUnit(LengthValue.Unit unit) {
        this.lengthUnit = unit;
    }

    public void setMax(BigDecimal bigDecimal) {
        this.max = bigDecimal;
    }

    public void setMin(BigDecimal bigDecimal) {
        this.min = bigDecimal;
    }

    public void setOrder(long l) {
        this.order = l;
    }

    public void setVolumeUnit(VolumeValue.Unit unit) {
        this.volumeUnit = unit;
    }

    public void unsetUnits() {
        this.areaUnit = null;
        this.currencyUnit = null;
        this.lengthUnit = null;
        this.volumeUnit = null;
    }
}

