/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleAttrib<ObjectType>
extends AbstractAttribImpl<ObjectType> {
    private static final long serialVersionUID = -1083754072430722028L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleAttrib.class);

    protected SimpleAttrib(OpenEstateAttrib openEstateAttrib, String[] stringArray) {
        super(openEstateAttrib, stringArray);
    }

    public abstract ObjectType parseValue(String var1);

    @Override
    public void readFromXml(Element element) throws DocumentException {
        if (element == null) {
            LOGGER.warn("The XML node is empty for " + this.getAttrib() + "!");
            return;
        }
        if (element.isTextOnly()) {
            this.setValue(this.parseValue(StringEscapeUtils.unescapeHtml4((String)element.getStringValue())));
            return;
        }
        LOGGER.warn("The XML node is not text-only for " + this.getAttrib() + "! Trying to parse node as string attribute.");
        ComplexStringAttrib complexStringAttrib = new ComplexStringAttrib(this.getAttrib(), 0, null){
            private static final long serialVersionUID = -6104413494628799049L;
        };
        Object object = complexStringAttrib.parseNode(element);
        String string = object.containsKey("de") ? StringUtils.trimToNull((String)((String)object.get("de"))) : null;
        String string2 = string = string == null && object.containsKey("en") ? StringUtils.trimToNull((String)((String)object.get("en"))) : null;
        if (string == null) {
            String string3;
            Iterator iterator = object.values().iterator();
            while (iterator.hasNext() && (string = StringUtils.trimToNull((String)(string3 = (String)iterator.next()))) == null) {
            }
        }
        if (string != null) {
            this.setValue(this.parseValue(string));
        }
    }

    @Override
    public void serializeToXml(Element element) throws DocumentException {
        String string = this.writeValue(this.getValue());
        if (StringUtils.isBlank((CharSequence)string)) {
            element.setText(null);
        } else {
            element.setText(OpenEstateUtils.serializeString(StringEscapeUtils.unescapeHtml4((String)string)));
        }
    }

    protected abstract String writeValue(ObjectType var1);
}

