/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.features;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.utils.Translatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;

public final class Bathroom
extends ComplexEnumAttrib<Option> {
    public Bathroom() {
        super(OpenEstateAttrib.FEATURES_BATHROOM, null);
    }

    public Bathroom(Option option) {
        Option[] optionArray;
        if (option != null) {
            Option[] optionArray2 = new Option[1];
            optionArray = optionArray2;
            optionArray2[0] = option;
        } else {
            optionArray = null;
        }
        this(optionArray);
    }

    public Bathroom(Option[] optionArray) {
        this();
        if (optionArray != null) {
            ((AbstractAttribImpl)this).setValue(optionArray);
        }
    }

    public static Option[] get(EstateImpl estateImpl) {
        return (Option[])Bathroom.get(estateImpl, OpenEstateAttrib.FEATURES_BATHROOM);
    }

    public static List<Option> getAsList(EstateImpl estateImpl) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Option[] optionArray = Bathroom.get(estateImpl);
        if (optionArray != null) {
            arrayList.addAll(Arrays.asList(optionArray));
        }
        return arrayList;
    }

    public static String getAsString(EstateImpl estateImpl, String string) {
        return Bathroom.getAsString(estateImpl, OpenEstateAttrib.FEATURES_BATHROOM, string);
    }

    public static String getAsString(EstateImpl estateImpl, String string, Locale locale) {
        return Bathroom.getAsString(estateImpl, OpenEstateAttrib.FEATURES_BATHROOM, string, locale);
    }

    @Override
    public Option getOption(String string) {
        try {
            return Option.valueOf(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Option[] getOptions() {
        return Option.values();
    }

    public Option[] getOptionsArray(Collection<Option> collection) {
        return collection != null && !collection.isEmpty() ? collection.toArray(new Option[collection.size()]) : new Option[]{};
    }

    public static boolean hasOption(EstateImpl estateImpl, Option option) {
        return Bathroom.hasOption(estateImpl, OpenEstateAttrib.FEATURES_BATHROOM, option);
    }

    public static void put(EstateImpl estateImpl, Option[] optionArray) {
        Bathroom.put(estateImpl, OpenEstateAttrib.FEATURES_BATHROOM, optionArray);
    }

    public static void put(EstateImpl estateImpl, String[] stringArray) {
        Bathroom.put(estateImpl, OpenEstateAttrib.FEATURES_BATHROOM, stringArray);
    }

    public static void putOption(EstateImpl estateImpl, Option option) {
        Bathroom.putOption(estateImpl, OpenEstateAttrib.FEATURES_BATHROOM, option);
    }

    public static void putOption(EstateImpl estateImpl, String string) {
        Bathroom.putOption(estateImpl, OpenEstateAttrib.FEATURES_BATHROOM, string);
    }

    public static void removeOption(EstateImpl estateImpl, Option option) {
        Bathroom.removeOption(estateImpl, OpenEstateAttrib.FEATURES_BATHROOM, option);
    }

    public static void removeOption(EstateImpl estateImpl, String string) {
        Bathroom.removeOption(estateImpl, OpenEstateAttrib.FEATURES_BATHROOM, string);
    }

    public static enum Option implements Translatable
    {
        SHOWER(I18n.marktr((String)"with shower")),
        BATHTUB(I18n.marktr((String)"with bathtub")),
        WINDOW(I18n.marktr((String)"with window")),
        WASHING_MACHINE(I18n.marktr((String)"with washing machine")),
        WASHING_MACHINE_CONNECTION(I18n.marktr((String)"with washing machine connection")),
        BIDET(I18n.marktr((String)"with bidet")),
        URINAL(I18n.marktr((String)"with urinal"));

        private final String i18nKey;

        private Option(String string2) {
            this.i18nKey = string2;
        }

        @Override
        public String getTranslation() {
            return this.getTranslation(null);
        }

        @Override
        public String getTranslation(Locale locale) {
            return OpenEstateUtils.getI18nString(this.i18nKey, locale);
        }
    }
}

