/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.prices;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.values.CurrencyValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Locale;

public final class ServiceCharges
extends ComplexCurrencyAttrib {
    public ServiceCharges() {
        super(OpenEstateAttrib.PRICES_SERVICE_CHARGES, null);
    }

    public ServiceCharges(CurrencyValue currencyValue) {
        this();
        this.setValue(currencyValue);
    }

    public ServiceCharges(Number number, Currency currency) {
        this();
        if (number != null) {
            this.setValue(CurrencyValue.parse(number, currency));
        }
    }

    public static CurrencyValue get(EstateImpl estateImpl) {
        return ServiceCharges.get(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES);
    }

    public static BigDecimal getAsBigDecimal(EstateImpl estateImpl) {
        return ServiceCharges.getAsBigDecimal(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES);
    }

    public static BigInteger getAsBigInteger(EstateImpl estateImpl) {
        return ServiceCharges.getAsBigInteger(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES);
    }

    public static Double getAsDouble(EstateImpl estateImpl) {
        return ServiceCharges.getAsDouble(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES);
    }

    public static Float getAsFloat(EstateImpl estateImpl) {
        return ServiceCharges.getAsFloat(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES);
    }

    public static Integer getAsInteger(EstateImpl estateImpl) {
        return ServiceCharges.getAsInteger(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES);
    }

    public static Long getAsLong(EstateImpl estateImpl) {
        return ServiceCharges.getAsLong(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES);
    }

    public static String getAsString(EstateImpl estateImpl) {
        return ServiceCharges.getAsString(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES);
    }

    public static String getAsString(EstateImpl estateImpl, Locale locale) {
        return ServiceCharges.getAsString(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES, locale);
    }

    public static void put(EstateImpl estateImpl, String string) {
        ServiceCharges.put(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES, string);
    }

    public static void put(EstateImpl estateImpl, Number number) {
        ServiceCharges.put(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES, number);
    }

    public static void put(EstateImpl estateImpl, CurrencyValue currencyValue) {
        ServiceCharges.put(estateImpl, OpenEstateAttrib.PRICES_SERVICE_CHARGES, currencyValue);
    }
}

