/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db;

import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoAreaLevel;
import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.impl.GeoImpl;
import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoArea;
import com.openindex.openestate.impl.db.DbGeoCountry;
import com.openindex.openestate.impl.db.DbGeoHandler;
import com.openindex.openestate.impl.db.DbHandlerImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbGeoHandlerImpl
extends DbHandlerImpl
implements DbGeoHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbGeoHandlerImpl.class);

    protected DbGeoHandlerImpl() {
        super(null);
    }

    protected DbGeoHandlerImpl(String string) {
        super(string);
    }

    @Override
    public final DbGeoArea getGeoArea(Connection connection, long l) throws SQLException {
        DbGeoArea[] dbGeoAreaArray = this.getGeoAreas(connection, new long[]{l});
        return dbGeoAreaArray != null && dbGeoAreaArray.length > 0 ? dbGeoAreaArray[0] : null;
    }

    @Override
    public abstract DbGeoArea[] getGeoAreas(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbGeoArea[] getGeoAreas(Connection var1, long var2) throws SQLException;

    @Override
    public abstract DbGeoArea[] getGeoAreas(Connection var1, long var2, GeoAreaLevel var4) throws SQLException;

    @Override
    public abstract DbGeoArea[] getGeoAreas(Connection var1, long var2, boolean var4) throws SQLException;

    @Override
    public final DbGeoCountry getGeoCountry(Connection connection, long l) throws SQLException {
        DbGeoCountry[] dbGeoCountryArray = this.getGeoCountries(connection, new long[]{l});
        return dbGeoCountryArray != null && dbGeoCountryArray.length > 0 ? dbGeoCountryArray[0] : null;
    }

    @Override
    public abstract DbGeoCountry getGeoCountry(Connection var1, long var2, String var4) throws SQLException;

    @Override
    public abstract DbGeoCountry[] getGeoCountries(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbGeoCountry[] getGeoCountries(Connection var1, long var2) throws SQLException;

    @Override
    public final DbGeo getGeoDb(Connection connection, long l) throws SQLException {
        DbGeo[] dbGeoArray = l > 0L ? this.getGeoDbs(connection, new long[]{l}) : null;
        return dbGeoArray != null && dbGeoArray.length > 0 ? dbGeoArray[0] : null;
    }

    @Override
    public final DbGeo getGeoDb(Connection connection, String string) throws SQLException {
        DbGeo[] dbGeoArray = string != null ? this.getGeoDbs(connection, new String[]{string}) : null;
        return dbGeoArray != null && dbGeoArray.length > 0 ? dbGeoArray[0] : null;
    }

    @Override
    public final DbGeo[] getGeoDbs(Connection connection) throws SQLException {
        return this.getGeoDbs(connection, (long[])null);
    }

    @Override
    public abstract DbGeo[] getGeoDbs(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbGeo[] getGeoDbs(Connection var1, String[] var2) throws SQLException;

    private static DbGeoArea lookupArea(GeoAreaImpl geoAreaImpl, List<DbGeoArea> list) {
        Object object;
        String string = StringUtils.trimToNull((String)geoAreaImpl.getProviderId());
        if (string != null) {
            object = list.iterator();
            while (object.hasNext()) {
                DbGeoArea dbGeoArea = (DbGeoArea)object.next();
                String object2 = StringUtils.trimToEmpty((String)dbGeoArea.providerId);
                if (!object2.equalsIgnoreCase(string)) continue;
                return dbGeoArea;
            }
        }
        if ((object = StringUtils.trimToNull((String)geoAreaImpl.getName())) != null) {
            for (DbGeoArea dbGeoArea : list) {
                String string2 = StringUtils.trimToEmpty((String)dbGeoArea.name);
                if (!string2.equalsIgnoreCase((String)object)) continue;
                return dbGeoArea;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void mergeFromXml(Connection connection, GeoImpl geoImpl) throws SQLException {
        void geoCountryImpl;
        String string = geoImpl.getName();
        DbGeo dbGeo = this.getGeoDb(connection, string);
        if (dbGeo == null) {
            dbGeo = DbGeo.createFromXml(geoImpl);
            this.saveGeoDb(connection, dbGeo, true);
            return;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Object arrayList = this.getGeoCountries(connection, dbGeo.id);
        int n = ((DbGeoCountry[])arrayList).length;
        boolean bl = false;
        while (geoCountryImpl < n) {
            DbGeoCountry dbGeoCountry = arrayList[geoCountryImpl];
            String string2 = dbGeoCountry.locale.getCountry().toLowerCase();
            hashMap.put(string2, dbGeoCountry.id);
            ++geoCountryImpl;
        }
        arrayList = new ArrayList();
        for (GeoCountryImpl entry : geoImpl.getCountries()) {
            this.mergeFromXml(connection, entry, dbGeo);
            String string3 = entry.getIsoCode().toLowerCase();
            arrayList.add(string3);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String string4 = (String)entry.getKey();
            long l = (Long)entry.getValue();
            if (arrayList.contains(string4)) continue;
            this.removeGeoCountry(connection, l);
        }
        dbGeo.buildTime = geoImpl.getBuildTime();
        dbGeo.provider = geoImpl.getProvider();
        this.saveGeoDb(connection, dbGeo, false);
    }

    private void mergeFromXml(Connection connection, GeoCountryImpl geoCountryImpl, DbGeo dbGeo) throws SQLException {
        DbGeoCountry dbGeoCountry = this.getGeoCountry(connection, dbGeo.id, geoCountryImpl.getIsoCode());
        if (dbGeoCountry == null) {
            dbGeoCountry = DbGeoCountry.createFromXml(geoCountryImpl);
            this.saveGeoCountry(connection, dbGeoCountry, true);
            return;
        }
        HashMap<Long, List<DbGeoArea>> hashMap = new HashMap<Long, List<DbGeoArea>>();
        for (DbGeoArea serializable : this.getGeoAreas(connection, dbGeoCountry.id, true)) {
            long l;
            long l2 = l = serializable.parentAreaId > 0L ? serializable.parentAreaId : 0L;
            if (!hashMap.containsKey(l)) {
                hashMap.put(l, new ArrayList());
            }
            ((List)hashMap.get(l)).add(serializable);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<DbGeoArea> arrayList2 = new ArrayList<DbGeoArea>();
        if (hashMap.containsKey(0L)) {
            arrayList2.addAll((Collection)hashMap.get(0L));
        }
        for (GeoAreaImpl geoAreaImpl : geoCountryImpl.getAreas()) {
            DbGeoArea dbGeoArea = DbGeoHandlerImpl.lookupArea(geoAreaImpl, arrayList2);
            if (dbGeoArea != null) {
                arrayList.add(dbGeoArea.id);
            }
            this.mergeFromXml(connection, geoAreaImpl, dbGeoArea, null, dbGeoCountry, hashMap);
        }
        for (DbGeoArea dbGeoArea : arrayList2) {
            if (arrayList.contains(dbGeoArea.id)) continue;
            this.removeGeoArea(connection, dbGeoArea.id);
        }
        dbGeoCountry.geoId = dbGeo.id;
        dbGeoCountry.name = geoCountryImpl.getName();
        dbGeoCountry.providerId = geoCountryImpl.getProviderId();
        this.saveGeoCountry(connection, dbGeoCountry, false);
    }

    private void mergeFromXml(Connection connection, GeoAreaImpl geoAreaImpl, DbGeoArea dbGeoArea, DbGeoArea dbGeoArea2, DbGeoCountry dbGeoCountry, Map<Long, List<DbGeoArea>> map) throws SQLException {
        if (dbGeoArea == null) {
            dbGeoArea = DbGeoArea.createFromXml(geoAreaImpl);
            dbGeoArea.geo = dbGeoArea2.geo;
            dbGeoArea.parentArea = dbGeoArea2;
            dbGeoArea.parentAreaId = dbGeoArea2.id;
            dbGeoArea.countryId = dbGeoArea2.countryId;
            this.saveGeoArea(connection, dbGeoArea, true);
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<DbGeoArea> arrayList2 = new ArrayList<DbGeoArea>();
        if (map.containsKey(dbGeoArea.id)) {
            arrayList2.addAll((Collection)map.get(dbGeoArea.id));
        }
        for (GeoAreaImpl serializable : geoAreaImpl.getAreas()) {
            DbGeoArea dbGeoArea3 = DbGeoHandlerImpl.lookupArea(serializable, arrayList2);
            if (dbGeoArea3 != null) {
                arrayList.add(dbGeoArea3.id);
            }
            this.mergeFromXml(connection, serializable, dbGeoArea3, dbGeoArea, dbGeoCountry, map);
        }
        for (DbGeoArea dbGeoArea4 : arrayList2) {
            if (arrayList.contains(dbGeoArea4.id)) continue;
            this.removeGeoArea(connection, dbGeoArea4.id);
        }
        dbGeoArea.geo = dbGeoCountry.geo;
        dbGeoArea.parentArea = dbGeoArea2;
        dbGeoArea.parentAreaId = dbGeoArea2 != null ? dbGeoArea2.id : 0L;
        dbGeoArea.country = dbGeoCountry;
        dbGeoArea.countryId = dbGeoCountry.id;
        dbGeoArea.name = geoAreaImpl.getName();
        dbGeoArea.providerId = geoAreaImpl.getProviderId();
        this.saveGeoArea(connection, dbGeoArea, false);
    }

    @Override
    public final void removeGeoArea(Connection connection, long l) throws SQLException {
        if (l > 0L) {
            this.removeGeoAreas(connection, new long[]{l});
        }
    }

    @Override
    public abstract void removeGeoAreas(Connection var1, long[] var2) throws SQLException;

    @Override
    public final void removeGeoCountry(Connection connection, long l) throws SQLException {
        if (l > 0L) {
            this.removeGeoCountries(connection, new long[]{l});
        }
    }

    @Override
    public abstract void removeGeoCountries(Connection var1, long[] var2) throws SQLException;

    @Override
    public final void removeGeoDb(Connection connection, long l) throws SQLException {
        if (l > 0L) {
            this.removeGeoDbs(connection, new long[]{l});
        }
    }

    @Override
    public abstract void removeGeoDbs(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract void saveGeoArea(Connection var1, DbGeoArea var2, boolean var3) throws SQLException;

    @Override
    public abstract void saveGeoCountry(Connection var1, DbGeoCountry var2, boolean var3) throws SQLException;

    @Override
    public abstract void saveGeoDb(Connection var1, DbGeo var2, boolean var3) throws SQLException;
}

