/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db;

import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.impl.db.NamedPreparedStatement;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcUtils.class);

    public static void closeQuietly(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.warn("Can't close result set!");
            LOGGER.warn("> " + sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
    }

    public static void closeQuietly(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.warn("Can't close statement!");
            LOGGER.warn("> " + sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
    }

    public static void closeQuietly(NamedCallableStatement namedCallableStatement) {
        if (namedCallableStatement != null) {
            JdbcUtils.closeQuietly(namedCallableStatement.getStatement());
        }
    }

    public static void closeQuietly(NamedPreparedStatement namedPreparedStatement) {
        if (namedPreparedStatement != null) {
            JdbcUtils.closeQuietly(namedPreparedStatement.getStatement());
        }
    }

    public static void closeQuietly(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.warn("Can't close connection!");
            LOGGER.warn("> " + sQLException.getLocalizedMessage(), (Throwable)sQLException);
        }
    }

    public static TableModel createTableModelFromResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = resultSetMetaData.getColumnCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(resultSetMetaData.getColumnLabel(i + 1));
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[0][], arrayList.toArray(new String[0]));
        while (resultSet.next()) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 1; i <= n; ++i) {
                Object object = resultSet.getObject(i);
                if (object instanceof Blob) {
                    Blob blob = (Blob)object;
                    arrayList2.add("[BLOB " + JdbcUtils.getHumanReadableByteCount(blob.length()) + "]");
                    continue;
                }
                arrayList2.add(object != null ? object.toString() : null);
            }
            defaultTableModel.addRow(arrayList2.toArray(new Object[0]));
        }
        return defaultTableModel;
    }

    public static void debugResult(ResultSet resultSet) throws SQLException {
        LOGGER.debug("DEBUG RESULT SET");
        if (!resultSet.next()) {
            LOGGER.debug("> result is empty!");
            return;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        do {
            for (int i = 1; i <= n; ++i) {
                String string = resultSetMetaData.getColumnName(i);
                String string2 = resultSetMetaData.getColumnLabel(i);
                Object object = resultSet.getObject(i);
                LOGGER.debug("> row " + i);
                LOGGER.debug(">> name  " + string);
                LOGGER.debug(">> label " + string2);
                LOGGER.debug(">> value " + object);
            }
        } while (resultSet.next());
    }

    private static String getHumanReadableByteCount(long l) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(2);
        return JdbcUtils.getHumanReadableByteCount(l, numberFormat);
    }

    private static String getHumanReadableByteCount(long l, NumberFormat numberFormat) {
        if (l / 0x40000000L > 0L) {
            double d = (double)l / 1.073741824E9;
            return numberFormat.format(d) + " GB";
        }
        if (l / 0x100000L > 0L) {
            double d = (double)l / 1048576.0;
            return numberFormat.format(d) + " MB";
        }
        if (l / 1024L > 0L) {
            double d = (double)l / 1024.0;
            return numberFormat.format(d) + " KB";
        }
        return numberFormat.format(l) + " bytes";
    }

    public static String writeQuestionMarkList(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("?");
        }
        return stringBuilder.toString();
    }
}

