/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.utils;

import com.openindex.openestate.impl.values.AreaValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAreaValueField
extends JPanel {
    private static final long serialVersionUID = -2008911038881805868L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JAreaValueField.class);
    private JFormattedTextField valueField;
    private JSpinner unitSpinner;
    private AreaValue.Unit currentUnit = null;

    public JAreaValueField() {
        super(new BorderLayout(5, 0));
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(2);
        this.valueField = new JFormattedTextField(numberFormat);
        this.valueField.setFocusLostBehavior(0);
        this.add((Component)this.valueField, "Center");
        SpinnerListModel spinnerListModel = new SpinnerListModel(Arrays.asList(AreaValue.Unit.values()));
        this.unitSpinner = new JSpinner(spinnerListModel);
        this.unitSpinner.setValue((Object)AreaValue.Unit.getBaseUnit());
        this.unitSpinner.setPreferredSize(new Dimension(60, this.unitSpinner.getPreferredSize().height));
        this.unitSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AreaValue areaValue = JAreaValueField.this.getValue();
                if (areaValue == null) {
                    return;
                }
                if (JAreaValueField.this.currentUnit != null) {
                    JAreaValueField.this.valueField.setValue(AreaValue.convert(areaValue.getValue(), JAreaValueField.this.currentUnit, areaValue.getUnit()));
                }
                JAreaValueField.this.currentUnit = areaValue.getUnit();
            }
        });
        this.add((Component)this.unitSpinner, "East");
        this.revalidate();
        this.repaint();
    }

    public JSpinner getUnitSpinner() {
        return this.unitSpinner;
    }

    public AreaValue getValue() {
        try {
            this.valueField.commitEdit();
            return !this.valueField.isEditValid() ? null : AreaValue.parse(this.valueField.getValue(), (AreaValue.Unit)((Object)this.unitSpinner.getValue()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JFormattedTextField getValueField() {
        return this.valueField;
    }

    public void setValue(AreaValue areaValue) {
        this.currentUnit = areaValue != null ? areaValue.getUnit() : AreaValue.Unit.getBaseUnit();
        this.unitSpinner.setValue((Object)this.currentUnit);
        this.valueField.setValue(areaValue != null ? Double.valueOf(areaValue.doubleValue()) : null);
    }
}

