/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.values;

import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.values.UnitValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaValue
extends Number
implements UnitValue<Unit>,
Comparable<AreaValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AreaValue.class);
    private BigDecimal value;
    private Unit unit;

    public AreaValue() {
        this(null, null);
    }

    public AreaValue(BigDecimal bigDecimal, Unit unit) {
        this.value = bigDecimal;
        this.unit = unit != null ? unit : Unit.getBaseUnit();
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="Comparison does not use equals() - possibly a bug in FindBugs.")
    public int compareTo(AreaValue areaValue) {
        Unit unit;
        if (areaValue == null) {
            return -1;
        }
        BigDecimal bigDecimal = this.getValue();
        BigDecimal bigDecimal2 = areaValue.getValue();
        if (bigDecimal == null && bigDecimal2 == null) {
            return 0;
        }
        if (bigDecimal == null) {
            return 1;
        }
        if (bigDecimal2 == null) {
            return -1;
        }
        Unit unit2 = this.getUnit();
        if (unit2 == null) {
            unit2 = Unit.getBaseUnit();
        }
        if ((unit = areaValue.getUnit()) == null) {
            unit = Unit.getBaseUnit();
        }
        if (unit2 != unit) {
            bigDecimal2 = AreaValue.convert(bigDecimal2, unit, unit2);
        }
        return bigDecimal.compareTo(bigDecimal2);
    }

    public static BigDecimal convert(AreaValue areaValue, Unit unit) {
        return AreaValue.convert(areaValue.getValue(), areaValue.getUnit(), unit);
    }

    public static BigDecimal convert(BigDecimal bigDecimal, Unit unit, Unit unit2) {
        if (unit == null) {
            throw new IllegalArgumentException("Invalid source unit!");
        }
        if (unit2 == null) {
            throw new IllegalArgumentException("Invalid target unit!");
        }
        if (unit == unit2) {
            return bigDecimal;
        }
        MathContext mathContext = new MathContext(10, RoundingMode.HALF_UP);
        BigDecimal bigDecimal2 = unit.getBaseUnitFactor();
        if (bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
            throw new IllegalArgumentException("An invalid source unit was provided!");
        }
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2, mathContext);
        if (Unit.getBaseUnit() == unit2) {
            return bigDecimal3;
        }
        BigDecimal bigDecimal4 = unit2.getBaseUnitFactor();
        if (bigDecimal4.compareTo(BigDecimal.ZERO) < 1) {
            throw new IllegalArgumentException("An invalid target unit was provided!");
        }
        return bigDecimal3.divide(bigDecimal4, mathContext);
    }

    @Override
    public double doubleValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.floatValue();
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        if (this.value == null) {
            throw new NullPointerException("Unknown value!");
        }
        return this.value.longValue();
    }

    public static AreaValue parse(Object object) {
        return AreaValue.parse(object, null);
    }

    public static AreaValue parse(Object object, Unit unit) {
        if (object instanceof AreaValue) {
            return (AreaValue)object;
        }
        if (unit == null) {
            unit = Unit.getBaseUnit();
        }
        if (object instanceof String) {
            object = OpenEstateUtils.parseNumber((String)object);
        }
        if (object instanceof BigDecimal) {
            return new AreaValue((BigDecimal)object, unit);
        }
        if (object instanceof BigInteger) {
            return new AreaValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Long) {
            return new AreaValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Integer) {
            return new AreaValue(BigDecimal.valueOf(((Number)object).longValue()), unit);
        }
        if (object instanceof Number) {
            return new AreaValue(BigDecimal.valueOf(((Number)object).doubleValue()), unit);
        }
        return null;
    }

    @Override
    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public void setValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "null";
    }

    public static enum Unit {
        SQMM,
        SQCM,
        SQDM,
        SQM,
        A,
        HA,
        SQKM,
        SQIN,
        SQFT,
        SQYD,
        SQRD,
        AC,
        SQMI;


        public static Unit getBaseUnit() {
            return SQM;
        }

        public BigDecimal getBaseUnitFactor() {
            switch (this) {
                case SQMM: {
                    return new BigDecimal("1e-6");
                }
                case SQCM: {
                    return new BigDecimal("1e-4");
                }
                case SQDM: {
                    return new BigDecimal("1e-2");
                }
                case SQM: {
                    return BigDecimal.ONE;
                }
                case A: {
                    return new BigDecimal("1e2");
                }
                case HA: {
                    return new BigDecimal("1e4");
                }
                case SQKM: {
                    return new BigDecimal("1e6");
                }
                case SQIN: {
                    return new BigDecimal("0.00064516d");
                }
                case SQFT: {
                    return new BigDecimal("0.09290304d");
                }
                case SQYD: {
                    return new BigDecimal("0.83612736d");
                }
                case SQRD: {
                    return new BigDecimal("25.29285264d");
                }
                case AC: {
                    return new BigDecimal("4046.8564224d");
                }
                case SQMI: {
                    return new BigDecimal("2589988.110336d");
                }
            }
            return BigDecimal.ZERO;
        }

        public String toString() {
            return this.write();
        }

        public String write() {
            switch (this) {
                case SQM: {
                    return "m\u00b2";
                }
                case HA: {
                    return "ha";
                }
                case SQKM: {
                    return "km\u00b2";
                }
                case A: {
                    return "a";
                }
                case SQDM: {
                    return "dm\u00b2";
                }
                case SQCM: {
                    return "cm\u00b2";
                }
                case SQMM: {
                    return "mm\u00b2";
                }
                case SQIN: {
                    return "in\u00b2";
                }
                case SQFT: {
                    return "ft\u00b2";
                }
                case SQYD: {
                    return "yd\u00b2";
                }
                case SQRD: {
                    return "rd\u00b2";
                }
                case AC: {
                    return "ac";
                }
                case SQMI: {
                    return "mi\u00b2";
                }
            }
            return null;
        }
    }
}

