/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.standard.ShadingUtil;
import org.java.plugin.util.IoUtil;

final class ShadowDataController {
    private static final String META_FILE_NAME = ".meta";
    private final Log log = LogFactory.getLog(ShadowDataController.class);
    private final File shadowFolder;
    private final URL shadowFolderUrl;
    private final Properties metaData;
    private final DateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final FileFilter fileFilter;

    static ShadowDataController init(File shadowFolder, FileFilter filter) throws IOException {
        ShadowDataController result = new ShadowDataController(shadowFolder, filter);
        result.quickCheck();
        result.save();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShadowDataController(File folder, FileFilter filter) throws IOException {
        this.shadowFolder = folder;
        this.fileFilter = filter;
        this.shadowFolderUrl = IoUtil.file2url(folder);
        File metaFile = new File(this.shadowFolder, META_FILE_NAME);
        this.metaData = new Properties();
        if (metaFile.isFile()) {
            try {
                FileInputStream in = new FileInputStream(metaFile);
                try {
                    this.metaData.load(in);
                }
                finally {
                    ((InputStream)in).close();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("meta-data loaded from file " + metaFile));
                }
            }
            catch (IOException ioe) {
                this.log.warn((Object)("failed loading meta-data from file " + metaFile), (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        File metaFile = new File(this.shadowFolder, META_FILE_NAME);
        try {
            FileOutputStream out = new FileOutputStream(metaFile, false);
            try {
                this.metaData.store(out, "This is automatically generated file.");
            }
            finally {
                ((OutputStream)out).close();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("meta-data saved to file " + metaFile));
            }
        }
        catch (IOException ioe) {
            this.log.warn((Object)("failed saving meta-data to file " + metaFile), (Throwable)ioe);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void quickCheck() {
        void var4_6;
        File[] files;
        File[] arr$ = files = this.shadowFolder.listFiles(new ShadowFileFilter());
        int len$ = arr$.length;
        boolean bl = false;
        while (var4_6 < len$) {
            File file = arr$[var4_6];
            if (!this.metaData.containsValue(file.getName())) {
                if (ShadingUtil.deleteFile(file)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("deleted shadow file " + file));
                    }
                } else {
                    this.log.warn((Object)("can't delete shadow file " + file));
                }
            }
            ++var4_6;
        }
        HashSet<Object> uids = new HashSet<Object>();
        for (Map.Entry<Object, Object> entry : this.metaData.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("uid:")) continue;
            uids.add(entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : uids) {
            this.quickCheck((String)((Object)entry));
        }
    }

    private void quickCheck(String uid) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("quick check of UID " + uid));
        }
        String url = this.metaData.getProperty("source:" + uid, null);
        String file = this.metaData.getProperty("file:" + uid, null);
        String modified = this.metaData.getProperty("modified:" + uid, null);
        if (url == null || file == null || modified == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("meta-data incomplete, UID=" + uid));
            }
            this.remove(uid);
            return;
        }
        try {
            if (!this.dtf.parse(modified).equals(ShadingUtil.getLastModified(ShadingUtil.buildURL(this.shadowFolderUrl, url)))) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("source modification detected, UID=" + uid + ", source=" + url));
                }
                this.remove(uid);
            }
        }
        catch (IOException ioe) {
            this.log.warn((Object)"quick check failed", (Throwable)ioe);
            this.remove(uid);
        }
        catch (ParseException pe) {
            this.log.warn((Object)"quick check failed", (Throwable)pe);
            this.remove(uid);
        }
    }

    private void remove(String uid) {
        String file = this.metaData.getProperty("file:" + uid, null);
        if (file != null) {
            File lostFile = new File(this.shadowFolder, file);
            if (ShadingUtil.deleteFile(lostFile)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("deleted lost file " + file));
                }
            } else {
                this.log.warn((Object)("can't delete lost file " + file));
            }
        }
        boolean removed = this.metaData.remove("uid:" + uid) != null;
        removed |= this.metaData.remove("source:" + uid) != null;
        removed |= this.metaData.remove("file:" + uid) != null;
        if ((removed |= this.metaData.remove("modified:" + uid) != null) && this.log.isDebugEnabled()) {
            this.log.debug((Object)("removed meta-data, UID=" + uid));
        }
    }

    private URL add(String uid, URL sourceUrl, File file, Date modified) throws IOException {
        URL result = IoUtil.file2url(file);
        this.metaData.setProperty("uid:" + uid, uid);
        String source = ShadingUtil.getRelativeUrl(this.shadowFolder, sourceUrl);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("relativize: base=" + this.shadowFolder + "; url=" + sourceUrl + "; result=" + source));
        }
        this.metaData.setProperty("source:" + uid, source);
        this.metaData.setProperty("file:" + uid, file.getName());
        this.metaData.setProperty("modified:" + uid, this.dtf.format(modified));
        this.save();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("shading done, UID=" + uid + ", source=" + source + ", file=" + result + ", modified=" + this.dtf.format(modified)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URL shadowResource(URL source, String uid, boolean unpack) {
        Date lastModified;
        block45: {
            URL uRL;
            block48: {
                try {
                    URL result = this.deepCheck(source, uid);
                    if (result != null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("got actual shaded resource, UID=" + uid + ", source=" + source + ", file=" + result));
                        }
                        return result;
                    }
                }
                catch (Exception e) {
                    this.log.warn((Object)("deep check failed, UID=" + uid + ", URL=" + source), (Throwable)e);
                    this.remove(uid);
                }
                try {
                    lastModified = ShadingUtil.getLastModified(source);
                }
                catch (IOException ioe) {
                    this.log.error((Object)("shading failed, can't get modification date for " + source), (Throwable)ioe);
                    return source;
                }
                File file = IoUtil.url2file(source);
                if (file != null && file.isDirectory()) {
                    try {
                        File rootFolder = new File(this.shadowFolder, uid);
                        IoUtil.copyFolder(file, rootFolder, true, true, this.fileFilter);
                        return this.add(uid, source, rootFolder, lastModified);
                    }
                    catch (IOException ioe) {
                        this.log.error((Object)("failed shading local folder " + file), (Throwable)ioe);
                        return source;
                    }
                }
                if (!"jar".equalsIgnoreCase(source.getProtocol())) break block45;
                String urlStr = source.toExternalForm();
                int p = urlStr.indexOf("!/");
                if (p == -1) {
                    p = urlStr.length();
                }
                URL jarFileURL = new URL(urlStr.substring(4, p));
                if (!unpack) {
                    String ext = ShadingUtil.getExtension(jarFileURL.getFile());
                    if (ext == null) {
                        ext = "jar";
                    }
                    File shadowFile = new File(this.shadowFolder, uid + '.' + ext);
                    File sourceFile = IoUtil.url2file(jarFileURL);
                    InputStream in = sourceFile != null ? new FileInputStream(sourceFile) : jarFileURL.openStream();
                    try {
                        FileOutputStream out = new FileOutputStream(shadowFile, false);
                        try {
                            IoUtil.copyStream(in, out, 1024);
                        }
                        finally {
                            ((OutputStream)out).close();
                        }
                    }
                    finally {
                        in.close();
                    }
                    return this.add(uid, source, shadowFile, lastModified);
                }
                URLConnection cnn = null;
                try {
                    ZipFile zipFile;
                    File sourceFile = IoUtil.url2file(jarFileURL);
                    if (sourceFile != null) {
                        zipFile = new ZipFile(sourceFile);
                    } else {
                        cnn = source.openConnection();
                        cnn.setUseCaches(false);
                        zipFile = ((JarURLConnection)cnn).getJarFile();
                    }
                    File rootFolder = new File(this.shadowFolder, uid);
                    try {
                        ShadingUtil.unpack(zipFile, rootFolder);
                    }
                    finally {
                        zipFile.close();
                    }
                    uRL = this.add(uid, source, rootFolder, lastModified);
                    if (cnn == null) break block48;
                }
                catch (Throwable throwable) {
                    try {
                        if (cnn != null) {
                            cnn.getInputStream().close();
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        this.log.error((Object)("failed shading URL connection " + source), (Throwable)ioe);
                        return source;
                    }
                }
                cnn.getInputStream().close();
            }
            return uRL;
        }
        String fileName = source.getFile();
        if (fileName == null) {
            this.log.warn((Object)("can't get file name from resource " + source + ", shading failed"));
            return source;
        }
        String ext = ShadingUtil.getExtension(fileName);
        if (ext == null) {
            this.log.warn((Object)("can't get file name extension for resource " + source + ", shading failed"));
            return source;
        }
        if (unpack && ("jar".equalsIgnoreCase(ext) || "zip".equalsIgnoreCase(ext))) {
            try {
                InputStream strm = source.openStream();
                File rootFolder = new File(this.shadowFolder, uid);
                try {
                    ShadingUtil.unpack(strm, rootFolder);
                }
                finally {
                    strm.close();
                }
                return this.add(uid, source, rootFolder, lastModified);
            }
            catch (IOException ioe) {
                this.log.error((Object)("failed shading packed resource " + source), (Throwable)ioe);
                return source;
            }
        }
        try {
            File shadowFile = new File(this.shadowFolder, uid + '.' + ext);
            InputStream in = source.openStream();
            try {
                FileOutputStream out = new FileOutputStream(shadowFile, false);
                try {
                    IoUtil.copyStream(in, out, 1024);
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                in.close();
            }
            return this.add(uid, source, shadowFile, lastModified);
        }
        catch (IOException ioe) {
            this.log.error((Object)("failed shading resource file " + source), (Throwable)ioe);
            return source;
        }
    }

    private URL deepCheck(URL source, String uid) throws Exception {
        URL storedSource;
        String url = this.metaData.getProperty("source:" + uid, null);
        if (url == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("URL not found in meta-data, UID=" + uid));
            }
            this.remove(uid);
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("URL found in meta-data, UID=" + uid + ", source=" + source + ", storedURL=" + url));
        }
        if (!(storedSource = ShadingUtil.buildURL(this.shadowFolderUrl, url)).equals(source)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("inconsistent URL found in meta-data, UID=" + uid + ", source=" + source + ", storedSource=" + storedSource));
            }
            this.remove(uid);
            return null;
        }
        String modified = this.metaData.getProperty("modified:" + uid, null);
        if (modified == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("modification info not found in meta-data, UID=" + uid));
            }
            this.remove(uid);
            return null;
        }
        if (!ShadingUtil.getLastModified(source).equals(this.dtf.parse(modified))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("source modification detected, UID=" + uid + ", source=" + source));
            }
            this.remove(uid);
            return null;
        }
        String fileStr = this.metaData.getProperty("file:" + uid, null);
        if (fileStr == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("file info not found in meta-data, UID=" + uid));
            }
            this.remove(uid);
            return null;
        }
        File file = new File(this.shadowFolder, fileStr);
        if (!file.exists()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("shadow file not found, UID=" + uid + ", source=" + source + ", file=" + file));
            }
            this.remove(uid);
            return null;
        }
        File sourceFile = IoUtil.url2file(source);
        if (sourceFile != null && sourceFile.isDirectory()) {
            IoUtil.synchronizeFolders(sourceFile, file, this.fileFilter);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("folders synchronized, UID=" + uid + ", srcFile=" + sourceFile + ", destFile=" + file));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("source " + source + " (file is " + sourceFile + ") is not local folder, " + "skipping synchronization, UID=" + uid));
        }
        return IoUtil.file2url(file);
    }

    static class ShadowFileFilter
    implements FileFilter {
        ShadowFileFilter() {
        }

        public boolean accept(File file) {
            return !ShadowDataController.META_FILE_NAME.equals(file.getName());
        }
    }
}

