/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard;

import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractFactoryRegistry<T> {
    private final ServiceLoader<T> factoryLoader;
    private Map<String, T> extendedFactories;

    public AbstractFactoryRegistry(ServiceLoader<T> factoryLoader) {
        this.factoryLoader = factoryLoader;
        this.extendedFactories = new ConcurrentHashMap<String, T>();
    }

    protected abstract boolean factorySupports(T var1, String var2);

    public final T getFactory(String name) {
        Object factory = null;
        Iterator<T> it = this.factoryLoader.iterator();
        while (it.hasNext() && !this.factorySupports(factory = it.next(), name)) {
            factory = null;
        }
        if (factory == null) {
            factory = this.extendedFactories.get(name);
        }
        return factory;
    }

    @Deprecated
    public final void register(String extendedName, T factory) {
        this.extendedFactories.put(extendedName, factory);
    }
}

