/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.CalendarModel;
import bizcal.swing.StringLengthFormater;
import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.GradientArea;
import bizcal.swing.util.TableLayoutPanel;
import bizcal.util.BizcalException;
import bizcal.util.DateUtil;
import bizcal.util.TextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonthDateChooser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonthDateChooser.class);
    private static int WEEK_COLUMN_WIDTH = 20;
    private static int GRADIENT_TOP_HEIGHT = 30;
    private static int WEEKDAY_ROW_HEIGHT = 20;
    private static Color SELECTED_BGCOLOR = new Color(245, 245, 245);
    private static long DAY_INTERVAL = 1L;
    private static long WEEK_INTERVAL = 7L;
    private static long TWO_WEEK_INTERVAL = 14L;
    private Font font;
    private Color primaryColor;
    private Color secondaryColor;
    private TableLayoutPanel _panel;
    private int width;
    private int height;
    private JButton previousButton;
    private JButton nextButton;
    private Date navigationDate;
    private CalendarModel _broker;
    private List _listeners = new ArrayList();
    private int selectionInterval = 1;
    private Date _currDate;
    private Map _rowByDayno = new HashMap();
    private Object projectId;

    public MonthDateChooser(Date date) throws Exception {
        this.navigationDate = DateUtil.round2Day(date);
        this._currDate = DateUtil.round2Day(date);
        this._panel = new TableLayoutPanel();
        this._panel.addComponentListener(new ThisComponentListener());
        this._panel.setMinimumSize(new Dimension(180, 150));
        this.primaryColor = new Color(200, 200, 200);
        this.secondaryColor = Color.WHITE;
        this.font = new Font("Verdana", 0, 10);
    }

    private void loadRedDays() throws Exception {
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        calendar.setTime(this.navigationDate);
        calendar.set(5, 1);
        calendar.add(2, 1);
    }

    public void setBroker(CalendarModel calendarModel) throws Exception {
        this._broker = calendarModel;
        this.loadRedDays();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setNavigationDate(Date date) throws Exception {
        this.navigationDate = DateUtil.round2Day(date);
        this.loadRedDays();
    }

    public Date getNavigationDate() throws Exception {
        return this.navigationDate;
    }

    public JComponent getComponent() throws Exception {
        this.init();
        return this._panel;
    }

    private void init() throws Exception {
        if (this._panel != null) {
            return;
        }
        this._panel = new TableLayoutPanel();
        this.refresh();
    }

    public void refresh() throws Exception {
        GradientArea gradientArea;
        Object object;
        int n;
        if (this._panel == null) {
            this._panel = new TableLayoutPanel();
        }
        this._panel.deleteRows();
        this._panel.deleteColumns();
        this._panel.clear();
        this._rowByDayno.clear();
        this._panel.setBackground(Color.WHITE);
        this._panel.createColumn(WEEK_COLUMN_WIDTH);
        for (int i = 0; i < 7; ++i) {
            this._panel.createColumn(-1.0);
        }
        TableLayoutPanel.Row row = this._panel.createRow(GRADIENT_TOP_HEIGHT);
        TableLayoutPanel.Cell cell = row.createCell();
        cell.setColumnSpan(8);
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        calendar.setTime(this.navigationDate);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM", Locale.getDefault());
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy", Locale.getDefault());
        ImageIcon imageIcon = this.createImageIcon("util/images/left.gif");
        this.previousButton = new JButton(imageIcon);
        this.previousButton.setBounds(4, 5, 20, 20);
        this.previousButton.setOpaque(false);
        this.previousButton.addActionListener(new StepperListener());
        ImageIcon imageIcon2 = this.createImageIcon("util/images/right.gif");
        this.nextButton = new JButton(imageIcon2);
        this.nextButton.setBounds(this.width - 24, 5, 20, 20);
        this.nextButton.setOpaque(false);
        this.nextButton.addActionListener(new StepperListener());
        GradientArea gradientArea2 = new GradientArea("TOP_BOTTOM", this.secondaryColor, this.primaryColor);
        gradientArea2.setGradientLength(0.5);
        JLabel jLabel = new JLabel(TextUtil.formatCase(simpleDateFormat.format(calendar.getTime())) + " " + simpleDateFormat2.format(calendar.getTime()), 0);
        jLabel.setForeground(Color.WHITE);
        jLabel.setFont(this.font.deriveFont(1, 12.0f));
        jLabel.setBounds(0, 0, this.width, GRADIENT_TOP_HEIGHT);
        gradientArea2.add(this.previousButton);
        gradientArea2.add(this.nextButton);
        gradientArea2.add(jLabel);
        gradientArea2.setBorderWidth(0.2f);
        gradientArea2.setBorderColor(Color.LIGHT_GRAY);
        cell.put(gradientArea2);
        TableLayoutPanel.Row row2 = this._panel.createRow(WEEKDAY_ROW_HEIGHT);
        GradientArea gradientArea3 = new GradientArea("TOP_BOTTOM", new Color(255, 255, 255), new Color(245, 245, 245));
        gradientArea3.setBorderWidth(0.1f);
        row2.createCell(gradientArea3, 2, 2);
        int n2 = calendar.get(2);
        int n3 = calendar.getFirstDayOfWeek();
        Calendar calendar2 = Calendar.getInstance(Locale.getDefault());
        calendar2.setTime(calendar.getTime());
        for (n = 0; n < 7; ++n) {
            calendar2.set(7, n3);
            String string = StringLengthFormater.formatDateString(calendar2.getTime(), this.font, (this.width - WEEK_COLUMN_WIDTH - 10) / 7, null);
            object = new JLabel(string, 0);
            ((JComponent)object).setForeground(Color.BLACK);
            ((Component)object).setBounds(0, 0, this.width / 7, WEEKDAY_ROW_HEIGHT);
            ((JComponent)object).setFont(this.font.deriveFont(1));
            gradientArea = new GradientArea("TOP_BOTTOM", new Color(255, 255, 255), new Color(240, 240, 240));
            gradientArea.add((Component)object);
            gradientArea.setGradientLength(0.5);
            gradientArea.setBorder(false);
            gradientArea.setBorderWidth(0.1f);
            row2.createCell(gradientArea, 2, 2);
            if (++n3 < 8) continue;
            n3 -= 7;
        }
        calendar.set(5, 1);
        n = calendar.get(7);
        if ((n -= calendar.getFirstDayOfWeek()) < 0) {
            n += 7;
        }
        int n4 = calendar.getFirstDayOfWeek();
        if (--n4 < 1) {
            n4 += 7;
        }
        object = this._panel.createRow(-1.0);
        gradientArea = new GradientArea("LEFT_RIGHT", new Color(255, 255, 255), new Color(245, 245, 245));
        gradientArea.setBorderWidth(0.1f);
        gradientArea.add(this.createCalCell(calendar, false));
        ((TableLayoutPanel.Row)object).createCell(gradientArea, 2, 2);
        for (int i = 0; i < n; ++i) {
            ((TableLayoutPanel.Row)object).createCell();
        }
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        while (calendar.get(2) == n2) {
            JLabel jLabel2 = this.createCalCell(calendar, true);
            arrayList.add(jLabel2);
            this._rowByDayno.put(jLabel2.getText(), arrayList);
            ((TableLayoutPanel.Row)object).createCell(jLabel2, 2, 2);
            if (calendar.get(7) == n4) {
                object = this._panel.createRow(-1.0);
                calendar.add(5, 1);
                gradientArea = new GradientArea("LEFT_RIGHT", new Color(255, 255, 255), new Color(245, 245, 245));
                gradientArea.setBorderWidth(0.1f);
                gradientArea.add(this.createCalCell(calendar, false));
                ((TableLayoutPanel.Row)object).createCell(gradientArea, 2, 2);
                arrayList = new ArrayList();
                continue;
            }
            calendar.add(5, 1);
        }
        this._panel.updateUI();
    }

    private ImageIcon createImageIcon(String string) {
        URL uRL = MonthDateChooser.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        LOGGER.error("Couldn't find file: " + string);
        return null;
    }

    private JLabel createCalCell(Calendar calendar, boolean bl) throws Exception {
        JLabel jLabel = new JLabel("", 0);
        jLabel.setForeground(Color.black);
        if (bl) {
            jLabel.addMouseListener(new DayMouseListener());
            jLabel.setFont(this.font);
            jLabel.setOpaque(true);
            Color color = Color.WHITE;
            boolean bl2 = false;
            if (this._currDate != null) {
                if ((long)this.selectionInterval <= DAY_INTERVAL) {
                    bl2 = calendar.getTime().getTime() == this._currDate.getTime();
                } else if ((long)this.selectionInterval <= TWO_WEEK_INTERVAL) {
                    Calendar calendar2 = Calendar.getInstance(Locale.getDefault());
                    calendar2.setTime(calendar.getTime());
                    int n = calendar2.get(3);
                    calendar2.setTime(this._currDate);
                    int n2 = calendar2.get(3);
                    boolean bl3 = bl2 = n == n2;
                    if ((long)this.selectionInterval == TWO_WEEK_INTERVAL && !bl2) {
                        boolean bl4 = bl2 = n2 == n - 1;
                    }
                }
            }
            if (bl2) {
                color = SELECTED_BGCOLOR;
            }
            jLabel.setBackground(color);
            jLabel.setText("" + calendar.get(5));
            if (DateUtil.round2Day(calendar.getTime()).equals(DateUtil.round2Day(new Date()))) {
                jLabel.setFont(this.font.deriveFont(1));
            }
        } else {
            jLabel.addMouseListener(new WeekMouseListener());
            jLabel.setFont(this.font.deriveFont(1));
            jLabel.setText("" + calendar.get(3));
            jLabel.setBounds(0, 0, WEEK_COLUMN_WIDTH, (this.height - (GRADIENT_TOP_HEIGHT + WEEKDAY_ROW_HEIGHT)) / 5);
            GradientArea gradientArea = new GradientArea("LEFT_RIGHT", new Color(255, 255, 255), new Color(245, 245, 245));
            gradientArea.setBorderWidth(0.1f);
            gradientArea.add(jLabel);
        }
        return jLabel;
    }

    private void selectDate(Date date) throws Exception {
        this._currDate = DateUtil.round2Day(date);
    }

    public void setSelectionInterval(int n) throws Exception {
        this.selectionInterval = n;
        this.refresh();
    }

    public void setProjectId(Object object) {
        this.projectId = object;
    }

    private class ThisComponentListener
    extends ComponentAdapter {
        private ThisComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            try {
                MonthDateChooser.this.width = MonthDateChooser.this._panel.getWidth();
                MonthDateChooser.this.height = MonthDateChooser.this._panel.getHeight();
                MonthDateChooser.this.refresh();
            }
            catch (Exception exception) {
                LOGGER.error("Can't resize component.");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                ErrorHandler.handleError(exception);
            }
        }
    }

    private class WeekMouseListener
    extends MouseAdapter {
        public JLabel label;

        private WeekMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.label = (JLabel)mouseEvent.getSource();
            this.label.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.label = (JLabel)mouseEvent.getSource();
            this.label.setCursor(new Cursor(0));
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                this.label = (JLabel)mouseEvent.getSource();
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }
    }

    private class DayMouseListener
    extends MouseAdapter {
        public JLabel label;
        private Color backgroundw1;
        private Color backgroundw2;

        private DayMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.label = (JLabel)mouseEvent.getSource();
            this.label.setCursor(new Cursor(12));
            this.backgroundw1 = this.label.getBackground();
            if ((long)MonthDateChooser.this.selectionInterval <= DAY_INTERVAL) {
                this.label.setBackground(SELECTED_BGCOLOR);
            } else if ((long)MonthDateChooser.this.selectionInterval <= TWO_WEEK_INTERVAL) {
                int n = 0;
                if ((long)MonthDateChooser.this.selectionInterval == TWO_WEEK_INTERVAL) {
                    n = 1;
                }
                for (int i = 0; i <= n; ++i) {
                    Integer n2 = new Integer(this.label.getText());
                    n2 = n2 + 7 * i;
                    while (!MonthDateChooser.this._rowByDayno.containsKey(n2.toString())) {
                        n2 = n2 - 1;
                    }
                    List list = (List)MonthDateChooser.this._rowByDayno.get(n2.toString());
                    for (JLabel jLabel : list) {
                        if (i == 1) {
                            this.backgroundw2 = jLabel.getBackground();
                        }
                        jLabel.setBackground(SELECTED_BGCOLOR);
                    }
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.label = (JLabel)mouseEvent.getSource();
            this.label.setCursor(new Cursor(0));
            if ((long)MonthDateChooser.this.selectionInterval <= DAY_INTERVAL) {
                this.label.setBackground(this.backgroundw1);
            } else if ((long)MonthDateChooser.this.selectionInterval <= TWO_WEEK_INTERVAL) {
                int n = 0;
                if ((long)MonthDateChooser.this.selectionInterval == TWO_WEEK_INTERVAL) {
                    n = 1;
                }
                for (int i = 0; i <= n; ++i) {
                    Integer n2 = new Integer(this.label.getText());
                    n2 = n2 + 7 * i;
                    while (!MonthDateChooser.this._rowByDayno.containsKey(n2.toString())) {
                        n2 = n2 - 1;
                    }
                    List list = (List)MonthDateChooser.this._rowByDayno.get(n2.toString());
                    for (JLabel jLabel : list) {
                        if (i == 1) {
                            jLabel.setBackground(this.backgroundw2);
                            continue;
                        }
                        jLabel.setBackground(this.backgroundw1);
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(MonthDateChooser.this.navigationDate);
                this.label = (JLabel)mouseEvent.getSource();
                calendar.set(5, Integer.parseInt(this.label.getText()));
                MonthDateChooser.this.selectDate(calendar.getTime());
                MonthDateChooser.this.refresh();
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }
    }

    private class StepperListener
    implements ActionListener {
        private StepperListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Calendar calendar = Calendar.getInstance(Locale.getDefault());
                calendar.setTime(MonthDateChooser.this.getNavigationDate());
                if (actionEvent.getSource() == MonthDateChooser.this.previousButton) {
                    calendar.add(2, -1);
                }
                if (actionEvent.getSource() == MonthDateChooser.this.nextButton) {
                    calendar.add(2, 1);
                }
                MonthDateChooser.this.setNavigationDate(calendar.getTime());
                MonthDateChooser.this.refresh();
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }
    }
}

