/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.TableLayoutPanel;
import bizcal.util.BizcalException;
import bizcal.util.DateUtil;
import bizcal.util.StreamCopier;
import bizcal.util.TextUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WeekStepper {
    private static final I18n I18N = I18nFactory.getI18n(WeekStepper.class);
    private TableLayoutPanel panel;
    private Calendar cal;
    private JComboBox yearCombo;
    private JComboBox weekCombo;
    private JLabel textLabel;
    private List listeners = new ArrayList();
    private String fastRewindArrow = "/bizcal/res/go_fb.gif";
    private String prevArrow = "/bizcal/res/go_back.gif";
    private String nextArrow = "/bizcal/res/go_forward.gif";
    private String fastForwardArrow = "/bizcal/res/go_ff.gif";

    public WeekStepper() throws Exception {
        this.cal = Calendar.getInstance(Locale.getDefault());
        this.cal.setTime(DateUtil.round2Week(new Date()));
        this.panel = new TableLayoutPanel();
        this.panel.createColumn();
        this.panel.createColumn();
        this.panel.createColumn(10.0);
        this.panel.createColumn();
        this.panel.createColumn(10.0);
        this.panel.createColumn();
        this.panel.createColumn(10.0);
        this.panel.createColumn(-1.0);
        this.panel.createColumn();
        this.panel.createColumn();
        TableLayoutPanel.Row row = this.panel.createRow();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WeekStepper.this.previousYear();
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
            }
        };
        row.createCell(this.createButton(this.fastRewindArrow, actionListener));
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WeekStepper.this.previous();
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
            }
        };
        row.createCell(this.createButton(this.prevArrow, actionListener));
        row.createCell();
        this.initYearCombo();
        this.initWeekCombo();
        this.textLabel = new JLabel();
        this.setCombos();
        row.createCell(this.yearCombo);
        row.createCell();
        row.createCell(this.weekCombo);
        row.createCell();
        row.createCell(this.textLabel);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WeekStepper.this.next();
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
            }
        };
        row.createCell(this.createButton(this.nextArrow, actionListener));
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WeekStepper.this.nextYear();
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
            }
        };
        row.createCell(this.createButton(this.fastForwardArrow, actionListener));
    }

    private void initYearCombo() throws Exception {
        this.yearCombo = new JComboBox();
        int n = this.cal.get(1);
        for (int i = n - 1; i < n + 4; ++i) {
            this.yearCombo.addItem(i);
        }
        this.yearCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = (Integer)WeekStepper.this.yearCombo.getSelectedItem();
                    WeekStepper.this.cal.set(1, n);
                    WeekStepper.this.refreshWeekCombo();
                    WeekStepper.this.setLabel();
                }
                catch (Exception exception) {
                    throw BizcalException.create(exception);
                }
            }
        });
    }

    private void initWeekCombo() throws Exception {
        this.weekCombo = new JComboBox();
        int n = this.cal.get(3);
        this.refreshWeekCombo();
        this.weekCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Integer n = (Integer)WeekStepper.this.weekCombo.getSelectedItem();
                    if (n == null) {
                        return;
                    }
                    int n2 = (Integer)WeekStepper.this.weekCombo.getSelectedItem();
                    WeekStepper.this.cal.set(3, n2);
                    WeekStepper.this.setLabel();
                }
                catch (Exception exception) {
                    throw BizcalException.create(exception);
                }
            }
        });
        this.cal.set(3, n);
    }

    private void setCombos() throws Exception {
        int n = this.cal.get(1);
        this.yearCombo.setSelectedItem(n);
        int n2 = this.cal.get(3);
        if (this.weekCombo.getItemCount() < n2) {
            n2 = this.weekCombo.getItemCount();
        }
        this.weekCombo.setSelectedIndex(n2 - 1);
        this.setLabel();
    }

    private void setLabel() throws Exception {
        this.textLabel.setText(this.getText());
    }

    private void refreshWeekCombo() {
        int n = this.cal.get(3);
        this.weekCombo.removeAllItems();
        int n2 = this.cal.getActualMaximum(3);
        for (int i = 1; i <= n2; ++i) {
            this.weekCombo.addItem(i);
        }
        this.cal.set(3, n);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public Date getDate() {
        return this.cal.getTime();
    }

    private void next() throws Exception {
        this.cal.add(3, 1);
        this.setCombos();
        this.fireStateChanged();
    }

    private void previous() throws Exception {
        this.cal.add(3, -1);
        this.setCombos();
        this.fireStateChanged();
    }

    private void nextYear() throws Exception {
        this.cal.add(1, 1);
        this.cal.set(7, this.cal.getFirstDayOfWeek());
        this.setCombos();
        this.fireStateChanged();
    }

    private void previousYear() throws Exception {
        this.cal.add(1, -1);
        this.cal.set(7, this.cal.getFirstDayOfWeek());
        this.setCombos();
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    private void fireStateChanged() throws Exception {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private Icon getIcon(String string) throws Exception {
        byte[] byArray = StreamCopier.copyToByteArray(this.getClass().getResourceAsStream(string));
        return new ImageIcon(byArray);
    }

    private JComponent createButton(String string, ActionListener actionListener) throws Exception {
        JButton jButton = new JButton(this.getIcon(string));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public void setDate(Date date) throws Exception {
        this.cal.setTime(DateUtil.round2Week(date));
        this.setCombos();
        this.fireStateChanged();
    }

    private String getText() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(I18N.tr("week") + " " + this.cal.get(3) + ": ");
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        int n = calendar.get(1);
        int n2 = this.cal.get(1);
        if (n != n2) {
            stringBuffer.append(n2 + " ");
        }
        int n3 = this.cal.get(2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM");
        stringBuffer.append(TextUtil.formatCase(simpleDateFormat.format(this.cal.getTime())) + " ");
        int n4 = this.cal.get(5);
        stringBuffer.append(n4);
        stringBuffer.append(" - ");
        calendar.setTime(this.cal.getTime());
        calendar.add(7, 6);
        int n5 = calendar.get(2);
        if (n3 != n5) {
            stringBuffer.append(TextUtil.formatCase(simpleDateFormat.format(calendar.getTime())) + " ");
        }
        n4 = calendar.get(5);
        stringBuffer.append(n4);
        return stringBuffer.toString();
    }
}

