/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class LassoArea
extends JComponent {
    private static final long serialVersionUID = 1L;
    private Color lineColor = Color.BLACK;
    private boolean dashed = true;
    private boolean roundedRectangle = false;

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D2 = bufferedImage.createGraphics();
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float[] fArray = new float[]{5.0f};
        BasicStroke basicStroke = this.dashed ? new BasicStroke(1.0f, 0, 2, 10.0f, fArray, 0.0f) : new BasicStroke(1.0f);
        graphics2D2.setStroke(basicStroke);
        if (this.roundedRectangle) {
            AlphaComposite alphaComposite = AlphaComposite.getInstance(4, 1.0f);
            graphics2D2.setComposite(alphaComposite);
            graphics2D2.setPaint(this.lineColor);
            graphics2D2.draw(new RoundRectangle2D.Double(1.0, 1.0, n - 2, n2 - 2, 17.0, 17.0));
        } else {
            AlphaComposite alphaComposite = AlphaComposite.getInstance(4, 1.0f);
            graphics2D2.setComposite(alphaComposite);
            graphics2D2.setPaint(this.lineColor);
            graphics2D2.draw(new Rectangle2D.Double(1.0, 1.0, n - 2, n2 - 2));
        }
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        super.paint(graphics2D);
        super.paint(graphics2D2);
    }

    public void setRoundedRectangle(boolean bl) {
        this.roundedRectangle = bl;
    }

    public boolean isRoundedRectangle() {
        return this.roundedRectangle;
    }

    public void setDashed(boolean bl) {
        this.dashed = bl;
    }

    public boolean isDashed() {
        return this.dashed;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }
}

