/*
 * Decompiled with CFR 0.152.
 */
package bizcal.util;

import bizcal.util.CalendarFactory;
import bizcal.util.TimeOfDay;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);
    public static final int MILLIS_SECOND = 1000;
    public static final int MILLIS_MINUTE = 60000;
    public static final int MILLIS_HOUR = 3600000;
    public static final int MILLIS_DAY = 86400000;
    public static final int MINUTES_HOUR = 60;
    public static final int MINUTES_DAY = 1440;
    public static final int MINUTES_WEEK = 10080;
    public static final int DAYS_WEEK = 7;
    private static CalendarFactory calFactory = new DefaultCalendarFactory();

    public static Date round2Day(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date round2Hour(Date date, int n) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        if (n > -1 && n < 25) {
            calendar.set(11, n);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        return calendar.getTime();
    }

    public static Date round2Minute(Date date, int n) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (n < 0) {
            n = -1 * n;
        }
        int n2 = n / 60;
        int n3 = calendar.get(11);
        int n4 = (n3 + n2) / 24;
        calendar.set(11, (n3 + n2) % 24);
        if (n4 > 0) {
            calendar.set(5, calendar.get(5) + n4);
        }
        calendar.set(12, n % 60);
        return calendar.getTime();
    }

    public static Date round2Minute(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date roundNice(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int n = calendar.get(12);
        int n2 = n / 15;
        n = n2 * 15;
        calendar.set(12, n);
        return calendar.getTime();
    }

    public static int getDayOfWeek(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static String getWeekday(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEEE", Locale.getDefault());
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        return simpleDateFormat.format(date);
    }

    public static int getHourOfDay(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMinuteOfHour(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static TimeOfDay getTimeOfDay(Date date) {
        return new TimeOfDay(date.getTime() - DateUtil.round2Day(date).getTime());
    }

    public static Date getStartOfWeek(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.set(7, calendar.getFirstDayOfWeek());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date setDayOfWeek(Date date, int n) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.set(7, n);
        return calendar.getTime();
    }

    public static int getYear(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        return calendar.get(2);
    }

    public static int getDayOfMonth(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getDayOfYear(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        return calendar.get(6);
    }

    public static Date getDiffDay(Date date, int n) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.add(7, n);
        return calendar.getTime();
    }

    public static Date move(Date date, int n) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    public static Date moveByMinute(Date date, int n) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.add(12, n);
        return calendar.getTime();
    }

    public static Date moveByYear(Date date, int n) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.add(1, n);
        return calendar.getTime();
    }

    public static Date move2Midnight(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date move2Morning(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static long getDiffDay(Date date, Date date2) {
        long l = 0L;
        l = date2.getTime() > date.getTime() ? date2.getTime() - date.getTime() : -1L * (date.getTime() - date2.getTime());
        return l;
    }

    public static List<Date> getDayRange(Date date, Date date2) {
        ArrayList<Date> arrayList = new ArrayList<Date>(0);
        if (date == null || date2 == null) {
            return arrayList;
        }
        arrayList.add(date);
        Date date3 = DateUtil.round2Day(date2);
        Date date4 = date;
        while (date4.before(date3)) {
            arrayList.add(DateUtil.getDiffDay(date4, 1));
            date4 = DateUtil.round2Day(DateUtil.getDiffDay(date4, 1));
        }
        arrayList.add(date2);
        return arrayList;
    }

    public static int getDiffDay(int n, int n2) {
        if (n > n2) {
            n2 += 7;
        }
        return n2 - n + 1;
    }

    public static long getDiffMinutes(Date date, Date date2) {
        return date2.getTime() / 60000L - date.getTime() / 60000L;
    }

    public static int getMinutesOfRestDay(Date date) {
        if (date == null) {
            return 0;
        }
        int n = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n2 = gregorianCalendar.get(12);
        int n3 = gregorianCalendar.get(11);
        n = 60 - n2;
        int n4 = 23 - n3;
        return n += n4 * 60;
    }

    public static int getMinutesOfDay(Date date) {
        if (date == null) {
            return 0;
        }
        long l = DateUtil.getDiffMinutes(DateUtil.move2Morning(date), date);
        return (int)l;
    }

    public static boolean isSameDayOfYear(Date date, Date date2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        return gregorianCalendar.get(6) == gregorianCalendar2.get(6);
    }

    public static boolean isSameDay(Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        return gregorianCalendar.get(6) == gregorianCalendar2.get(6) && gregorianCalendar.get(1) == gregorianCalendar2.get(1);
    }

    public static boolean isSameWeek(Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        return gregorianCalendar.get(3) == gregorianCalendar2.get(3) && gregorianCalendar.get(1) == gregorianCalendar2.get(1);
    }

    public static boolean isSameMonth(Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        return gregorianCalendar.get(2) == gregorianCalendar2.get(2) && gregorianCalendar.get(1) == gregorianCalendar2.get(1);
    }

    public static boolean isSameYear(Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        return gregorianCalendar.get(1) == gregorianCalendar2.get(1);
    }

    public static boolean isBeforeDay(Date date, Date date2) {
        int n;
        int n2 = DateUtil.getDayOfYear(date);
        int n3 = DateUtil.getDayOfYear(date2);
        int n4 = DateUtil.getYear(date);
        if (n4 < (n = DateUtil.getYear(date2))) {
            return true;
        }
        if (n4 > n) {
            return false;
        }
        return n2 < n3;
    }

    public static int getDateDiff(Date date, Date date2) {
        long l = Math.abs(DateUtil.getDaylightSavingOffset(date)) - Math.abs(DateUtil.getDaylightSavingOffset(date2));
        return (int)((date.getTime() - date2.getTime() + l) / 24L / 3600L / 1000L);
    }

    public static Date setTimeOfDate(Date date, TimeOfDay timeOfDay) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.set(11, timeOfDay.getHour());
        calendar.set(12, timeOfDay.getMinute());
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date round2Week(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.set(7, calendar.getFirstDayOfWeek());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date round2Month(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date[] createDateList(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 60) {
            n = 60;
        }
        try {
            Calendar calendar = DateUtil.newCalendar();
            calendar.set(5, 0);
            calendar.set(2, 0);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            int n2 = 1440 / n;
            Date[] dateArray = new Date[n2];
            int n3 = 60 / n;
            int n4 = 1;
            for (int i = 0; i < n2; ++i) {
                dateArray[i] = calendar.getTime();
                calendar.roll(12, n);
                if (n4 == n3) {
                    calendar.roll(11, 1);
                    n4 = 0;
                }
                ++n4;
            }
            return dateArray;
        }
        catch (Exception exception) {
            LOGGER.error("Can't create date list.");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public static Date createDate(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 0);
        calendar.set(2, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(n, n2);
        return calendar.getTime();
    }

    public static int extractAge(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date);
        int n = gregorianCalendar.get(1) - gregorianCalendar2.get(1);
        if (DateUtil.getDayOfYear(gregorianCalendar.getTime()) < DateUtil.getDayOfYear(date)) {
            --n;
        }
        return n;
    }

    public static boolean isDaylightSavingDay(Date date) {
        Date date2 = DateUtil.move2Morning(date);
        Date date3 = DateUtil.move2Midnight(date);
        return DateUtil.getDaylightSavingOffset(date2) != DateUtil.getDaylightSavingOffset(date3);
    }

    public static boolean isAfterDSTChange(Date date) {
        if (!DateUtil.isDaylightSavingDay(date)) {
            return false;
        }
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        int n = calendar.get(11);
        return n >= 3;
    }

    public static boolean isBeforeDSTChange(Date date) {
        if (!DateUtil.isDaylightSavingDay(date)) {
            return false;
        }
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        int n = calendar.get(11);
        return n <= 2;
    }

    public static long getDaylightSavingOffset(Date date) {
        Calendar calendar = DateUtil.newCalendar();
        calendar.setTime(date);
        return calendar.get(16);
    }

    public static long getDSTShiftHourOffset(Date date) {
        Date date2 = DateUtil.moveByMinute(date, -60);
        long l = Math.abs(DateUtil.getDaylightSavingOffset(date)) - Math.abs(DateUtil.getDaylightSavingOffset(date2));
        if (l != 0L) {
            return l;
        }
        Date date3 = DateUtil.moveByMinute(date, 60);
        long l2 = Math.abs(DateUtil.getDaylightSavingOffset(date3)) - Math.abs(DateUtil.getDaylightSavingOffset(date));
        return l2;
    }

    public static Calendar newCalendar() {
        return calFactory.newCalendar();
    }

    public static void setCalendarFactory(CalendarFactory calendarFactory) {
        calFactory = calendarFactory;
    }

    private static class DefaultCalendarFactory
    implements CalendarFactory {
        private DefaultCalendarFactory() {
        }

        @Override
        public Calendar newCalendar() {
            Calendar calendar = Calendar.getInstance(Locale.getDefault());
            calendar.setTimeZone(TimeZone.getDefault());
            return calendar;
        }
    }
}

