/*
 * Decompiled with CFR 0.152.
 */
package bizcal.web;

import bizcal.common.Calendar;
import bizcal.common.DayViewConfig;
import bizcal.common.Event;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.NullSafe;
import bizcal.util.TimeOfDay;
import bizcal.util.Tuple;
import bizcal.web.CalendarView;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.ecs.Element;
import org.apache.ecs.html.B;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.Font;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TH;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.ecs.wml.Img;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class DayView
extends CalendarView {
    private static final I18n I18N = I18nFactory.getI18n(DayView.class);

    @Override
    public Element getContent() throws Exception {
        Object object;
        int n;
        this.getCalendarCallback().refresh();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM-dd");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm");
        simpleDateFormat2.setTimeZone(TimeZone.getDefault());
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("HH");
        simpleDateFormat3.setTimeZone(TimeZone.getDefault());
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("mm");
        simpleDateFormat4.setTimeZone(TimeZone.getDefault());
        long l = this.getResolution();
        Table table = new Table();
        table.setWidth("100%");
        Table table2 = new Table();
        table2.setCellPadding(0);
        table2.setCellSpacing(0);
        table.addElement((Element)new TR((Element)new TD((Element)table2)));
        TR tR = new TR();
        table2.addElement((Element)tR);
        Table table3 = new Table();
        table3.setCellSpacing(1);
        table3.setCellPadding(2);
        table3.setWidth("100%");
        table3.setClass("border");
        TR tR2 = new TR();
        tR2.addElement((Element)new TD((Element)table3));
        table.addElement((Element)tR2);
        List list = this.getCalendarCallback().getCalendars();
        TR tR3 = this.createHeaderRow();
        table3.addElement((Element)tR3);
        TH tH = this.createHeaderCell(I18N.tr("time"));
        tH.setColSpan(2);
        tR3.addElement((Element)tH);
        TR tR4 = this.createHeaderRow();
        TH tH2 = new TH();
        tH2.setColSpan(2);
        tR4.addElement((Element)tH2);
        if (this.getDayCount() > 1) {
            table3.addElement((Element)tR4);
        }
        int n2 = list.size() + 1;
        HashMap<Tuple, Object> hashMap = new HashMap<Tuple, Object>();
        for (Calendar calendar : list) {
            Object object2;
            BufferedImage bufferedImage = calendar.getImage();
            if (bufferedImage == null) {
                tH2 = this.createHeaderCell(calendar.getSummary());
            } else {
                object2 = new Img();
                object2.setSrc("image?table=resource&column=image&key=" + calendar.getId());
                tH2 = new TH((Element)object2);
                tH2.addElement((Element)new BR());
                tH2.addElement(calendar.getSummary());
                tR3.setClass("bgcolor2");
                ((Font)tH.elements().nextElement()).setColor("#000000");
            }
            tH2.setWidth("" + 100 / (n2 - 1) + "%");
            tH2.setColSpan(this.getDayCount());
            tR3.addElement((Element)tH2);
            object2 = this.getModel().getEvents(calendar.getId());
            Date date = this.getInterval().getStartDate();
            for (n = 0; n < this.getDayCount(); ++n) {
                tH2 = this.createHeaderCell(simpleDateFormat.format(date));
                tR4.addElement((Element)tH2);
                object = this.createSlots((List)object2, this.getInterval(date));
                hashMap.put(new Tuple(calendar.getId(), (Object)DateUtil.round2Day(date)), object);
                date = DateUtil.getDiffDay(date, 1);
            }
        }
        long l2 = 3600000L / l;
        int n3 = 0;
        n = 0;
        object = this.getModel().getViewStart();
        TimeOfDay timeOfDay = this.getModel().getViewEnd();
        for (long i = ((TimeOfDay)object).getValue(); i < timeOfDay.getValue(); i += l) {
            Calendar calendar;
            tR = new TR();
            table3.addElement((Element)tR);
            TimeOfDay timeOfDay2 = new TimeOfDay(i);
            Date date = timeOfDay2.getDate(this.getInterval().getStartDate());
            if (n == 0) {
                calendar = new TD((Element)new B(simpleDateFormat3.format(date)));
                calendar.setBgColor("#FFFFFF");
                tR.addElement((Element)calendar);
                calendar.setRowSpan((int)l2);
                calendar.setVAlign("center");
            }
            calendar = new TD(simpleDateFormat4.format(date));
            calendar.setBgColor("#FFFFFF");
            tR.addElement((Element)calendar);
            for (Calendar calendar2 : list) {
                Date date2 = this.getInterval().getStartDate();
                for (int j = 0; j < this.getDayCount(); ++j) {
                    Event event;
                    Date date3 = timeOfDay2.getDate(date2);
                    DateInterval dateInterval = this.getInterval(date2);
                    Tuple tuple = new Tuple(calendar2.getId(), (Object)DateUtil.round2Day(date2));
                    List list2 = (List)hashMap.get(tuple);
                    Event event2 = null;
                    if (n3 > 0) {
                        event2 = (Event)list2.get(n3 - 1);
                    }
                    if ((event = (Event)list2.get(n3)) != null) {
                        if (!NullSafe.equals(event, event2) || event.isBackground()) {
                            tR.addElement((Element)this.createCell(event, dateInterval, calendar2, date3));
                        }
                    } else {
                        tR.addElement((Element)this.createFreeCell(calendar2, date3));
                    }
                    date2 = DateUtil.getDiffDay(date2, 1);
                }
            }
            ++n3;
            if ((long)(++n) < l2) continue;
            n = 0;
        }
        return table;
    }

    private int getDayCount() {
        return this.getDesc().getDayCount();
    }

    private DateInterval getInterval(Date date) throws Exception {
        return new DateInterval(this.getModel().getViewStart().getDate(date), this.getModel().getViewEnd().getDate(date));
    }

    @Override
    public void setStartDate(Date date) throws Exception {
        Comparable<java.util.Calendar> comparable;
        if (this.getDayCount() == 7) {
            comparable = java.util.Calendar.getInstance(Locale.getDefault());
            comparable.setTime(date);
            comparable.set(7, comparable.getFirstDayOfWeek());
            date = comparable.getTime();
        }
        comparable = new Date(date.getTime() + (long)this.getDayCount() * 24L * 3600L * 1000L);
        this.setInterval(new DateInterval(date, (Date)comparable));
    }

    private DayViewConfig getDesc() {
        return (DayViewConfig)this.getConfig();
    }
}

