/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.bizcal;

import bizcal.common.Event;
import bizcal.swing.CalendarListener;
import bizcal.swing.DayView;
import bizcal.swing.util.FrameArea;
import bizcal.util.DateInterval;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import lu.tudor.santec.bizcal.CalendarIcons;
import lu.tudor.santec.bizcal.CalendarPanel;
import lu.tudor.santec.bizcal.EventModel;
import lu.tudor.santec.bizcal.NamedCalendar;
import lu.tudor.santec.bizcal.listeners.NamedCalendarListener;
import lu.tudor.santec.bizcal.util.ObservableEventList;
import lu.tudor.santec.bizcal.views.DayViewPanel;
import lu.tudor.santec.bizcal.views.ListViewPanel;
import lu.tudor.santec.bizcal.views.MonthViewPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarDemo
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarDemo.class);
    private ObservableEventList eventDataList;
    private DayViewPanel dayViewPanel;
    private DayViewPanel weekViewPanel;
    private MonthViewPanel monthViewPanel;
    private ListViewPanel listViewPanel;
    private CalendarPanel calendarPanel = new CalendarPanel();
    private DayViewPanel dayThreeViewPanel;

    public CalendarDemo() {
        super("Calendar Demo");
        this.eventDataList = new ObservableEventList();
        EventModel eventModel = new EventModel(this.eventDataList, 1);
        EventModel eventModel2 = new EventModel(this.eventDataList, 2);
        EventModel eventModel3 = new EventModel(this.eventDataList, 3);
        EventModel eventModel4 = new EventModel(this.eventDataList, 3);
        EventModel eventModel5 = new EventModel(this.eventDataList, 4);
        this.dayViewPanel = new DayViewPanel(eventModel, 1);
        this.dayThreeViewPanel = new DayViewPanel(eventModel5, 1);
        this.weekViewPanel = new DayViewPanel(eventModel2, 1);
        this.monthViewPanel = new MonthViewPanel(eventModel3);
        this.listViewPanel = new ListViewPanel(eventModel4);
        DemoCalendarListener demoCalendarListener = new DemoCalendarListener();
        this.dayViewPanel.addCalendarListener(demoCalendarListener);
        this.dayThreeViewPanel.addCalendarListener(demoCalendarListener);
        this.weekViewPanel.addCalendarListener(demoCalendarListener);
        this.monthViewPanel.addCalendarListener(demoCalendarListener);
        this.listViewPanel.addCalendarListener(demoCalendarListener);
        this.calendarPanel.addCalendarView(this.dayViewPanel);
        this.calendarPanel.addCalendarView(this.dayThreeViewPanel);
        this.calendarPanel.addCalendarView(this.weekViewPanel);
        this.calendarPanel.addCalendarView(this.monthViewPanel);
        this.calendarPanel.addCalendarView(this.listViewPanel);
        this.calendarPanel.addNamedCalendar(new TestNamedCalendar("Peter", "dem Peter seiner", Color.RED));
        this.calendarPanel.addNamedCalendar(new TestNamedCalendar("Max", "dem Max seiner", Color.BLUE));
        this.calendarPanel.addNamedCalendar(new TestNamedCalendar("Office", "allen ihrer", Color.GRAY));
        this.calendarPanel.addNamedCalendarListener(new NamedCalendarListener(){

            @Override
            public void activeCalendarsChanged(Collection<NamedCalendar> collection) {
                if (collection == null || collection.size() < 1) {
                    CalendarDemo.this.eventDataList.clear();
                    return;
                }
                CalendarDemo.this.updateEventsForActiveCalendars();
            }

            @Override
            public void selectedCalendarChanged(NamedCalendar namedCalendar) {
                CalendarDemo.this.updateEventsForActiveCalendars();
            }
        });
        AbstractAction abstractAction = new AbstractAction("0", CalendarIcons.getMediumIcon(CalendarIcons.CHANGE_LAYOUT_MODE)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOGGER.debug("### layout mode 0 ###");
                DayView dayView = (DayView)CalendarDemo.this.calendarPanel.getCurrentView().getView();
                dayView.setLayoutMode(0);
                try {
                    dayView.refresh0();
                }
                catch (Exception exception) {
                    LOGGER.error("Can't refresh view for layout mode 0.");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        };
        this.calendarPanel.getFunctionsButtonPanel().addAction(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction("1", CalendarIcons.getMediumIcon(CalendarIcons.CHANGE_LAYOUT_MODE)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOGGER.debug("### layout mode 1 ###");
                DayView dayView = (DayView)CalendarDemo.this.calendarPanel.getCurrentView().getView();
                dayView.setLayoutMode(1);
                try {
                    dayView.refresh0();
                }
                catch (Exception exception) {
                    LOGGER.error("Can't refresh view for layout mode 1.");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        };
        this.calendarPanel.getFunctionsButtonPanel().addAction(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction("2", CalendarIcons.getMediumIcon(CalendarIcons.CHANGE_LAYOUT_MODE)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOGGER.debug("### layout mode 2 ###");
                DayView dayView = (DayView)CalendarDemo.this.calendarPanel.getCurrentView().getView();
                dayView.setLayoutMode(2);
                try {
                    dayView.refresh0();
                }
                catch (Exception exception) {
                    LOGGER.error("Can't refresh view for layout mode 2.");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        };
        this.calendarPanel.getFunctionsButtonPanel().addAction(abstractAction3);
        this.add(this.calendarPanel);
        this.setDefaultCloseOperation(3);
        this.setSize(1000, 700);
        this.setVisible(true);
    }

    private synchronized void updateEventsForActiveCalendars() {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        for (NamedCalendar namedCalendar : this.calendarPanel.getCalendars()) {
            if (!namedCalendar.isActive() && !namedCalendar.isSelected()) continue;
            arrayList.addAll(namedCalendar.getEvents(null, null));
        }
        Collections.sort(arrayList);
        this.eventDataList.clear();
        this.eventDataList.addAll((Collection<? extends Event>)arrayList);
    }

    public static void main(String[] stringArray) {
        new CalendarDemo();
    }

    class TestNamedCalendar
    extends NamedCalendar {
        private List<Event> calendarEvents;

        public TestNamedCalendar(String string, String string2, Color color) {
            super(string, string2, color);
            this.calendarEvents = new ArrayList<Event>();
            this.setId(this.hashCode());
        }

        @Override
        public List<Event> getEvents(Date date, Date date2) {
            return this.calendarEvents;
        }

        @Override
        public void deleteEvent(String string, Event event) {
            this.calendarEvents.remove(event);
            CalendarDemo.this.eventDataList.remove(event);
        }

        @Override
        public List<Event> addEvent(String string, Event event) {
            event.set("calendarId", this.getId());
            event.set("calendarIsBackground", this.isBackground());
            event.setColor(this.getColor());
            CalendarDemo.this.eventDataList.add(event);
            this.calendarEvents.add(event);
            return null;
        }

        @Override
        public List<Event> saveEvent(String string, Event event, boolean bl) {
            return null;
        }
    }

    class DemoCalendarListener
    implements CalendarListener {
        DemoCalendarListener() {
        }

        @Override
        public void closeCalendar(Object object) throws Exception {
        }

        @Override
        public void copy(List<Event> list) throws Exception {
        }

        @Override
        public void dateChanged(Date date) throws Exception {
        }

        @Override
        public void dateSelected(Date date) throws Exception {
        }

        @Override
        public void deleteEvent(Event event) throws Exception {
            CalendarDemo.this.eventDataList.remove(event);
        }

        @Override
        public void deleteEvents(List<Event> list) {
            CalendarDemo.this.eventDataList.removeAll(list);
        }

        @Override
        public void eventClicked(Object object, Event event, FrameArea frameArea, MouseEvent mouseEvent) {
        }

        @Override
        public void eventDoubleClick(Object object, Event event, MouseEvent mouseEvent) {
        }

        @Override
        public void eventSelected(Object object, Event event) throws Exception {
            if (CalendarDemo.this.calendarPanel.getCalendars() == null) {
                return;
            }
            for (NamedCalendar namedCalendar : CalendarDemo.this.calendarPanel.getCalendars()) {
                namedCalendar.setSelected(false);
                namedCalendar.removeBorder();
                if (!namedCalendar.getId().equals(event.get("calendarId"))) continue;
                CalendarDemo.this.calendarPanel.setSelectedCalendar(namedCalendar);
                namedCalendar.setSelected(true);
                namedCalendar.addBorder();
            }
        }

        @Override
        public void eventsSelected(List<Event> list) throws Exception {
        }

        @Override
        public void moved(Event event, Object object, Date date, Object object2, Date date2) throws Exception {
            event.move(date2);
            CalendarDemo.this.eventDataList.trigger();
        }

        @Override
        public void newCalendar() throws Exception {
        }

        @Override
        public void newEvent(Object object, Date date) throws Exception {
            DateInterval dateInterval = new DateInterval(date, new Date(date.getTime() + 900000L));
            this.newEvent(object, dateInterval);
        }

        @Override
        public void newEvent(Object object, DateInterval dateInterval) throws Exception {
            NamedCalendar namedCalendar = CalendarDemo.this.calendarPanel.getSelectedCalendar();
            if (namedCalendar == null) {
                return;
            }
            Event event = new Event();
            event.setStart(dateInterval.getStartDate());
            event.setEnd(dateInterval.getEndDate());
            event.setId(object);
            namedCalendar.addEvent("clientXXX", event);
        }

        @Override
        public void paste(Object object, Date date) throws Exception {
        }

        @Override
        public void resized(Event event, Object object, Date date, Date date2) throws Exception {
            NamedCalendar namedCalendar = CalendarDemo.this.calendarPanel.getSelectedCalendar();
            if (namedCalendar == null) {
                return;
            }
            event.setEnd(date2);
            namedCalendar.saveEvent("clientXXX", event, false);
        }

        @Override
        public void selectionReset() throws Exception {
        }

        @Override
        public void showEvent(Object object, Event event) throws Exception {
        }
    }
}

