/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingOutputStream
extends OutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingOutputStream.class);
    protected static final String LINE_SEPARATOR = System.lineSeparator();
    protected boolean hasBeenClosed = false;
    protected byte[] buf;
    protected int count;
    private int bufLength;
    public static final int DEFAULT_BUFFER_LENGTH = 2048;
    protected Logger logger;
    protected Priority priority;
    protected String prefix;

    private LoggingOutputStream() {
    }

    public LoggingOutputStream(Logger logger, Priority priority) throws IllegalArgumentException {
        this(logger, priority, null);
    }

    public LoggingOutputStream(Logger logger, Priority priority, String string) throws IllegalArgumentException {
        if (logger == null) {
            throw new IllegalArgumentException("cat == null");
        }
        if (priority == null) {
            throw new IllegalArgumentException("priority == null");
        }
        this.prefix = string;
        this.priority = priority;
        this.logger = logger;
        this.bufLength = 2048;
        this.buf = new byte[2048];
        this.count = 0;
    }

    @Override
    public void close() {
        this.flush();
        this.hasBeenClosed = true;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.hasBeenClosed) {
            throw new IOException("The stream has been closed.");
        }
        if (n == 0) {
            return;
        }
        if (this.count == this.bufLength) {
            int n2 = this.bufLength + 2048;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buf, 0, byArray, 0, this.bufLength);
            this.buf = byArray;
            this.bufLength = n2;
        }
        this.buf[this.count] = (byte)n;
        ++this.count;
    }

    @Override
    public void flush() {
        if (this.count == 0) {
            return;
        }
        if (this.count == LINE_SEPARATOR.length() && (char)this.buf[0] == LINE_SEPARATOR.charAt(0) && (this.count == 1 || this.count == 2 && (char)this.buf[1] == LINE_SEPARATOR.charAt(1))) {
            this.reset();
            return;
        }
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        try {
            String string = "";
            if (this.prefix != null) {
                string = string + this.prefix;
            }
            string = string + new String(byArray, "UTF-8").trim();
            this.priority.log(this.logger, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Can't flush logger!");
            unsupportedEncodingException.printStackTrace(System.err);
        }
        this.reset();
    }

    private void reset() {
        this.count = 0;
    }

    public static enum Priority {
        TRACE,
        DEBUG,
        INFO,
        WARNING,
        ERROR;


        public void log(Logger logger, String string) {
            switch (this) {
                case ERROR: {
                    logger.error(string);
                    break;
                }
                case WARNING: {
                    logger.warn(string);
                    break;
                }
                case INFO: {
                    logger.info(string);
                    break;
                }
                case DEBUG: {
                    logger.debug(string);
                    break;
                }
                default: {
                    logger.trace(string);
                }
            }
        }
    }
}

