/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.core.ssl;

import com.openindex.openestate.tool.core.ssl.SSLUtils;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.naming.InvalidNameException;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackTrustManager
implements X509TrustManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallbackTrustManager.class);
    private final Callback callback;
    private final KeyStore customTrustStore;
    private final char[] customTrustStorePassword;
    private X509TrustManager customTrustManager;
    private X509TrustManager systemTrustManager = SSLUtils.getDefaultTrustManager();

    public CallbackTrustManager(Callback callback) {
        this(null, null, callback);
    }

    public CallbackTrustManager(KeyStore keyStore, char[] cArray, Callback callback) {
        this.customTrustStore = keyStore;
        this.customTrustStorePassword = cArray;
        if (keyStore != null) {
            this.customTrustManager = SSLUtils.getCustomTrustManager(keyStore);
        }
        this.callback = callback;
    }

    @Override
    public synchronized void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        block5: {
            try {
                this.systemTrustManager.checkClientTrusted(x509CertificateArray, string);
            }
            catch (CertificateException certificateException) {
                if (this.customTrustManager == null) {
                    throw certificateException;
                }
                try {
                    this.customTrustManager.checkClientTrusted(x509CertificateArray, string);
                }
                catch (CertificateException certificateException2) {
                    if (this.callback != null && this.callback.canImport(this, x509CertificateArray[0])) break block5;
                    throw certificateException2;
                }
            }
        }
    }

    @Override
    public synchronized void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        block7: {
            try {
                this.systemTrustManager.checkServerTrusted(x509CertificateArray, string);
            }
            catch (CertificateException certificateException) {
                if (this.customTrustManager == null) {
                    throw certificateException;
                }
                if (!SSLUtils.hasTrustedCertificates(this.customTrustStore)) {
                    if (this.callback == null || !this.callback.canImport(this, x509CertificateArray[0])) {
                        throw certificateException;
                    }
                    return;
                }
                try {
                    this.customTrustManager.checkServerTrusted(x509CertificateArray, string);
                }
                catch (CertificateException certificateException2) {
                    if (this.callback != null && this.callback.canImport(this, x509CertificateArray[0])) break block7;
                    throw certificateException2;
                }
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(Arrays.asList(this.systemTrustManager.getAcceptedIssuers()));
        if (this.customTrustManager != null) {
            arrayList.addAll(Arrays.asList(this.customTrustManager.getAcceptedIssuers()));
        }
        return arrayList.toArray(new X509Certificate[0]);
    }

    public synchronized void registerCertificate(X509Certificate x509Certificate) throws InvalidNameException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        if (this.customTrustStore != null) {
            SSLUtils.addCertificate(this.customTrustStore, x509Certificate);
            SSLUtils.saveKeyStore(this.customTrustStore, SSLUtils.getCustomTrustStoreFile(), this.customTrustStorePassword);
            this.customTrustManager = SSLUtils.getCustomTrustManager(this.customTrustStore);
        }
    }

    public static interface Callback {
        public boolean canImport(CallbackTrustManager var1, X509Certificate var2);
    }
}

