/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.tool.server;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.ServerConfiguration;
import org.openestate.tool.server.ServerProperties;
import org.openestate.tool.server.utils.MigrationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Server
extends org.hsqldb.Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    private static final I18n I18N = I18nFactory.getI18n(Server.class);
    public static final String TITLE = "OpenEstate-ImmoServer";
    private static final String SYSTEM_TRAY_PROPERTY = "openestate.server.systemTray";
    private static Server server = null;
    private static TrayIcon systemTrayIcon = null;

    protected Server() {
    }

    public static Server get() {
        return server;
    }

    private static void initSystemTray() {
        BufferedImage bufferedImage;
        if (!Server.isSystemTrayEnabled()) {
            return;
        }
        if (!SystemTray.isSupported()) {
            LOGGER.warn("The operating system does not support system tray.");
            return;
        }
        try {
            bufferedImage = ImageIO.read(Server.class.getResourceAsStream("/org/openestate/tool/server/resources/ImmoServer.png"));
        }
        catch (Exception exception) {
            LOGGER.error("Can't load icon for system tray!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return;
        }
        PopupMenu popupMenu = new PopupMenu();
        final MenuItem menuItem = new MenuItem(I18N.tr("shutdown {0}", (Object)TITLE));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                menuItem.setEnabled(false);
                server.stop();
            }
        });
        popupMenu.add(menuItem);
        systemTrayIcon = new TrayIcon(bufferedImage, TITLE, popupMenu);
        systemTrayIcon.setImageAutoSize(true);
        SystemTray systemTray = SystemTray.getSystemTray();
        try {
            systemTray.add(systemTrayIcon);
        }
        catch (AWTException aWTException) {
            LOGGER.error("Can't add icon to system tray!");
            LOGGER.error("> " + aWTException.getLocalizedMessage(), (Throwable)aWTException);
        }
    }

    public static boolean isSystemTrayEnabled() {
        String string = StringUtils.trimToNull((String)StringUtils.lowerCase((String)System.getProperty(SYSTEM_TRAY_PROPERTY, "false")));
        return "1".equals(string) || "true".equals(string);
    }

    public static void main(String[] stringArray) {
        String string;
        ServerProperties serverProperties;
        if (!SystemUtils.isJavaAwtHeadless()) {
            Server.initSystemTray();
        }
        try {
            InputStream inputStream = Server.class.getResourceAsStream("/server.properties");
            if (inputStream == null) {
                LOGGER.error("Can't find server configuration!");
                return;
            }
            serverProperties = ServerProperties.create(1, inputStream);
        }
        catch (Exception exception) {
            LOGGER.error("Can't load server configuration!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return;
        }
        ServerConfiguration.translateDefaultDatabaseProperty((HsqlProperties)serverProperties);
        ServerConfiguration.translateDefaultNoSystemExitProperty((HsqlProperties)serverProperties);
        ServerConfiguration.translateAddressProperty((HsqlProperties)serverProperties);
        server = new Server();
        try {
            server.setProperties((HsqlProperties)serverProperties);
        }
        catch (Exception exception) {
            server.printError("Failed to set properties!");
            server.printStackTrace(exception);
            return;
        }
        int n = 0;
        while ((string = server.getDatabasePath(n, true)) != null) {
            if (string.startsWith("file:")) {
                File file = new File(FilenameUtils.separatorsToSystem((String)StringUtils.substringAfter((String)string, (String)"file:"))).getParentFile();
                String string2 = StringUtils.substringAfterLast((String)string, (String)"/");
                LOGGER.info("Initializing database '" + file.getAbsolutePath() + "'.");
                try {
                    MigrationUtils.migrateFromOldDatabase(file, string2);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't migrate database at '" + file.getAbsolutePath() + "'!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            ++n;
        }
        server.start();
    }

    protected void print(String string) {
        LOGGER.info("[" + this.getServerId() + "]: " + string);
    }

    protected void printError(String string) {
        LOGGER.error(string);
    }

    protected void printStackTrace(Throwable throwable) {
        LOGGER.error(throwable.getLocalizedMessage(), throwable);
    }

    protected void printWithThread(String string) {
        super.printWithThread(string);
    }

    protected synchronized void setState(int n) {
        if (systemTrayIcon != null && this.getState() != n) {
            switch (n) {
                case 1: {
                    systemTrayIcon.displayMessage(TITLE, I18N.tr("{0} is available for incoming connections.", (Object)TITLE), TrayIcon.MessageType.INFO);
                    break;
                }
                case 8: {
                    systemTrayIcon.displayMessage(TITLE, I18N.tr("{0} is shutting down.", (Object)TITLE), TrayIcon.MessageType.INFO);
                    break;
                }
                case 4: {
                    systemTrayIcon.displayMessage(TITLE, I18N.tr("{0} is starting up.", (Object)TITLE), TrayIcon.MessageType.INFO);
                    break;
                }
                case 16: {
                    systemTrayIcon.displayMessage(TITLE, I18N.tr("{0} has been closed and is not available anymore.", (Object)TITLE), TrayIcon.MessageType.INFO);
                    break;
                }
            }
        }
        super.setState(n);
    }
}

