/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.boot.Boot;
import org.java.plugin.boot.ServiceApplication;

final class ControlThread
extends Thread {
    private Log log = LogFactory.getLog(this.getClass());
    private ServerSocket serverSocket;
    private final ServiceApplication application;
    private boolean appRunning;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isApplicationRunning(InetAddress host, int port) {
        try {
            Socket socket = new Socket(host, port);
            try {
                socket.setKeepAlive(true);
                String test = "" + System.currentTimeMillis();
                OutputStream out = socket.getOutputStream();
                InputStream in = null;
                try {
                    int len;
                    System.out.println("found running control service on " + host + ":" + port);
                    out.write(("PING " + test).getBytes());
                    out.flush();
                    socket.shutdownOutput();
                    in = socket.getInputStream();
                    StringBuilder commandResult = new StringBuilder();
                    byte[] buf = new byte[16];
                    while ((len = in.read(buf)) != -1) {
                        commandResult.append(new String(buf, 0, len));
                    }
                    socket.shutdownInput();
                    if (commandResult.toString().startsWith("OK") && commandResult.toString().indexOf(test) != -1) {
                        System.out.println("PING command succeed");
                        boolean bl = true;
                        return bl;
                    }
                    System.out.println("PING command failed");
                    return false;
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {}
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            finally {
                socket.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("seems that there is no control service running on " + host + ":" + port);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean stopRunningApplication(InetAddress host, int port) {
        boolean result = false;
        try {
            Socket socket = new Socket(host, port);
            try {
                socket.setKeepAlive(true);
                OutputStream out = socket.getOutputStream();
                InputStream in = null;
                try {
                    int len;
                    System.out.println("found running control service on " + host + ":" + port);
                    out.write("STOP".getBytes());
                    out.flush();
                    socket.shutdownOutput();
                    in = socket.getInputStream();
                    StringBuilder commandResult = new StringBuilder();
                    byte[] buf = new byte[16];
                    while ((len = in.read(buf)) != -1) {
                        commandResult.append(new String(buf, 0, len));
                    }
                    socket.shutdownInput();
                    if (commandResult.toString().startsWith("OK")) {
                        System.out.println("STOP command succeed");
                        result = true;
                    } else {
                        System.out.println("STOP command failed");
                    }
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {}
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            finally {
                socket.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("seems that there is no control service running on " + host + ":" + port);
        }
        if (result) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result;
    }

    ControlThread(InetAddress host, int port, ServiceApplication server) throws Exception {
        this.application = server;
        this.serverSocket = new ServerSocket(port, 1, host);
        this.appRunning = true;
        this.setName("jpf-application-control-thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block24: {
            while (true) {
                try {
                    try {
                        Socket clientSocket = this.serverSocket.accept();
                        try {
                            if (!this.handleRequest(clientSocket)) continue;
                            break block24;
                        }
                        finally {
                            try {
                                clientSocket.close();
                            }
                            catch (IOException ioe) {}
                        }
                    }
                    catch (Exception e) {
                        this.warn("error on server socket", e);
                        break block24;
                    }
                }
                catch (Exception e) {
                    this.error(e);
                    break block24;
                }
            }
            finally {
                try {
                    this.serverSocket.close();
                }
                catch (IOException ioe) {
                    this.warn("error closing server socket", ioe);
                }
                if (this.appRunning) {
                    this.stopApplication();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean handleRequest(Socket clientSocket) {
        this.debug("handling control request");
        if (!this.isValidRemoteHost(clientSocket.getInetAddress())) {
            this.warn("incoming connection to control socket registered from REMOTE address " + clientSocket.getInetAddress() + ", attempt to execute command was IGNORED");
            try {
                clientSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        this.debug("processing control request");
        boolean result = false;
        try {
            InputStream in = clientSocket.getInputStream();
            OutputStream out = null;
            try {
                String commandResult;
                int len;
                StringBuilder command = new StringBuilder();
                byte[] buf = new byte[16];
                while ((len = in.read(buf)) != -1) {
                    command.append(new String(buf, 0, len));
                }
                clientSocket.shutdownInput();
                this.debug("got command - " + command);
                if ("STOP".equals(command.toString())) {
                    this.stopApplication();
                    result = true;
                    commandResult = "OK: stop done";
                } else {
                    commandResult = command.toString().startsWith("PING") ? "OK: " + command.substring("PING".length()) : "ERROR: unknown command";
                }
                out = clientSocket.getOutputStream();
                out.write(commandResult.getBytes());
                out.flush();
                clientSocket.shutdownOutput();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        catch (IOException ioe) {
            this.error("error processing control request", ioe);
        }
        return result;
    }

    private void stopApplication() {
        if (!this.appRunning) {
            this.debug("application not running");
            return;
        }
        this.appRunning = false;
        this.debug("stopping application");
        try {
            Boot.stopApplication(this.application);
            this.log = null;
        }
        catch (Exception e) {
            this.error("an error has occurred while stopping application", e);
        }
        this.debug("application stopped from control thread");
    }

    private boolean isValidRemoteHost(InetAddress addr) {
        byte[] remoteAddr;
        byte[] localAddr = this.serverSocket.getInetAddress().getAddress();
        if (localAddr.length != (remoteAddr = addr.getAddress()).length) {
            return false;
        }
        for (int i = 0; i < remoteAddr.length; ++i) {
            if (localAddr[i] == remoteAddr[i]) continue;
            return false;
        }
        return true;
    }

    private void debug(String msg) {
        if (this.log != null) {
            this.log.debug((Object)msg);
        } else {
            System.out.println(msg);
        }
    }

    private void warn(String msg) {
        if (this.log != null) {
            this.log.warn((Object)msg);
        } else {
            System.out.println(msg);
        }
    }

    private void warn(String msg, Exception e) {
        if (this.log != null) {
            this.log.warn((Object)msg, (Throwable)e);
        } else {
            System.out.println(msg);
            e.printStackTrace();
        }
    }

    private void error(String msg, Exception e) {
        if (this.log != null) {
            this.log.error((Object)msg, (Throwable)e);
        } else {
            System.err.println(msg);
            e.printStackTrace();
        }
    }

    private void error(Exception e) {
        if (this.log != null) {
            this.log.error((Object)e);
        } else {
            e.printStackTrace();
        }
    }
}

