/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;

final class SplashWindow
extends Window {
    private static final long serialVersionUID = 7264517933349367876L;
    private static SplashWindow instance;
    private Image image;
    boolean paintCalled = false;

    private SplashWindow(Frame parent, Image anImage) {
        super(parent);
        this.image = anImage;
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int imgWidth = this.image.getWidth(this);
        int imgHeight = this.image.getHeight(this);
        this.setSize(imgWidth, imgHeight);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDim.width - imgWidth) / 2, (screenDim.height - imgHeight) / 2);
        MouseAdapter disposeOnClick = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent evt) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(disposeOnClick);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void splash(Image image) {
        if (instance == null && image != null) {
            Frame f = new Frame();
            instance = new SplashWindow(f, image);
            instance.setVisible(true);
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                SplashWindow splashWindow = instance;
                synchronized (splashWindow) {
                    while (!SplashWindow.instance.paintCalled) {
                        try {
                            instance.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    static void splash(URL imageURL) {
        if (imageURL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(imageURL));
        }
    }

    static void disposeSplash() {
        if (instance != null) {
            instance.getOwner().dispose();
            instance = null;
        }
    }
}

