/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.i18n;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class I18n {
    private static final File LANG_PACK_DIR = new File(System.getProperty("user.dir"), "languages");
    private static final String DEFAULT_BUNDLE_NAME = "messages";
    private static final String MNEM_POSTFIX = ".mnemonic";
    public static final Properties BUNDLE_PROPS = new Properties();
    public static final Map I18NS = new HashMap();
    public static Locale locale = Locale.getDefault();
    private ResourceBundle bundle;
    private String _package;

    private I18n(String string) {
        this._package = string;
    }

    public String str(String string) {
        try {
            if (this.bundle == null) {
                this.bundle = this.createBundle(I18n.getLocale());
            }
            return this.bundle.getString(string);
        }
        catch (Exception exception) {
            return '!' + string + '!';
        }
    }

    public String str(String string, Locale locale) {
        try {
            return this.createBundle(locale).getString(string);
        }
        catch (Exception exception) {
            return '!' + string + '!';
        }
    }

    public char mnem(String string) {
        String string2 = this.str(string + MNEM_POSTFIX);
        if (string2 != null && string2.length() > 0) {
            return string2.charAt(0);
        }
        return '!';
    }

    public char mnem(String string, Locale locale) {
        String string2 = this.str(string + MNEM_POSTFIX, locale);
        if (string2 != null && string2.length() > 0) {
            return string2.charAt(0);
        }
        return '!';
    }

    private ResourceBundle createBundle(Locale locale) {
        String string = I18n.getBundleForPackage(this._package);
        File[] fileArray = I18n.getAvailableLanguagePacks();
        if (fileArray != null && fileArray.length > 0) {
            URL[] uRLArray = new URL[fileArray.length];
            try {
                for (int i = 0; i < uRLArray.length; ++i) {
                    uRLArray[i] = fileArray[i].toURL();
                }
                return ResourceBundle.getBundle(string, locale, URLClassLoader.newInstance(uRLArray));
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return ResourceBundle.getBundle(string, locale);
    }

    public static I18n getInstance(String string) {
        I18n i18n = (I18n)I18NS.get(string);
        if (i18n == null) {
            i18n = new I18n(string);
            I18NS.put(string, i18n);
        }
        return i18n;
    }

    public static void setLocale(Locale locale) {
        I18n.locale = locale;
        for (I18n i18n : I18NS.values()) {
            i18n.bundle = null;
        }
    }

    public static void setLocale(String string) throws IllegalArgumentException {
        Locale locale = I18n.localeFromString(string);
        if (locale == null) {
            throw new IllegalArgumentException("The locale " + string + " was not properly formatted");
        }
        I18n.setLocale(locale);
    }

    public static Locale getLocale() {
        if (locale == null) {
            Locale.getDefault();
        }
        return locale;
    }

    private static String slashesToDots(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(".");
            stringBuffer.append(stringTokenizer.nextToken());
        }
        if (stringBuffer.toString().startsWith(".")) {
            stringBuffer.deleteCharAt(0);
        }
        return stringBuffer.toString();
    }

    private static String createBundleName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(I18n.slashesToDots(string));
        if (!stringBuffer.toString().endsWith(".")) {
            stringBuffer.append('.');
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static void setBundleForPackage(String string, String string2) {
        if (string2 == null) {
            BUNDLE_PROPS.remove(string);
        } else {
            BUNDLE_PROPS.setProperty(string, string2);
        }
        I18n i18n = (I18n)I18NS.get(string);
        if (i18n != null) {
            i18n.bundle = null;
        }
    }

    public static String getBundleForPackage(String string) {
        String string2 = BUNDLE_PROPS.getProperty(string);
        if (string2 == null) {
            string2 = I18n.createBundleName(string, DEFAULT_BUNDLE_NAME);
        }
        return string2;
    }

    public static File getLanguagePackDirectory() {
        return LANG_PACK_DIR;
    }

    public static File[] getAvailableLanguagePacks() {
        Locale[] localeArray = I18n.getAvailableLanguagePackLocales();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < localeArray.length; ++i) {
            String string = localeArray[i].toString() + ".zip";
            File file = new File(LANG_PACK_DIR, string);
            if (!file.isFile() || !file.canRead()) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static Locale[] getAvailableLanguagePackLocales() {
        File[] fileArray;
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        File file = I18n.getLanguagePackDirectory();
        if (file.isDirectory() && file.canRead() && (fileArray = file.listFiles(new ZipFileFilter())) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string;
                Locale locale;
                String string2 = fileArray[i].getName();
                int n = string2.lastIndexOf(".");
                if (n == -1 || (locale = I18n.localeFromString(string = string2.substring(0, n))) == null) continue;
                arrayList.add(locale);
            }
        }
        return arrayList.toArray(new Locale[arrayList.size()]);
    }

    public static Locale localeFromString(String string) {
        String[] stringArray = string.split("_");
        if (stringArray.length > 0 || stringArray.length <= 3) {
            String string2 = stringArray[0];
            String string3 = stringArray.length > 1 ? stringArray[1] : "";
            String string4 = stringArray.length > 2 ? stringArray[2] : "";
            return new Locale(string2, string3, string4);
        }
        return null;
    }

    private static class ZipFileFilter
    implements FileFilter {
        private ZipFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            String string;
            return file.isFile() && file.canRead() && (string = file.getName().toLowerCase()).endsWith(".zip");
        }
    }
}

