/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.UIUtils;

public class TextEditPopupManager {
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text");
    private static TextEditPopupManager singleton = null;
    public static final String CUT = "cut";
    public static final String COPY = "copy";
    public static final String PASTE = "paste";
    public static final String SELECT_ALL = "selectAll";
    public static final String UNDO = "undo";
    public static final String REDO = "redo";
    private HashMap actions = new HashMap();
    private Action cut = new DefaultEditorKit.CutAction();
    private Action copy = new DefaultEditorKit.CopyAction();
    private Action paste = new DefaultEditorKit.PasteAction();
    private Action selectAll = new NSelectAllAction();
    private Action undo = new UndoAction();
    private Action redo = new RedoAction();
    private List textComps = new Vector();
    private List undoers = new Vector();
    private JTextComponent focusedComp;
    private UndoManager undoer;
    private FocusListener focusHandler = new PopupFocusHandler();
    private MouseListener popupHandler = new PopupHandler();
    private UndoListener undoHandler = new UndoListener();
    private CaretListener caretHandler = new CaretHandler();
    private JPopupMenu popup = new JPopupMenu();

    private TextEditPopupManager() {
        this.cut.putValue("Name", i18n.str(CUT));
        this.cut.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "cut.png"));
        this.copy.putValue("Name", i18n.str(COPY));
        this.copy.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "copy.png"));
        this.paste.putValue("Name", i18n.str(PASTE));
        this.paste.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "paste.png"));
        this.selectAll.putValue("AcceleratorKey", null);
        this.popup.add(this.undo);
        this.popup.add(this.redo);
        this.popup.addSeparator();
        this.popup.add(this.cut);
        this.popup.add(this.copy);
        this.popup.add(this.paste);
        this.popup.addSeparator();
        this.popup.add(this.selectAll);
        this.actions.put(CUT, this.cut);
        this.actions.put(COPY, this.copy);
        this.actions.put(PASTE, this.paste);
        this.actions.put(SELECT_ALL, this.selectAll);
        this.actions.put(UNDO, this.undo);
        this.actions.put(REDO, this.redo);
    }

    public static TextEditPopupManager getInstance() {
        if (singleton == null) {
            singleton = new TextEditPopupManager();
        }
        return singleton;
    }

    public Action getAction(String string) {
        return (Action)this.actions.get(string);
    }

    public void registerJTextComponent(JTextComponent jTextComponent) throws IllegalArgumentException {
        this.registerJTextComponent(jTextComponent, new UndoManager());
    }

    public void registerJTextComponent(JTextComponent jTextComponent, UndoManager undoManager) throws IllegalArgumentException {
        if (jTextComponent == null || undoManager == null) {
            throw new IllegalArgumentException("null arguments aren't allowed");
        }
        if (this.getIndexOfJTextComponent(jTextComponent) != -1) {
            throw new IllegalArgumentException("Component already registered");
        }
        jTextComponent.addFocusListener(this.focusHandler);
        jTextComponent.addCaretListener(this.caretHandler);
        jTextComponent.addMouseListener(this.popupHandler);
        jTextComponent.getDocument().addUndoableEditListener(this.undoHandler);
        this.textComps.add(new WeakReference<JTextComponent>(jTextComponent));
        this.undoers.add(undoManager);
    }

    public void unregisterJTextComponent(JTextComponent jTextComponent) {
        int n = this.getIndexOfJTextComponent(jTextComponent);
        if (n != -1) {
            jTextComponent.removeFocusListener(this.focusHandler);
            jTextComponent.removeCaretListener(this.caretHandler);
            jTextComponent.removeMouseListener(this.popupHandler);
            jTextComponent.getDocument().removeUndoableEditListener(this.undoHandler);
            this.textComps.remove(n);
            this.undoers.remove(n);
        }
    }

    protected int getIndexOfJTextComponent(JTextComponent jTextComponent) {
        for (int i = 0; i < this.textComps.size(); ++i) {
            WeakReference weakReference = (WeakReference)this.textComps.get(i);
            if (weakReference.get() != jTextComponent) continue;
            return i;
        }
        return -1;
    }

    private void clearEmptyReferences() {
        WeakReference weakReference;
        for (int i = 0; i < this.textComps.size(); ++i) {
            weakReference = (WeakReference)this.textComps.get(i);
            if (weakReference.get() != null) continue;
            this.undoers.set(i, null);
        }
        Iterator iterator = this.textComps.iterator();
        while (iterator.hasNext()) {
            weakReference = (WeakReference)iterator.next();
            if (weakReference.get() != null) continue;
            iterator.remove();
        }
        iterator = this.undoers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
    }

    private void updateActions() {
        if (this.focusedComp != null && this.focusedComp.hasFocus()) {
            this.undo.setEnabled(this.undoer.canUndo());
            this.redo.setEnabled(this.undoer.canRedo());
            boolean bl = this.focusedComp.getSelectedText() != null;
            this.copy.setEnabled(bl);
            this.cut.setEnabled(bl);
        }
    }

    private class PopupHandler
    extends MouseAdapter {
        private PopupHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.checkForPopupTrigger(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkForPopupTrigger(mouseEvent);
        }

        private void checkForPopupTrigger(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getComponent();
            if (mouseEvent.isPopupTrigger() && jTextComponent.isEditable()) {
                if (!jTextComponent.isFocusOwner()) {
                    jTextComponent.requestFocusInWindow();
                }
                TextEditPopupManager.this.popup.show(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            TextEditPopupManager.this.updateActions();
        }
    }

    private class PopupFocusHandler
    implements FocusListener {
        private PopupFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getComponent();
                int n = TextEditPopupManager.this.getIndexOfJTextComponent(jTextComponent);
                if (n != -1) {
                    TextEditPopupManager.this.undoer = (UndoManager)TextEditPopupManager.this.undoers.get(n);
                    TextEditPopupManager.this.focusedComp = jTextComponent;
                    TextEditPopupManager.this.updateActions();
                }
                TextEditPopupManager.this.clearEmptyReferences();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class NSelectAllAction
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public NSelectAllAction() {
            super(i18n.str("select_all"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem("select_all")));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getTextComponent(actionEvent).selectAll();
        }
    }

    private class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UndoAction() {
            super(i18n.str(TextEditPopupManager.UNDO), UIUtils.getIcon("resources/images/x16/", "undo.png"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem(TextEditPopupManager.UNDO)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (TextEditPopupManager.this.undoer != null) {
                    TextEditPopupManager.this.undoer.undo();
                    TextEditPopupManager.this.updateActions();
                }
            }
            catch (Exception exception) {
                System.out.println("Cannot Undo");
            }
        }
    }

    private class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RedoAction() {
            super(i18n.str(TextEditPopupManager.REDO), UIUtils.getIcon("resources/images/x16/", "redo.png"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem(TextEditPopupManager.REDO)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (TextEditPopupManager.this.undoer != null) {
                    TextEditPopupManager.this.undoer.redo();
                    TextEditPopupManager.this.updateActions();
                }
            }
            catch (Exception exception) {
                System.out.println("Cannot Redo");
            }
        }
    }

    private class UndoListener
    implements UndoableEditListener {
        private UndoListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            if (TextEditPopupManager.this.undoer != null) {
                TextEditPopupManager.this.undoer.addEdit(undoableEdit);
                TextEditPopupManager.this.updateActions();
            }
        }
    }
}

