/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.actions;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.HTMLUtils;
import net.atlanticbb.tantlinger.ui.text.actions.HTMLTextEditAction;
import net.atlanticbb.tantlinger.ui.text.dialogs.HyperlinkDialog;

public class HTMLLinkAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    private Set hiddenAttributes;

    public HTMLLinkAction() {
        this((Set)null);
    }

    public HTMLLinkAction(Set set) {
        super(i18n.str("hyperlink_"));
        this.putValue("MnemonicKey", new Integer(i18n.mnem("hyperlink_")));
        this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "link.png"));
        this.putValue("ShortDescription", this.getValue("Name"));
        this.hiddenAttributes = set;
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HyperlinkDialog hyperlinkDialog = this.createDialog(jEditorPane);
        if (hyperlinkDialog == null) {
            return;
        }
        hyperlinkDialog.setLocationRelativeTo(hyperlinkDialog.getParent());
        hyperlinkDialog.setLinkText(jEditorPane.getSelectedText());
        hyperlinkDialog.setVisible(true);
        if (hyperlinkDialog.hasUserCancelled()) {
            return;
        }
        jEditorPane.requestFocusInWindow();
        jEditorPane.replaceSelection(hyperlinkDialog.getHTML());
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HyperlinkDialog hyperlinkDialog = this.createDialog(jEditorPane);
        if (hyperlinkDialog == null) {
            return;
        }
        if (jEditorPane.getSelectedText() != null) {
            hyperlinkDialog.setLinkText(jEditorPane.getSelectedText());
        }
        hyperlinkDialog.setLocationRelativeTo(hyperlinkDialog.getParent());
        hyperlinkDialog.setVisible(true);
        if (hyperlinkDialog.hasUserCancelled()) {
            return;
        }
        String string = hyperlinkDialog.getHTML();
        if (jEditorPane.getSelectedText() == null) {
            string = string + "&nbsp;";
        }
        jEditorPane.replaceSelection("");
        HTMLUtils.insertHTML(string, HTML.Tag.A, jEditorPane);
        hyperlinkDialog = null;
    }

    protected HyperlinkDialog createDialog(JTextComponent jTextComponent) {
        Window window = SwingUtilities.getWindowAncestor(jTextComponent);
        HyperlinkDialog hyperlinkDialog = null;
        if (window != null && window instanceof Frame) {
            hyperlinkDialog = new HyperlinkDialog((Frame)window);
        } else if (window != null && window instanceof Dialog) {
            hyperlinkDialog = new HyperlinkDialog((Dialog)window);
        }
        if (hyperlinkDialog != null && this.hiddenAttributes != null) {
            hyperlinkDialog.setHiddenAttributes(this.hiddenAttributes);
        }
        return hyperlinkDialog;
    }
}

