/*
 * Decompiled with CFR 0.152.
 */
package bizcal.common;

import bizcal.common.Event;
import bizcal.util.BizcalException;
import bizcal.util.DateInterval;
import bizcal.util.DateUtil;
import bizcal.util.TimeOfDay;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public interface CalendarModel {
    public List<Event> getEvents(Object var1) throws Exception;

    public List getCalendars() throws Exception;

    public List getSelectedCalendars() throws Exception;

    public void refresh() throws Exception;

    public void deleteCalendar(Object var1) throws Exception;

    public long getResolution() throws Exception;

    public DateInterval getInterval() throws Exception;

    public List getColorDescriptions() throws Exception;

    public boolean isInsertable(Object var1, Date var2) throws Exception;

    public boolean isRedDay(Date var1) throws Exception;

    public TimeOfDay getViewStart() throws Exception;

    public TimeOfDay getViewEnd() throws Exception;

    public String getDateHeader(Object var1, Date var2) throws Exception;

    public String getDateFooter(Object var1, Date var2, List var3) throws Exception;

    public static abstract class BaseImpl
    implements CalendarModel {
        private int sunday = 1;
        private TimeOfDay viewStart;
        private TimeOfDay viewEnd;
        private DateInterval interval;

        public BaseImpl() {
            try {
                this.viewStart = new TimeOfDay(7, 0);
                this.viewEnd = new TimeOfDay(18, 0);
            }
            catch (Exception exception) {
                throw BizcalException.create(exception);
            }
        }

        @Override
        public List getCalendars() throws Exception {
            return new ArrayList();
        }

        @Override
        public List getSelectedCalendars() throws Exception {
            return new ArrayList();
        }

        @Override
        public void refresh() throws Exception {
        }

        @Override
        public void deleteCalendar(Object object) throws Exception {
        }

        @Override
        public long getResolution() {
            return 900000L;
        }

        @Override
        public List getColorDescriptions() throws Exception {
            return new ArrayList();
        }

        @Override
        public boolean isInsertable(Object object, Date date) throws Exception {
            return true;
        }

        @Override
        public boolean isRedDay(Date date) throws Exception {
            return DateUtil.getDayOfWeek(date) == this.sunday;
        }

        @Override
        public TimeOfDay getViewStart() throws Exception {
            return this.viewStart;
        }

        @Override
        public TimeOfDay getViewEnd() throws Exception {
            return this.viewEnd;
        }

        public void setViewStart(TimeOfDay timeOfDay) {
            this.viewStart = timeOfDay;
        }

        public void setViewEnd(TimeOfDay timeOfDay) {
            this.viewEnd = timeOfDay;
        }

        @Override
        public DateInterval getInterval() {
            return this.interval;
        }

        public void setInterval(DateInterval dateInterval) throws Exception {
            this.interval = dateInterval;
        }

        @Override
        public String getDateHeader(Object object, Date date) throws Exception {
            return "mops";
        }

        @Override
        public String getDateFooter(Object object, Date date, List list) throws Exception {
            return "Puuups";
        }
    }
}

