/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.common.Calendar;
import bizcal.common.CalendarModel;
import bizcal.swing.CalendarSelectionListener;
import bizcal.swing.PopupMenuCallback;
import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.GradientArea;
import bizcal.swing.util.TableLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarList {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarList.class);
    private static int GRADIENT_TOP_HEIGHT = 30;
    private CalendarModel _broker;
    private TableLayoutPanel _panel;
    private JSplitPane _splitPanel = new JSplitPane(0);
    private Map _checkBoxes;
    private Set _listeners = new HashSet();
    private Object _currCalId;
    private int width;
    private Font font = new Font("Arial", 12, 10);
    private Color primaryColor;
    private Color secondaryColor;
    private PopupMenuCallback popupMenuCallback;
    private JLabel header;
    private JLabel groupName;
    private Object projectId;
    private List calendarList;

    public CalendarList(Object object, CalendarModel calendarModel) throws Exception {
        this.projectId = object;
        this.primaryColor = new Color(200, 200, 200);
        this.secondaryColor = Color.WHITE;
        this._broker = calendarModel;
        this.init();
    }

    public void setBroker(CalendarModel calendarModel) throws Exception {
        this._broker = calendarModel;
        this.init();
    }

    private void init() throws Exception {
        if (this._panel != null) {
            return;
        }
        this._panel = new TableLayoutPanel();
        this._panel.addComponentListener(new ThisComponentListener());
        this.build();
    }

    public void refresh() throws Exception {
        this._panel.deleteColumns();
        this._panel.deleteRows();
        this._panel.clear();
        this.build();
        this.fireCalendarsSelected();
    }

    private void build() throws Exception {
        Object object;
        this._panel.setBackground(Color.WHITE);
        this._panel.createColumn();
        this._panel.createColumn(-1.0);
        this._panel.createColumn(5.0);
        TableLayoutPanel.Row row = this._panel.createRow(30.0);
        TableLayoutPanel.Cell cell = row.createCell();
        cell.setColumnSpan(3);
        GradientArea gradientArea = new GradientArea("TOP_BOTTOM", this.secondaryColor, this.primaryColor);
        gradientArea.setGradientLength(0.5);
        if (this.header == null) {
            this.header = new JLabel("Planeringsgrupp", 0);
            this.header.setFont(this.font.deriveFont(1, 12.0f));
            this.header.setForeground(Color.WHITE);
        }
        gradientArea.add(this.header);
        gradientArea.setBorderWidth(0.2f);
        gradientArea.setBorderColor(Color.LIGHT_GRAY);
        cell.put(gradientArea);
        row = this._panel.createRow(20.0);
        cell = row.createCell();
        cell.setColumnSpan(3);
        GradientArea gradientArea2 = new GradientArea("TOP_BOTTOM", new Color(255, 255, 255), new Color(245, 245, 245));
        gradientArea2.setOpaque(true);
        cell.put(gradientArea2);
        String string = "Unknown";
        if (this.projectId != null) {
            string = "Calendars";
        }
        if (this.groupName == null) {
            this.groupName = new JLabel(string);
        }
        this.groupName.addMouseListener(new ProjectLabelMouseListener(this.projectId));
        this.groupName.setText(string);
        this.groupName.setFont(this.font);
        this.groupName.setForeground(Color.BLACK);
        gradientArea2.add(this.groupName);
        Map map = this._checkBoxes;
        this._checkBoxes = new HashMap();
        TableLayoutPanel tableLayoutPanel = new TableLayoutPanel();
        tableLayoutPanel.setBackground(Color.WHITE);
        tableLayoutPanel.createColumn(-1.0);
        tableLayoutPanel.createColumn(15.0);
        this.calendarList = this._broker.getCalendars();
        Iterator iterator = this.calendarList.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            JCheckBox jCheckBox;
            object = (Calendar)iterator.next();
            Object object2 = ((Calendar)object).getId();
            String string2 = ((Calendar)object).getSummary();
            TableLayoutPanel.Row row2 = tableLayoutPanel.createRow();
            JCheckBox jCheckBox2 = new JCheckBox(string2);
            jCheckBox2.addMouseListener(new CalMouseListener(object2));
            jCheckBox2.setFont(this.font);
            jCheckBox2.setOpaque(false);
            jCheckBox2.setActionCommand("select");
            CheckBoxListener checkBoxListener = new CheckBoxListener(jCheckBox2, ((Calendar)object).getId());
            jCheckBox2.addActionListener(checkBoxListener);
            this._checkBoxes.put(object2, jCheckBox2);
            if (bl && jCheckBox2.isEnabled()) {
                jCheckBox2.setSelected(true);
                bl = false;
            }
            if (map != null && (jCheckBox = (JCheckBox)map.get(object2)) != null) {
                jCheckBox2.setSelected(jCheckBox.isSelected());
            }
            row2.createCell(jCheckBox2);
            if (((Calendar)object).isEnabled()) continue;
            jCheckBox2.setEnabled(((Calendar)object).isEnabled());
            jCheckBox2.setFont(this.font.deriveFont(2));
        }
        object = new JScrollPane(tableLayoutPanel, 20, 31);
        ((JComponent)object).setBorder(null);
        this._splitPanel.setBackground(Color.WHITE);
        this._splitPanel.setBorder(null);
        this._splitPanel.setDividerSize(0);
        this._splitPanel.setTopComponent(this._panel);
        this._splitPanel.setBottomComponent((Component)object);
    }

    public JComponent getComponent() {
        return this._splitPanel;
    }

    public void addListener(CalendarSelectionListener calendarSelectionListener) {
        this._listeners.add(calendarSelectionListener);
    }

    private void fireCalendarsSelected() throws Exception {
        List list = this.getSelectedCalendars();
        for (CalendarSelectionListener calendarSelectionListener : this._listeners) {
            calendarSelectionListener.calendarSelected(list);
        }
    }

    public List getSelectedCalendars() throws Exception {
        ArrayList<Calendar> arrayList = new ArrayList<Calendar>();
        for (Calendar calendar : this.calendarList) {
            JCheckBox jCheckBox = (JCheckBox)this._checkBoxes.get(calendar.getId());
            if (jCheckBox == null || !jCheckBox.isSelected()) continue;
            arrayList.add(calendar);
        }
        return arrayList;
    }

    public void setPopupMenuCallback(PopupMenuCallback popupMenuCallback) {
        this.popupMenuCallback = popupMenuCallback;
    }

    public void setProjectId(Object object) {
        this.projectId = object;
    }

    private class ThisComponentListener
    extends ComponentAdapter {
        private ThisComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            try {
                CalendarList.this.width = CalendarList.this._panel.getWidth();
                CalendarList.this.header.setBounds(0, 0, CalendarList.this.width, GRADIENT_TOP_HEIGHT);
                CalendarList.this.groupName.setBounds(5, 0, CalendarList.this.width - 5, 20);
            }
            catch (Exception exception) {
                LOGGER.error("Can't resize component.");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                ErrorHandler.handleError(exception);
            }
        }
    }

    private class DeleteListener
    implements ActionListener {
        private DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CalendarList.this._broker.deleteCalendar(CalendarList.this._currCalId);
                CalendarList.this.refresh();
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }
    }

    private class ProjectLabelMouseListener
    extends MouseAdapter {
        public ProjectLabelMouseListener(Object object) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = CalendarList.this.popupMenuCallback != null ? CalendarList.this.popupMenuCallback.getProjectPopupMenu(CalendarList.this.projectId) : new JPopupMenu();
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }
    }

    private class CalMouseListener
    extends MouseAdapter {
        private Object _calId;

        public CalMouseListener(Object object) {
            this._calId = object;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            try {
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu;
                    CalendarList.this._currCalId = this._calId;
                    if (CalendarList.this.popupMenuCallback != null) {
                        jPopupMenu = CalendarList.this.popupMenuCallback.getCalendarPopupMenu(this._calId);
                    } else {
                        jPopupMenu = new JPopupMenu();
                        JMenuItem jMenuItem = new JMenuItem("Ta bort");
                        jPopupMenu.add(jMenuItem);
                        jMenuItem.addActionListener(new DeleteListener());
                    }
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        public CheckBoxListener(JCheckBox jCheckBox, Object object) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CalendarList.this.fireCalendarsSelected();
            }
            catch (Exception exception) {
                ErrorHandler.handleError(exception);
            }
        }
    }
}

