/*
 * Decompiled with CFR 0.152.
 */
package bizcal.swing;

import bizcal.swing.util.ErrorHandler;
import bizcal.swing.util.TableLayoutPanel;
import bizcal.util.BizcalException;
import bizcal.util.DateUtil;
import bizcal.util.StreamCopier;
import bizcal.util.TextUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DayStepper {
    private TableLayoutPanel panel;
    private Calendar cal;
    private JComboBox yearCombo;
    private JComboBox monthCombo;
    private JComboBox dayCombo;
    private List listeners = new ArrayList();
    private String fastRewindArrow = "/bizcal/res/go_fb.gif";
    private String prevArrow = "/bizcal/res/go_back.gif";
    private String nextArrow = "/bizcal/res/go_forward.gif";
    private String fastForwardArrow = "/bizcal/res/go_ff.gif";

    public DayStepper() throws Exception {
        this.cal = Calendar.getInstance(Locale.getDefault());
        this.cal.setTime(DateUtil.round2Day(new Date()));
        this.panel = new TableLayoutPanel();
        this.panel.createColumn();
        this.panel.createColumn();
        this.panel.createColumn(-1.0);
        this.panel.createColumn();
        this.panel.createColumn(10.0);
        this.panel.createColumn();
        this.panel.createColumn(10.0);
        this.panel.createColumn();
        this.panel.createColumn(-1.0);
        this.panel.createColumn();
        this.panel.createColumn();
        TableLayoutPanel.Row row = this.panel.createRow();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DayStepper.this.previousMonth();
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
            }
        };
        row.createCell(this.createButton(this.fastRewindArrow, actionListener));
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DayStepper.this.previous();
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
            }
        };
        row.createCell(this.createButton(this.prevArrow, actionListener));
        row.createCell();
        this.initYearCombo();
        this.initMonthCombo();
        this.initDayCombo();
        this.setCombos();
        row.createCell(this.yearCombo);
        row.createCell();
        row.createCell(this.monthCombo);
        row.createCell();
        row.createCell(this.dayCombo);
        row.createCell();
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DayStepper.this.next();
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
            }
        };
        row.createCell(this.createButton(this.nextArrow, actionListener));
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DayStepper.this.nextMonth();
                }
                catch (Exception exception) {
                    ErrorHandler.handleError(exception);
                }
            }
        };
        row.createCell(this.createButton(this.fastForwardArrow, actionListener));
    }

    private void initYearCombo() throws Exception {
        this.yearCombo = new JComboBox();
        int n = this.cal.get(1);
        for (int i = n - 1; i < n + 4; ++i) {
            this.yearCombo.addItem(i);
        }
        this.yearCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    int n = (Integer)DayStepper.this.yearCombo.getSelectedItem();
                    DayStepper.this.cal.set(1, n);
                }
                catch (Exception exception) {
                    throw BizcalException.create(exception);
                }
            }
        });
    }

    private void initMonthCombo() throws Exception {
        this.monthCombo = new JComboBox();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMMM", Locale.getDefault());
        int n = this.cal.get(2);
        for (int i = 0; i < 12; ++i) {
            this.cal.set(2, i);
            MonthWrapper monthWrapper = new MonthWrapper(i, TextUtil.formatCase(simpleDateFormat.format(this.cal.getTime())));
            this.monthCombo.addItem(monthWrapper);
        }
        this.cal.set(2, n);
        this.monthCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    int n = ((MonthWrapper)DayStepper.this.monthCombo.getSelectedItem()).getValue();
                    DayStepper.this.cal.set(2, n);
                    DayStepper.this.refreshDayCombo();
                }
                catch (Exception exception) {
                    throw BizcalException.create(exception);
                }
            }
        });
    }

    private void initDayCombo() throws Exception {
        this.dayCombo = new JComboBox();
        int n = this.cal.get(5);
        this.refreshDayCombo();
        this.dayCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Integer n = (Integer)DayStepper.this.dayCombo.getSelectedItem();
                if (n == null) {
                    return;
                }
                int n2 = (Integer)DayStepper.this.dayCombo.getSelectedItem();
                DayStepper.this.cal.set(5, n2);
            }
        });
        this.cal.set(5, n);
    }

    private void setCombos() {
        int n = this.cal.get(1);
        this.yearCombo.setSelectedItem(n);
        int n2 = this.cal.get(2);
        this.monthCombo.setSelectedIndex(n2);
        int n3 = this.cal.get(5);
        this.dayCombo.setSelectedItem(n3);
    }

    private void refreshDayCombo() {
        Integer n = (Integer)this.dayCombo.getSelectedItem();
        int n2 = 1;
        if (n != null) {
            n2 = n;
        }
        this.dayCombo.removeAllItems();
        int n3 = this.cal.getActualMaximum(5);
        for (int i = 1; i <= n3; ++i) {
            this.dayCombo.addItem(i);
        }
        this.dayCombo.setSelectedItem(n2);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public Date getDate() {
        return this.cal.getTime();
    }

    private void next() throws Exception {
        this.cal.add(5, 1);
        this.setCombos();
        this.fireStateChanged();
    }

    private void previous() throws Exception {
        this.cal.add(5, -1);
        this.setCombos();
        this.fireStateChanged();
    }

    private void nextMonth() throws Exception {
        this.cal.add(2, 1);
        this.setCombos();
        this.fireStateChanged();
    }

    private void previousMonth() throws Exception {
        this.cal.add(2, -1);
        this.setCombos();
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    private void fireStateChanged() throws Exception {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private Icon getIcon(String string) throws Exception {
        byte[] byArray = StreamCopier.copyToByteArray(this.getClass().getResourceAsStream(string));
        return new ImageIcon(byArray);
    }

    private JComponent createButton(String string, ActionListener actionListener) throws Exception {
        JButton jButton = new JButton(this.getIcon(string));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public void setDate(Date date) throws Exception {
        this.cal.setTime(DateUtil.round2Day(date));
        this.setCombos();
        this.fireStateChanged();
    }

    private class MonthWrapper {
        private int value;
        private String caption;

        public MonthWrapper(int n, String string) {
            this.value = n;
            this.caption = string;
        }

        public String toString() {
            return this.caption;
        }

        public int getValue() {
            return this.value;
        }
    }
}

