/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs.prices;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.values.CurrencyValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Locale;

public final class MarketValue
extends ComplexCurrencyAttrib {
    public MarketValue() {
        super(OpenEstateAttrib.PRICES_MARKET_VALUE, null);
    }

    public MarketValue(CurrencyValue currencyValue) {
        this();
        this.setValue(currencyValue);
    }

    public MarketValue(Number number, Currency currency) {
        this();
        if (number != null) {
            this.setValue(CurrencyValue.parse(number, currency));
        }
    }

    public static CurrencyValue get(EstateImpl estateImpl) {
        return MarketValue.get(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE);
    }

    public static BigDecimal getAsBigDecimal(EstateImpl estateImpl) {
        return MarketValue.getAsBigDecimal(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE);
    }

    public static BigInteger getAsBigInteger(EstateImpl estateImpl) {
        return MarketValue.getAsBigInteger(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE);
    }

    public static Double getAsDouble(EstateImpl estateImpl) {
        return MarketValue.getAsDouble(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE);
    }

    public static Float getAsFloat(EstateImpl estateImpl) {
        return MarketValue.getAsFloat(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE);
    }

    public static Integer getAsInteger(EstateImpl estateImpl) {
        return MarketValue.getAsInteger(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE);
    }

    public static Long getAsLong(EstateImpl estateImpl) {
        return MarketValue.getAsLong(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE);
    }

    public static String getAsString(EstateImpl estateImpl) {
        return MarketValue.getAsString(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE);
    }

    public static String getAsString(EstateImpl estateImpl, Locale locale) {
        return MarketValue.getAsString(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE, locale);
    }

    public static void put(EstateImpl estateImpl, String string) {
        MarketValue.put(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE, string);
    }

    public static void put(EstateImpl estateImpl, Number number) {
        MarketValue.put(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE, number);
    }

    public static void put(EstateImpl estateImpl, CurrencyValue currencyValue) {
        MarketValue.put(estateImpl, OpenEstateAttrib.PRICES_MARKET_VALUE, currencyValue);
    }
}

