/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db;

import com.openindex.openestate.impl.EstateLinkProvider;
import com.openindex.openestate.impl.db.DbHandlerImpl;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbLink;
import com.openindex.openestate.impl.db.DbLinksHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbLinksHandlerImpl
extends DbHandlerImpl
implements DbLinksHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLinksHandlerImpl.class);

    protected DbLinksHandlerImpl() {
        super(null);
    }

    protected DbLinksHandlerImpl(String string) {
        super(string);
    }

    protected DbLink createLink() {
        return new DbLink();
    }

    @Override
    public final DbLink getLink(Connection connection, long l) throws SQLException {
        DbLink[] dbLinkArray = this.getLinks(connection, new long[]{l});
        return dbLinkArray != null && dbLinkArray.length > 0 ? dbLinkArray[0] : null;
    }

    @Override
    public final DbLink[] getLinks(Connection connection) throws SQLException {
        return this.getLinks(connection, null);
    }

    @Override
    public abstract DbLink[] getLinks(Connection var1, long[] var2) throws SQLException;

    @Override
    public abstract DbLink[] getLinks(Connection var1, long var2, Boolean var4, EstateLinkProvider var5) throws SQLException;

    @Override
    public final long[] getLinkIds(Connection connection) throws SQLException {
        return this.getLinkIds(connection, 0L, null, null);
    }

    @Override
    public abstract long[] getLinkIds(Connection var1, long var2, Boolean var4, EstateLinkProvider var5) throws SQLException;

    @Override
    public final void loadLinkTranslations(Connection connection, DbLink dbLink, DbLanguagesHandler dbLanguagesHandler) throws SQLException {
        if (dbLink != null) {
            this.loadLinkTranslations(connection, new DbLink[]{dbLink}, dbLanguagesHandler);
        }
    }

    @Override
    public final void loadLinkTranslations(Connection connection, DbLink dbLink, Map<Long, String> map) throws SQLException {
        if (dbLink != null) {
            this.loadLinkTranslations(connection, new DbLink[]{dbLink}, map);
        }
    }

    @Override
    public final void loadLinkTranslations(Connection connection, DbLink[] dbLinkArray, DbLanguagesHandler dbLanguagesHandler) throws SQLException {
        this.loadLinkTranslations(connection, dbLinkArray, dbLanguagesHandler.getLanguageMap(connection, true));
    }

    @Override
    public abstract void loadLinkTranslations(Connection var1, DbLink[] var2, Map<Long, String> var3) throws SQLException;

    @Override
    public final void removeLink(Connection connection, long l) throws SQLException {
        this.removeLinks(connection, new long[]{l});
    }

    @Override
    public abstract void removeLinks(Connection var1, long[] var2) throws SQLException;

    @Override
    public final void saveLink(Connection connection, DbLink dbLink) throws SQLException {
        this.saveLink(connection, dbLink, (Map<Long, String>)null);
    }

    @Override
    public final void saveLink(Connection connection, DbLink dbLink, DbLanguagesHandler dbLanguagesHandler) throws SQLException {
        Map<Long, String> map = dbLanguagesHandler != null && dbLink.translations != null ? dbLanguagesHandler.getLanguageMap(connection, true) : null;
        this.saveLink(connection, dbLink, map);
    }

    @Override
    public abstract void saveLink(Connection var1, DbLink var2, Map<Long, String> var3) throws SQLException;
}

