/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.tool.server.utils;

import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class SslGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslGenerator.class);
    private static final I18n I18N = I18nFactory.getI18n(SslGenerator.class);
    private static final String ALIAS = "OpenEstate-ImmoServer";
    private static final String PROVIDER = "BC";
    private static final String KEY_ALGORITHM = "RSA";
    private static final int KEY_LENGTH = 4096;
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";

    private SslGenerator() {
    }

    private static ContentSigner createSigner(PrivateKey privateKey) {
        try {
            AlgorithmIdentifier algorithmIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find(SIGNATURE_ALGORITHM);
            AlgorithmIdentifier algorithmIdentifier2 = new DefaultDigestAlgorithmIdentifierFinder().find(algorithmIdentifier);
            return new BcRSAContentSignerBuilder(algorithmIdentifier, algorithmIdentifier2).build(PrivateKeyFactory.createKey((byte[])privateKey.getEncoded()));
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create content signer.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Comparable<Date> comparable;
        Object object;
        Serializable serializable;
        Serializable serializable2;
        KeyPairGenerator keyPairGenerator;
        Object object2;
        char[] cArray;
        String string;
        Console console = System.console();
        String string2 = StringUtils.repeat((String)"-", (int)75);
        console.writer().println(string2);
        console.writer().println(I18N.tr("Generate RSA keypair and certificate for SSL encryption."));
        console.writer().println(string2);
        console.writer().println("");
        Security.addProvider((Provider)new BouncyCastleProvider());
        String string3 = string = stringArray.length > 0 ? StringUtils.trimToNull((String)stringArray[0]) : null;
        while (string == null) {
            console.writer().print(I18N.tr("Enter the ip-address / hostname of this server:") + " ");
            console.writer().flush();
            string = StringUtils.trimToNull((String)console.readLine());
        }
        char[] cArray2 = cArray = stringArray.length > 1 ? StringUtils.trimToEmpty((String)stringArray[1]).toCharArray() : null;
        if (cArray == null) {
            while (cArray == null) {
                console.writer().print(I18N.tr("Enter the password to access the keystore:") + " ");
                console.writer().flush();
                cArray = console.readPassword();
            }
            console.writer().print(I18N.tr("Enter the password to access the keystore again:") + " ");
            console.writer().flush();
            object2 = console.readPassword();
            if (!StringUtils.equals((CharSequence)String.valueOf(cArray), (CharSequence)String.valueOf((char[])object2))) {
                console.writer().println(I18N.tr("Error!"));
                console.writer().println(I18N.tr("The provided passwords do not match."));
                System.exit(1);
            }
        }
        console.writer().println("");
        console.writer().println(string2);
        console.writer().println(I18N.tr("Creating files for SSL encryption..."));
        console.writer().println(string2);
        console.writer().println("");
        object2 = new File(new File("etc"), "ssl");
        if (!((File)object2).exists() && !((File)object2).mkdirs()) {
            LOGGER.error("Can't create ssl directory at '" + ((File)object2).getAbsolutePath() + "'!");
            System.exit(1);
            return;
        }
        FileOutputStream fileOutputStream = null;
        PemWriter pemWriter = null;
        SecureRandom secureRandom = new SecureRandom();
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM, PROVIDER);
            keyPairGenerator.initialize(4096, secureRandom);
        }
        catch (Exception exception) {
            LOGGER.error("Can't initialize key generator!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
            return;
        }
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        try {
            serializable2 = new File((File)object2, "private.key");
            FileUtils.deleteQuietly((File)serializable2);
            console.writer().println(I18N.tr("Writing private key to {0}.", (Object)("'" + ((File)serializable2).getAbsolutePath() + "'")));
            pemWriter = new PemWriter((Writer)new FileWriterWithEncoding((File)serializable2, "UTF-8"));
            pemWriter.writeObject((PemObjectGenerator)new PemObject("OpenEstate-ImmoServer / Private Key", privateKey.getEncoded()));
            pemWriter.flush();
            IOUtils.closeQuietly((Writer)pemWriter);
        }
        catch (Exception exception) {
            LOGGER.error("Can't export private key!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
            return;
        }
        finally {
            IOUtils.closeQuietly(pemWriter);
        }
        serializable2 = keyPair.getPublic();
        try {
            serializable = new File((File)object2, "public.key");
            FileUtils.deleteQuietly((File)serializable);
            console.writer().println(I18N.tr("Writing public key to {0}.", (Object)("'" + ((File)serializable).getAbsolutePath() + "'")));
            pemWriter = new PemWriter((Writer)new FileWriterWithEncoding((File)serializable, "UTF-8"));
            pemWriter.writeObject((PemObjectGenerator)new PemObject("OpenEstate-ImmoServer / Public Key", serializable2.getEncoded()));
            pemWriter.flush();
        }
        catch (Exception exception) {
            LOGGER.error("Can't export public key!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
            return;
        }
        finally {
            IOUtils.closeQuietly((Writer)pemWriter);
        }
        try {
            object = new Date();
            comparable = DateUtils.addYears((Date)object, (int)10);
            X500Name x500Name = new X500Name("CN=" + string);
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)serializable2.getEncoded());
            BigInteger bigInteger = BigInteger.valueOf(secureRandom.nextLong()).abs();
            X509v3CertificateBuilder x509v3CertificateBuilder = new X509v3CertificateBuilder(x500Name, bigInteger, (Date)object, (Date)comparable, x500Name, subjectPublicKeyInfo);
            X509ExtensionUtils x509ExtensionUtils = new X509ExtensionUtils(new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1)));
            x509v3CertificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)x509ExtensionUtils.createSubjectKeyIdentifier(subjectPublicKeyInfo));
            X509CertificateHolder x509CertificateHolder = x509v3CertificateBuilder.build(SslGenerator.createSigner(privateKey));
            serializable = new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
            File file = new File((File)object2, "private.crt");
            FileUtils.deleteQuietly((File)file);
            console.writer().println(I18N.tr("Writing certificate to {0}.", (Object)("'" + file.getAbsolutePath() + "'")));
            pemWriter = new PemWriter((Writer)new FileWriterWithEncoding(file, "UTF-8"));
            pemWriter.writeObject((PemObjectGenerator)new PemObject("OpenEstate-ImmoServer / Certificate", ((Certificate)serializable).getEncoded()));
            pemWriter.flush();
        }
        catch (Exception exception) {
            LOGGER.error("Can't create certificate!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
            return;
        }
        finally {
            IOUtils.closeQuietly((Writer)pemWriter);
        }
        try {
            object = KeyStore.getInstance("jks");
            ((KeyStore)object).load(null, cArray);
            ((KeyStore)object).setKeyEntry(ALIAS, privateKey, cArray, new Certificate[]{serializable});
            comparable = new File((File)object2, "keystore.jks");
            FileUtils.deleteQuietly((File)comparable);
            console.writer().println(I18N.tr("Writing keystore to {0}.", (Object)("'" + ((File)comparable).getAbsolutePath() + "'")));
            fileOutputStream = new FileOutputStream((File)comparable);
            ((KeyStore)object).store(fileOutputStream, cArray);
            fileOutputStream.flush();
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            LOGGER.error("Can't create keystore!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            System.exit(1);
            return;
        }
        finally {
            IOUtils.closeQuietly(fileOutputStream);
        }
        console.writer().println("");
        console.writer().println(string2);
        console.writer().println(I18N.tr("SSL encryption was successfully prepared!"));
        console.writer().println(string2);
        console.writer().println("");
        console.writer().println(I18N.tr("Follow these steps in order to enable SSL encryption."));
        console.writer().println("");
        console.writer().println("(1) " + I18N.tr("Open the following configuration file with a text editor:"));
        console.writer().println("");
        console.writer().println(new File("etc", "server.properies").getAbsolutePath());
        console.writer().println("");
        console.writer().println("(2) " + I18N.tr("Change the following values in the configuration file:"));
        console.writer().println("");
        console.writer().println("server.tls=true");
        console.writer().println("system.javax.net.ssl.keyStore=./etc/ssl/keystore.jks");
        console.writer().println("system.javax.net.ssl.keyStorePassword=" + String.valueOf(cArray));
        console.writer().println("");
        console.writer().println("(3) " + I18N.tr("Restart {0}.", (Object)ALIAS));
        console.writer().println("");
        console.writer().println(string2);
        console.writer().println("");
    }
}

