/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.attribs;

import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAttrib;
import com.openindex.openestate.impl.values.LengthValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexLengthAttrib
extends ComplexAttrib<LengthValue> {
    private static final long serialVersionUID = 3007628100197533765L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexLengthAttrib.class);
    private static final String XML_ATTRIB_UNIT = "Unit";
    private LengthValue value = null;

    public ComplexLengthAttrib(OpenEstateAttrib openEstateAttrib, String[] stringArray) {
        super(openEstateAttrib, stringArray);
    }

    @Override
    public LengthValue getDefaultValue() {
        return new LengthValue(BigDecimal.ZERO, null);
    }

    protected static LengthValue get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib) {
        return ComplexLengthAttrib.get(estateImpl, openEstateAttrib, LengthValue.Unit.getBaseUnit());
    }

    protected static LengthValue get(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, LengthValue.Unit unit) {
        try {
            ComplexLengthAttrib complexLengthAttrib = (ComplexLengthAttrib)estateImpl.getAttribute(openEstateAttrib);
            if (complexLengthAttrib == null) {
                return null;
            }
            LengthValue lengthValue = complexLengthAttrib.getValue();
            return unit == null || unit == lengthValue.getUnit() ? lengthValue : new LengthValue(LengthValue.convert(lengthValue, unit), unit);
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as LengthValue!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected static BigDecimal getAsBigDecimal(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, LengthValue.Unit unit) {
        LengthValue lengthValue = ComplexLengthAttrib.get(estateImpl, openEstateAttrib, unit);
        return lengthValue != null ? lengthValue.getValue() : null;
    }

    protected static BigInteger getAsBigInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, LengthValue.Unit unit) {
        LengthValue lengthValue = ComplexLengthAttrib.get(estateImpl, openEstateAttrib, unit);
        return lengthValue != null ? lengthValue.getValue().toBigInteger() : null;
    }

    protected static Double getAsDouble(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, LengthValue.Unit unit) {
        LengthValue lengthValue = ComplexLengthAttrib.get(estateImpl, openEstateAttrib, unit);
        return lengthValue != null ? Double.valueOf(lengthValue.doubleValue()) : null;
    }

    protected static Float getAsFloat(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, LengthValue.Unit unit) {
        LengthValue lengthValue = ComplexLengthAttrib.get(estateImpl, openEstateAttrib, unit);
        return lengthValue != null ? Float.valueOf(lengthValue.floatValue()) : null;
    }

    protected static Integer getAsInteger(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, LengthValue.Unit unit) {
        LengthValue lengthValue = ComplexLengthAttrib.get(estateImpl, openEstateAttrib, unit);
        return lengthValue != null ? Integer.valueOf(lengthValue.intValue()) : null;
    }

    protected static Long getAsLong(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, LengthValue.Unit unit) {
        LengthValue lengthValue = ComplexLengthAttrib.get(estateImpl, openEstateAttrib, unit);
        return lengthValue != null ? Long.valueOf(lengthValue.longValue()) : null;
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, LengthValue.Unit unit) {
        return ComplexLengthAttrib.getAsString(estateImpl, openEstateAttrib, unit, null);
    }

    protected static String getAsString(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, LengthValue.Unit unit, Locale locale) {
        try {
            LengthValue lengthValue = ComplexLengthAttrib.get(estateImpl, openEstateAttrib, unit);
            AbstractAttribImpl abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
            return lengthValue != null && abstractAttribImpl != null ? abstractAttribImpl.getFormattedValue(lengthValue, locale) : null;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read attribute \"" + openEstateAttrib + "\" as String!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public final NumberFormat getFormat() {
        return this.getFormat(null);
    }

    public final NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(0);
        return numberFormat;
    }

    @Override
    public String getFormattedValue(LengthValue lengthValue, Locale locale, String string) {
        if (lengthValue == null) {
            return "";
        }
        String string2 = OpenEstateUtils.isApproximatedAttributes() ? OpenEstateConstant.APPROX.getTranslation(locale) + " " : "";
        return string2 + this.getFormat(locale).format(lengthValue.getValue()) + " " + lengthValue.getUnit().write();
    }

    @Override
    public LengthValue getValue() {
        return this.value;
    }

    @Override
    protected LengthValue parseNode(Element element) {
        LengthValue.Unit unit;
        if (element == null) {
            return null;
        }
        Number number = OpenEstateUtils.parseNumber(element.getStringValue(), this.getFormat());
        Node node = element.selectSingleNode("@Unit");
        String string = StringUtils.trimToNull((String)(node != null ? node.getStringValue() : null));
        try {
            unit = string != null ? LengthValue.Unit.valueOf(string.toUpperCase()) : LengthValue.Unit.M;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't parse length unit \"" + string + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
        return number != null ? LengthValue.parse(number, unit) : null;
    }

    @Override
    public LengthValue parseValue(Object object) {
        return LengthValue.parse(object);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, String string, LengthValue.Unit unit) {
        ComplexLengthAttrib.put(estateImpl, openEstateAttrib, string != null ? LengthValue.parse(string, unit) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, Number number, LengthValue.Unit unit) {
        ComplexLengthAttrib.put(estateImpl, openEstateAttrib, number != null ? LengthValue.parse(number, unit) : null);
    }

    protected static void put(EstateImpl estateImpl, OpenEstateAttrib openEstateAttrib, LengthValue lengthValue) {
        try {
            if (lengthValue == null) {
                estateImpl.removeAttribute(openEstateAttrib);
            } else {
                ComplexLengthAttrib complexLengthAttrib = (ComplexLengthAttrib)openEstateAttrib.createImpl();
                complexLengthAttrib.setValue(lengthValue);
                estateImpl.putAttribute(complexLengthAttrib);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't put length attribute \"" + openEstateAttrib + "\"!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    @Override
    public void setValue(LengthValue lengthValue) {
        this.value = lengthValue;
    }

    @Override
    protected void writeNode(Element element, LengthValue lengthValue) {
        if (element == null || lengthValue == null || lengthValue.getValue() == null) {
            return;
        }
        try {
            element.setText(lengthValue.getValue().toString());
            element.addAttribute(XML_ATTRIB_UNIT, lengthValue.getUnit() != null ? lengthValue.getUnit().name() : LengthValue.Unit.M.name());
        }
        catch (Exception exception) {
            LOGGER.warn("Can't write length attribute!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }
}

